/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geoserver.rest.decoder;

import it.geosolutions.geoserver.rest.decoder.utils.JDOMListIterator;
import it.geosolutions.geoserver.rest.decoder.utils.NameLinkElem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jdom.Element;

public class RESTAbstractList<ELEM extends NameLinkElem>
implements Iterable<ELEM> {
    protected final List<Element> elementList;

    protected RESTAbstractList(Element list) {
        ArrayList<Element> tempList = new ArrayList<Element>();
        String baseName = null;
        for (Element listItem : list.getChildren()) {
            if (baseName == null) {
                baseName = listItem.getName();
            } else if (!baseName.equals(listItem.getName())) {
                throw new RuntimeException("List elements mismatching (" + baseName + "," + listItem.getName() + ")");
            }
            tempList.add(listItem);
        }
        this.elementList = Collections.unmodifiableList(tempList);
    }

    public int size() {
        return this.elementList.size();
    }

    public boolean isEmpty() {
        return this.elementList.isEmpty();
    }

    public ELEM get(int index) {
        return this.createElement(this.elementList.get(index));
    }

    @Override
    public Iterator<ELEM> iterator() {
        return new RESTAbstractListIterator(this.elementList);
    }

    public List<String> getNames() {
        ArrayList<String> names = new ArrayList<String>(this.elementList.size());
        for (NameLinkElem elem : this) {
            names.add(elem.getName());
        }
        return names;
    }

    protected ELEM createElement(Element el) {
        return (ELEM)new NameLinkElem(el);
    }

    private class RESTAbstractListIterator
    extends JDOMListIterator<ELEM> {
        public RESTAbstractListIterator(List<Element> orig) {
            super(orig);
        }

        @Override
        public ELEM transform(Element listItem) {
            return RESTAbstractList.this.createElement(listItem);
        }
    }
}

