/*
 *  GeoServer-Manager - Simple Manager Library for GeoServer
 *  
 *  Copyright (C) 2007,2011 GeoSolutions S.A.S.
 *  http://www.geo-solutions.it
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package it.geosolutions.geoserver.rest.decoder;

import it.geosolutions.geoserver.rest.decoder.utils.NameLinkElem;
import it.geosolutions.geoserver.rest.decoder.utils.JDOMBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

import org.jdom.Element;

/**
 * Parses list of summary data about Workspaces.
 * <BR>Single items are handled by {@link RESTShortWorkspace}.

 * @author ETj (etj at geo-solutions.it)
 */
public class RESTWorkspaceList implements Iterable<RESTWorkspaceList.RESTShortWorkspace> {

    private final List<Element> wsList;

    public static RESTWorkspaceList build(String response) {
        if(response == null)
            return null;

        Element elem = JDOMBuilder.buildElement(response);
        if(elem != null)
            return new RESTWorkspaceList(elem);
        else
            return null;
	}

    protected RESTWorkspaceList(Element wslistroot) {
        List<Element> tmpList = new ArrayList<Element>();
        for (Element wselem : (List<Element>) wslistroot.getChildren("workspace")) {
            tmpList.add(wselem);
        }

        wsList = Collections.unmodifiableList(tmpList);
    }

    public int size() {
        return wsList.size();
    }

    public boolean isEmpty() {
        return wsList.isEmpty();
    }

    public RESTShortWorkspace get(int index) {
        return new RESTShortWorkspace(wsList.get(index));
    }

    public Iterator<RESTShortWorkspace> iterator() {
        return new RESTWSListIterator(wsList);
    }


    private static class RESTWSListIterator implements Iterator<RESTShortWorkspace> {

        private final Iterator<Element> iter;

        public RESTWSListIterator(List<Element> orig) {
            iter = orig.iterator();
        }        

        public boolean hasNext() {
            return iter.hasNext();
        }

        public RESTShortWorkspace next() {
            return new RESTShortWorkspace(iter.next());
        }

        public void remove() {
            throw new UnsupportedOperationException("Not supported.");
        }
    }

    /**
     * Workspace summary info.
     * <BR>This is an XML fragment:
     * <PRE>
     * {@code
     *   <workspace>
     *      <name>it.geosolutions</name>
     *      <atom:link xmlns:atom="http://www.w3.org/2005/Atom"
     *          rel="alternate"
     *          href="http://localhost:8080/geoserver/rest/workspaces/it.geosolutions.xml"
     *          type="application/xml"/>
     *  </workspace>
     * }
     * </PRE>
     */

    public static class RESTShortWorkspace extends NameLinkElem {

        public RESTShortWorkspace(Element elem) {
            super(elem);
        }
    }

}
