/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geonetwork.util;

import it.geosolutions.geonetwork.util.GNPriv;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

public class GNPrivConfiguration {
    public static final int GROUP_GUEST = -1;
    public static final int GROUP_INTRANET = 0;
    public static final int GROUP_ALL = 1;
    private List<Privileges> privileges = new ArrayList<Privileges>();

    public List<Privileges> getPrivileges() {
        return this.privileges;
    }

    protected void setPrivileges(List<Privileges> privileges) {
        this.privileges = privileges;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPrivileges(Integer groupCode, String ops) {
        GNPrivConfiguration gNPrivConfiguration = this;
        synchronized (gNPrivConfiguration) {
            if (this.privileges == null) {
                this.privileges = new ArrayList<Privileges>();
            }
        }
        if (!ops.matches("0?1?2?3?4?5?6?")) {
            throw new IllegalArgumentException("Unrecognized privileges set '" + ops + "'");
        }
        this.privileges.add(new Privileges(groupCode, ops));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPrivileges(Integer groupCode, EnumSet<GNPriv> privs) {
        GNPrivConfiguration gNPrivConfiguration = this;
        synchronized (gNPrivConfiguration) {
            if (this.privileges == null) {
                this.privileges = new ArrayList<Privileges>();
            }
        }
        StringBuilder sb = new StringBuilder();
        for (GNPriv priv : privs) {
            sb.append(priv.getId());
        }
        this.addPrivileges(groupCode, sb.toString());
    }

    public static class Privileges {
        Integer group;
        String ops;

        public Privileges(Integer group, String ops) {
            this.group = group;
            this.ops = ops;
        }

        public Integer getGroup() {
            return this.group;
        }

        public void setGroup(Integer group) {
            this.group = group;
        }

        public String getOps() {
            return this.ops;
        }

        public void setOps(String ops) {
            this.ops = ops;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Privileges other = (Privileges)obj;
            if (!(this.group == other.group || this.group != null && this.group.equals(other.group))) {
                return false;
            }
            return !(this.ops == null ? other.ops != null : !this.ops.equals(other.ops));
        }

        public int hashCode() {
            int hash = 3;
            hash = 37 * hash + (this.group != null ? this.group.hashCode() : 0);
            hash = 37 * hash + (this.ops != null ? this.ops.hashCode() : 0);
            return hash;
        }
    }
}

