/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geonetwork.op;

import it.geosolutions.geonetwork.exception.GNLibException;
import it.geosolutions.geonetwork.exception.GNServerException;
import it.geosolutions.geonetwork.util.GNInsertConfiguration;
import it.geosolutions.geonetwork.util.HTTPUtils;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import org.apache.log4j.Logger;
import org.jdom.CDATA;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class GNMetadataInsert {
    private static final Logger LOGGER = Logger.getLogger(GNMetadataInsert.class);

    public static long insertMetadata(HTTPUtils connection, String gnServiceURL, File inputFile, GNInsertConfiguration cfg) throws GNLibException, GNServerException {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Handling pure metadata file " + inputFile));
        }
        Element insertRequest = GNMetadataInsert.buildInsertRequest(inputFile, cfg);
        LOGGER.debug((Object)"Creating metadata");
        long metadataId = GNMetadataInsert.gnInsertMetadata(connection, gnServiceURL, insertRequest);
        LOGGER.info((Object)("Created metadata " + metadataId));
        return metadataId;
    }

    public static long insertRequest(HTTPUtils connection, String gnServiceURL, File inputFile) throws GNLibException, GNServerException {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Handling full request file " + inputFile));
        }
        Element insertRequest = GNMetadataInsert.parseFile(inputFile);
        LOGGER.debug((Object)"Creating metadata");
        long metadataId = GNMetadataInsert.gnInsertMetadata(connection, gnServiceURL, insertRequest);
        LOGGER.info((Object)("Created metadata " + metadataId));
        return metadataId;
    }

    private static Element buildInsertRequest(File inputFile, GNInsertConfiguration cfg) throws GNLibException, GNServerException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Compiling request document");
        }
        Element metadataFromFile = GNMetadataInsert.parseFile(inputFile);
        XMLOutputter outputter = new XMLOutputter(Format.getRawFormat());
        CDATA cdata = new CDATA(outputter.outputString(metadataFromFile));
        Element request = new Element("request");
        request.addContent((Content)new Element("data").addContent((Content)cdata));
        request.addContent((Content)new Element("group").setText(cfg.getGroup()));
        request.addContent((Content)new Element("category").setText(cfg.getCategory() == null ? "_none" : cfg.getCategory()));
        request.addContent((Content)new Element("styleSheet").setText(cfg.getStyleSheet() == null ? "_none" : cfg.getStyleSheet()));
        request.addContent((Content)new Element("validate").setText(cfg.getValidate() == null ? "off" : (cfg.getValidate() != false ? "on" : "off")));
        return request;
    }

    private static long gnInsertMetadata(HTTPUtils connection, String baseURL, Element gnRequest) throws GNLibException, GNServerException {
        String serviceURL = baseURL + "/srv/en/xml.metadata.insert";
        String res = GNMetadataInsert.gnPut(connection, serviceURL, gnRequest);
        if (connection.getLastHttpStatus() != 200) {
            throw new GNServerException("Error inserting metadata in GeoNetwork (HTTP code " + connection.getLastHttpStatus() + ")");
        }
        Element rese = GNMetadataInsert.parse(res);
        try {
            return Long.parseLong(rese.getChildText("id"));
        }
        catch (Exception e) {
            LOGGER.error((Object)("Error parsing metadata id from: " + res));
            throw new GNLibException("Error parsing metadata id", e);
        }
    }

    private static String gnPut(HTTPUtils connection, String serviceURL, Element gnRequest) throws GNLibException, GNServerException {
        XMLOutputter outputter = new XMLOutputter(Format.getCompactFormat());
        String s = outputter.outputString(gnRequest);
        connection.setIgnoreResponseContentOnSuccess(false);
        String res = connection.postXml(serviceURL, s);
        return res;
    }

    private static Element parseFile(File file) throws GNLibException {
        try {
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build(file);
            return (Element)doc.getRootElement().detach();
        }
        catch (Exception ex) {
            LOGGER.warn((Object)("Error parsing input file " + file));
            throw new GNLibException("Error parsing input file " + file, ex);
        }
    }

    private static Element parse(String s) throws GNLibException {
        try {
            SAXBuilder builder = new SAXBuilder();
            s = s.trim();
            Document doc = builder.build((Reader)new StringReader(s));
            return (Element)doc.getRootElement().detach();
        }
        catch (Exception ex) {
            LOGGER.warn((Object)("Error parsing input string: >>>" + s + "<<<"));
            throw new GNLibException("Error parsing input string", ex);
        }
    }
}

