package org.gcube.vremanagement.executor.ispublisher;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.gcube.smartgears.context.application.ApplicationContext;
import org.gcube.vremanagement.executor.plugin.Plugin;

/**
 * Abstract base class for Information System publishers.
 * This class manages the publishing and unpublishing of plugins to the gCube Information System.
 * 
 * @author Luca Frosini (ISTI - CNR)
 */
public abstract class ISPublisher {
	
	/**
	 * List of available IS publishers.
	 */
	protected static List<ISPublisher> isPublishers;

	/**
	 * Get the list of available IS publishers.
	 * @param applicationContext the application context
	 * @return the list of IS publishers
	 */
	public synchronized static List<ISPublisher> getISPublishers(ApplicationContext applicationContext){
		if(isPublishers==null) {
			isPublishers = new ArrayList<>();
			isPublishers.add(new GCoreISPublisher(applicationContext));
			// isPublishers.add(new RestISPublisher(applicationContext));
		}
		return isPublishers;
	}
	
	/**
	 * The application context.
	 */
	protected ApplicationContext applicationContext;
	
	/**
	 * Constructor.
	 * @param applicationContext the application context
	 */
	public ISPublisher(ApplicationContext applicationContext) {
		this.applicationContext = applicationContext;
	}
	
	/**
	 * Publish the available plugins to the Information System.
	 * @param availablePlugins map of available plugins
	 * @throws Exception if the publishing fails
	 */
	public abstract void publishPlugins(Map<String, Class<? extends Plugin>> availablePlugins) throws Exception;
	
	/**
	 * Unpublish plugins from the Information System.
	 * @param force whether to force the unpublishing even if some plugins are still running
	 * @throws Exception if the unpublishing fails
	 */
	public abstract void unpublishPlugins(boolean force) throws Exception ;
	
}
