/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.executor.rest;

import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;
import org.gcube.vremanagement.executor.exception.InputsNullException;
import org.gcube.vremanagement.executor.exception.InvalidInputsException;
import org.gcube.vremanagement.executor.exception.PluginInstanceNotFoundException;
import org.gcube.vremanagement.executor.exception.PluginNotFoundException;

@Provider
public class ExecutorExceptionMapper
implements ExceptionMapper<Exception> {
    public Response toResponse(Exception exception) {
        Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
        String exceptionMessage = exception.getMessage();
        MediaType mediaType = MediaType.TEXT_PLAIN_TYPE;
        Class<?> clz = exception.getClass();
        if (WebApplicationException.class.isAssignableFrom(clz)) {
            Response gotResponse = ((WebApplicationException)exception).getResponse();
            status = Response.Status.fromStatusCode((int)gotResponse.getStatusInfo().getStatusCode());
        }
        if (PluginInstanceNotFoundException.class.isAssignableFrom(clz) || PluginNotFoundException.class.isAssignableFrom(clz)) {
            status = Response.Status.NOT_FOUND;
        }
        if (InputsNullException.class.isAssignableFrom(clz) || InvalidInputsException.class.isAssignableFrom(clz)) {
            status = Response.Status.BAD_REQUEST;
        }
        return Response.status((Response.Status)status).entity((Object)exceptionMessage).type(mediaType).build();
    }
}

