/**
 * 
 */
package org.gcube.vremanagement.executor.exception;

import java.io.Serial;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
public class InputsNullException extends ExecutorException {

	/**
	 * Generated Serial Version UID
	 */
	@Serial
	private static final long serialVersionUID = 7578814354528161119L;

	private static final String DEFAULT_MESSAGE = "Inputs cannot be null. Use an Empty Map instead.";
	
	/**
	 * Default constructor with default message.
	 */
	public InputsNullException() {
		super(DEFAULT_MESSAGE);
	}
	
	/**
	 * Constructor with cause.
	 * @param cause the underlying cause
	 */
	public InputsNullException(Throwable cause) {
		this(DEFAULT_MESSAGE, cause);
	}
	
	/**
	 * Constructor with message.
	 * @param message the detail message
	 */
	public InputsNullException(String message) {
		super(message);
	}
	
	/**
	 * Constructor with message and cause.
	 * @param message the detail message
	 * @param cause the underlying cause
	 */
	public InputsNullException(String message, Throwable cause){
		super(message, cause);
	}

}
