/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vomanagement.usermanagement.impl;

import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.NoSuchUserException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Contact;
import com.liferay.portal.kernel.model.EmailAddress;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.MembershipRequest;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.Team;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroupRole;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.ContactLocalServiceUtil;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.ImageLocalServiceUtil;
import com.liferay.portal.kernel.service.MembershipRequestLocalServiceUtil;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import com.liferay.portal.kernel.service.RoleServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.TeamLocalServiceUtil;
import com.liferay.portal.kernel.service.UserGroupRoleLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.DigesterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.OrderByComparatorFactoryUtil;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.webserver.WebServerServletTokenUtil;
import java.io.Serializable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.gcube.vomanagement.usermanagement.UserManager;
import org.gcube.vomanagement.usermanagement.exception.GroupRetrievalFault;
import org.gcube.vomanagement.usermanagement.exception.RoleRetrievalFault;
import org.gcube.vomanagement.usermanagement.exception.TeamRetrievalFault;
import org.gcube.vomanagement.usermanagement.exception.UserManagementPortalException;
import org.gcube.vomanagement.usermanagement.exception.UserManagementSystemException;
import org.gcube.vomanagement.usermanagement.exception.UserRetrievalFault;
import org.gcube.vomanagement.usermanagement.exception.VirtualGroupNotExistingException;
import org.gcube.vomanagement.usermanagement.impl.LiferayGroupManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayRoleManager;
import org.gcube.vomanagement.usermanagement.model.CustomAttributeKeys;
import org.gcube.vomanagement.usermanagement.model.Email;
import org.gcube.vomanagement.usermanagement.model.GCubeGroup;
import org.gcube.vomanagement.usermanagement.model.GCubeMembershipRequest;
import org.gcube.vomanagement.usermanagement.model.GCubeRole;
import org.gcube.vomanagement.usermanagement.model.GCubeUser;
import org.gcube.vomanagement.usermanagement.model.GatewayRolesNames;
import org.gcube.vomanagement.usermanagement.model.MembershipRequestStatus;
import org.gcube.vomanagement.usermanagement.util.ManagementUtils;

public class LiferayUserManager
implements UserManager {
    private static final Log _log = LogFactoryUtil.getLog(LiferayUserManager.class);

    private void doAsAdmin() {
        try {
            User admin = LiferayUserManager.getAdmin();
            long userId = admin.getUserId();
            PrincipalThreadLocal.setName((long)userId);
            PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)UserLocalServiceUtil.getUser((long)userId));
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static User getAdmin() {
        long companyId = PortalUtil.getDefaultCompanyId();
        Role role = null;
        try {
            role = LiferayUserManager.getRoleById(companyId, "Administrator");
            for (User admin : UserLocalServiceUtil.getRoleUsers((long)role.getRoleId())) {
                if (!admin.isActive()) continue;
                return admin;
            }
        }
        catch (Exception e) {
            _log.error((Object)"Utils::getAdmin Exception", (Throwable)e);
        }
        return null;
    }

    public static User getRandomUserWithRole(long contextGroupId, GatewayRolesNames gatewayRole) {
        long companyId = PortalUtil.getDefaultCompanyId();
        try {
            Role theRole = RoleLocalServiceUtil.getRole((long)companyId, (String)gatewayRole.getRoleName());
            if (theRole == null) {
                _log.warn((Object)("No user has the role with this groupId " + gatewayRole.getRoleName() + ":" + contextGroupId));
                return null;
            }
            List list = UserGroupRoleLocalServiceUtil.getUserGroupRolesByGroupAndRole((long)contextGroupId, (long)theRole.getRoleId());
            for (UserGroupRole userGroupRole : list) {
                User admin = userGroupRole.getUser();
                if (!admin.isActive()) continue;
                return admin;
            }
        }
        catch (Exception e) {
            _log.error((Object)"Utils::getInfrastructureManager Exception", (Throwable)e);
        }
        return null;
    }

    public static Role getRoleById(long companyId, String roleStrId) {
        try {
            return RoleLocalServiceUtil.getRole((long)companyId, (String)roleStrId);
        }
        catch (Exception e) {
            _log.error((Object)"Utils::getRoleById Exception", (Throwable)e);
            return null;
        }
    }

    private GCubeUser mapLRUser(User u) throws PortalException, SystemException {
        if (u != null) {
            ArrayList<Email> emails = new ArrayList<Email>();
            for (EmailAddress e : u.getEmailAddresses()) {
                emails.add(new Email(e.getAddress(), "default", e.isPrimary()));
            }
            String locationIndustry = "";
            try {
                locationIndustry = (String)((Object)this.readCustomAttr(u.getUserId(), CustomAttributeKeys.USER_LOCATION_INDUSTRY.getKeyName()));
            }
            catch (UserRetrievalFault e1) {
                e1.printStackTrace();
            }
            return new GCubeUser(u.getUserId(), u.getScreenName(), u.getEmailAddress(), u.getFirstName(), u.getMiddleName(), u.getLastName(), u.getFullName(), u.getCreateDate().getTime(), LiferayUserManager.getUserAvatarAbsoluteURL(u), u.isMale(), u.getJobTitle(), locationIndustry, emails);
        }
        return null;
    }

    private static String getUserAvatarAbsoluteURL(User u) throws PortalException, SystemException {
        String pictureBaseURL = u.isMale() ? "/image/user_male_portrait?img_id=" : "/image/user_female_portrait?img_id=";
        String img_id_token = URLEncoder.encode(DigesterUtil.digest((String)u.getUuid()), StandardCharsets.UTF_8);
        String token = WebServerServletTokenUtil.getToken((long)u.getPortraitId());
        return pictureBaseURL + u.getPortraitId() + "&img_id_token=" + img_id_token + "&t=" + token;
    }

    private GCubeMembershipRequest mapLRMembershipRequest(MembershipRequest req) throws PortalException, SystemException {
        MembershipRequestStatus requestStatus = MembershipRequestStatus.REQUEST;
        if (req.getStatusId() == 1L) {
            requestStatus = MembershipRequestStatus.APPROVED;
        } else if (req.getStatusId() == 2L) {
            requestStatus = MembershipRequestStatus.DENIED;
        }
        GCubeUser requestingUser = null;
        User theUser = UserLocalServiceUtil.getUser((long)req.getUserId());
        if (theUser.isActive()) {
            requestingUser = this.mapLRUser(theUser);
        }
        GCubeUser replierUser = null;
        if (req.getReplierUserId() != 0L) {
            User theReplier = UserLocalServiceUtil.getUser((long)req.getReplierUserId());
            if (theUser.isActive()) {
                replierUser = this.mapLRUser(theReplier);
            }
        }
        GCubeMembershipRequest toReturn = new GCubeMembershipRequest(req.getMembershipRequestId(), req.getGroupId(), requestingUser, req.getCreateDate(), req.getComments(), req.getReplyComments(), replierUser, req.getReplyDate(), requestStatus);
        return toReturn;
    }

    @Override
    public GCubeUser createUser(boolean autoScreenName, String username, String email, String firstName, String middleName, String lastName, String jobTitle, String location_industry, String backgroundSummary, boolean male, String reminderQuestion, String reminderAnswer, int type) throws UserManagementSystemException {
        return this.createUserBody(autoScreenName, username, email, firstName, middleName, lastName, jobTitle, location_industry, backgroundSummary, male, reminderQuestion, reminderAnswer, false, false, null, null, null, null, null, null, null, type);
    }

    @Override
    public GCubeUser createUser(boolean autoScreenName, String username, String email, String firstName, String middleName, String lastName, String jobTitle, String location_industry, String backgroundSummary, boolean male, String reminderQuestion, String reminderAnswer, boolean sendEmail, boolean forcePasswordReset, int type) throws UserManagementSystemException {
        return this.createUserBody(autoScreenName, username, email, firstName, middleName, lastName, jobTitle, location_industry, backgroundSummary, male, reminderQuestion, reminderAnswer, sendEmail, forcePasswordReset, null, null, null, null, null, null, null, type);
    }

    @Override
    public GCubeUser createUser(boolean autoScreenName, String username, String email, String firstName, String middleName, String lastName, String jobTitle, String location_industry, String backgroundSummary, boolean male, String reminderQuestion, String reminderAnswer, boolean sendEmail, boolean forcePasswordReset, byte[] portraitBytes, int type) throws UserManagementSystemException {
        return this.createUserBody(autoScreenName, username, email, firstName, middleName, lastName, jobTitle, location_industry, backgroundSummary, male, reminderQuestion, reminderAnswer, sendEmail, forcePasswordReset, portraitBytes, null, null, null, null, null, null, type);
    }

    @Override
    public GCubeUser createUser(boolean autoScreenName, String username, String email, String firstName, String middleName, String lastName, String jobTitle, String location_industry, String backgroundSummary, boolean male, String reminderQuestion, String reminderAnswer, boolean sendEmail, boolean forcePasswordReset, byte[] portraitBytes, String mySpacesn, String twittersn, String facebooksn, String skypesn, String jabbersn, String aimsn, int type) throws UserManagementSystemException {
        return this.createUserBody(autoScreenName, username, email, firstName, middleName, lastName, jobTitle, location_industry, backgroundSummary, male, reminderQuestion, reminderAnswer, sendEmail, forcePasswordReset, portraitBytes, mySpacesn, twittersn, facebooksn, skypesn, jabbersn, aimsn, type);
    }

    private GCubeUser createUserBody(boolean autoScreenName, String username, String email, String firstName, String middleName, String lastName, String jobTitle, String location_industry, String backgroundSummary, boolean male, String reminderQuestion, String reminderAnswer, boolean sendEmail, boolean forcePasswordReset, byte[] portraitBytes, String mySpacesn, String twittersn, String facebooksn, String skypesn, String jabbersn, String aimsn, int type) {
        GCubeUser toReturn = null;
        try {
            String password1;
            _log.debug((Object)("Trying createuser " + email));
            Long defaultCompanyId = PortalUtil.getDefaultCompanyId();
            Long defaultUserId = UserLocalServiceUtil.getDefaultUserId((long)defaultCompanyId);
            boolean autoPassword = false;
            Locale locale = new Locale("en_US");
            int prefixId = 0;
            int suffixId = 0;
            int birthdayMonth = 1;
            int birthdayDay = 1;
            int birthdayYear = 1970;
            String password2 = password1 = "training1";
            User added = UserLocalServiceUtil.addUser((long)defaultUserId, (long)defaultCompanyId, (boolean)autoPassword, (String)password1, (String)password2, (boolean)autoScreenName, (String)username, (String)email, (Locale)locale, (String)firstName, (String)middleName, (String)lastName, (long)prefixId, (long)suffixId, (boolean)male, (int)birthdayMonth, (int)birthdayDay, (int)birthdayYear, (String)jobTitle, (int)type, null, null, null, null, (boolean)sendEmail, (ServiceContext)new ServiceContext());
            added.setComments(backgroundSummary);
            UserLocalServiceUtil.updateUser((User)added);
            _log.debug((Object)("CreateUser " + lastName + " SUCCESS"));
            UserLocalServiceUtil.updateAgreedToTermsOfUse((long)added.getUserId(), (boolean)true);
            UserLocalServiceUtil.updateEmailAddressVerified((long)added.getUserId(), (boolean)true);
            UserLocalServiceUtil.updatePasswordReset((long)added.getUserId(), (boolean)forcePasswordReset);
            if (reminderQuestion == null || reminderQuestion.compareTo("") == 0) {
                reminderQuestion = "Unknown question";
            }
            if (reminderAnswer == null || reminderAnswer.compareTo("") == 0) {
                reminderAnswer = "Unknown answer";
            }
            UserLocalServiceUtil.updateReminderQuery((long)added.getUserId(), (String)reminderQuestion, (String)reminderAnswer);
            _log.debug((Object)("User " + lastName + " has agreed to ToU"));
            _log.debug((Object)("User " + lastName + " has verified the Email"));
            _log.debug((Object)("User " + lastName + " updatePasswordReset & updateReminderQuery"));
            this.saveCustomAttr(added.getUserId(), CustomAttributeKeys.USER_LOCATION_INDUSTRY.getKeyName(), (Serializable)((Object)location_industry));
            if (portraitBytes != null) {
                try {
                    _log.debug((Object)"Updating user's avatar");
                    UserLocalServiceUtil.updatePortrait((long)added.getUserId(), (byte[])portraitBytes);
                    _log.debug((Object)"User's avatar set OK");
                }
                catch (PortalException e1) {
                    _log.debug((Object)"Unable to set user's avatar", (Throwable)e1);
                }
                catch (SystemException e1) {
                    _log.debug((Object)"Unable to set user's avatar", (Throwable)e1);
                }
            }
            Contact contact = added.getContact();
            if (twittersn != null && twittersn.compareTo("") != 0) {
                contact.setTwitterSn(twittersn);
            }
            if (facebooksn != null && facebooksn.compareTo("") != 0) {
                contact.setFacebookSn(facebooksn);
            }
            if (skypesn != null && skypesn.compareTo("") != 0) {
                contact.setSkypeSn(skypesn);
            }
            if (jabbersn != null && jabbersn.compareTo("") != 0) {
                contact.setJabberSn(jabbersn);
            }
            ContactLocalServiceUtil.updateContact((Contact)contact);
            return this.mapLRUser(added);
        }
        catch (Exception e) {
            e.printStackTrace();
            return toReturn;
        }
    }

    @Override
    public GCubeUser getUserByUsername(String username) throws UserManagementSystemException, UserRetrievalFault {
        User toGet = null;
        GCubeUser toReturn = null;
        try {
            toGet = UserLocalServiceUtil.getUserByScreenName((long)ManagementUtils.getCompany().getCompanyId(), (String)username);
            toReturn = this.mapLRUser(toGet);
        }
        catch (PortalException e1) {
            throw new UserRetrievalFault("User not existing", username, e1);
        }
        catch (SystemException e) {
            _log.error((Object)("SystemException: Failed to fetch user by username = " + username));
            throw new UserManagementSystemException(e.getMessage(), e);
        }
        return toReturn;
    }

    @Override
    @Deprecated
    public GCubeUser getUserByScreenName(String username) throws UserManagementSystemException, UserRetrievalFault {
        return this.getUserByUsername(username);
    }

    @Override
    public GCubeUser getUserById(long userId) throws UserManagementSystemException, UserRetrievalFault {
        User toGet = null;
        GCubeUser toReturn = null;
        try {
            _log.debug((Object)("Trying to fetch user by LR Id = " + userId));
            toGet = UserLocalServiceUtil.getUser((long)userId);
            toReturn = this.mapLRUser(toGet);
        }
        catch (PortalException e) {
            throw new UserRetrievalFault("User not existing", userId, e);
        }
        catch (SystemException e) {
            throw new UserManagementSystemException(e.getMessage(), e);
        }
        return toReturn;
    }

    @Override
    public String getUserProfessionalBackground(long userId) throws UserManagementSystemException, UserRetrievalFault {
        User toGet = null;
        String toReturn = null;
        try {
            _log.debug((Object)("Trying to fetch user Professional Background by LR Id = " + userId));
            toGet = UserLocalServiceUtil.getUser((long)userId);
            toReturn = toGet.getComments();
        }
        catch (PortalException e) {
            throw new UserRetrievalFault("User not existing", userId, e);
        }
        catch (SystemException e) {
            throw new UserManagementSystemException(e.getMessage(), e);
        }
        return toReturn;
    }

    @Override
    public void setUserProfessionalBackground(long userId, String summary) throws UserManagementSystemException, UserRetrievalFault {
        User user = null;
        try {
            _log.debug((Object)("Trying to set user Professional Background by LR Id = " + userId));
            user = UserLocalServiceUtil.getUser((long)userId);
            user.setComments(summary);
            UserLocalServiceUtil.updateUser((User)user);
        }
        catch (PortalException e) {
            throw new UserRetrievalFault("User not existing", userId, e);
        }
        catch (SystemException e) {
            throw new UserManagementSystemException(e.getMessage(), e);
        }
    }

    @Override
    public GCubeUser getUserByEmail(String emailAddress) throws UserManagementSystemException, UserRetrievalFault {
        User toGet = null;
        GCubeUser toReturn = null;
        try {
            _log.debug((Object)("Trying to fetch user by emailAddress = " + emailAddress));
            toGet = UserLocalServiceUtil.getUserByEmailAddress((long)ManagementUtils.getCompany().getCompanyId(), (String)emailAddress);
            toReturn = this.mapLRUser(toGet);
        }
        catch (PortalException e) {
            throw new UserRetrievalFault("emailAddress not existing", e);
        }
        catch (SystemException e) {
            throw new UserManagementSystemException(e.getMessage(), e);
        }
        return toReturn;
    }

    @Override
    public long getUserId(String screenName) throws UserManagementSystemException, UserRetrievalFault {
        return this.getUserByUsername(screenName).getUserId();
    }

    @Override
    public List<GCubeUser> listUsers(boolean indexed) throws UserManagementSystemException {
        if (indexed) {
            return this.listUsers();
        }
        _log.debug((Object)"Asked for listUsers non indexed");
        ArrayList<GCubeUser> toReturn = new ArrayList<GCubeUser>();
        try {
            OrderByComparator comparator = OrderByComparatorFactoryUtil.create((String)"User_", (Object[])new Object[]{"screenname", true});
            List lrUsers = UserLocalServiceUtil.search((long)ManagementUtils.getCompany().getCompanyId(), (String)"", (int)0, null, (int)-1, (int)-1, (OrderByComparator)comparator);
            for (User user : lrUsers) {
                if (!user.isActive()) continue;
                toReturn.add(this.mapLRUser(user));
            }
        }
        catch (SystemException e) {
            throw new UserManagementSystemException(e.getMessage(), e);
        }
        catch (PortalException e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    @Override
    public List<GCubeUser> listUsers() throws UserManagementSystemException {
        ArrayList<GCubeUser> toReturn = new ArrayList<GCubeUser>();
        try {
            List lrUsers = UserLocalServiceUtil.getUsers((int)-1, (int)-1);
            for (User user : lrUsers) {
                if (!user.isActive()) continue;
                toReturn.add(this.mapLRUser(user));
            }
        }
        catch (SystemException e) {
            throw new UserManagementSystemException(e.getMessage(), e);
        }
        catch (PortalException e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    @Override
    public List<GCubeUser> listUsers(int start, int end) throws UserManagementSystemException {
        ArrayList<GCubeUser> toReturn = new ArrayList<GCubeUser>();
        try {
            List lrUsers = UserLocalServiceUtil.getUsers((int)start, (int)end);
            for (User user : lrUsers) {
                if (!user.isActive()) continue;
                toReturn.add(this.mapLRUser(user));
            }
        }
        catch (SystemException e) {
            throw new UserManagementSystemException(e.getMessage(), e);
        }
        catch (PortalException e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    @Override
    public int getUsersCount() throws UserManagementSystemException {
        try {
            return UserLocalServiceUtil.getUsersCount();
        }
        catch (SystemException e) {
            throw new UserManagementSystemException(e.getMessage(), e);
        }
    }

    @Override
    public List<GCubeUser> listUsersByGroup(long groupId) throws UserManagementSystemException, GroupRetrievalFault, UserRetrievalFault {
        ArrayList<GCubeUser> toReturn = new ArrayList<GCubeUser>();
        try {
            for (User user : UserLocalServiceUtil.getGroupUsers((long)groupId)) {
                if (!user.isActive()) continue;
                toReturn.add(this.mapLRUser(user));
            }
        }
        catch (PortalException e) {
            throw new GroupRetrievalFault("listUsersByGroup not existing group", groupId, e);
        }
        catch (SystemException e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    @Override
    public List<GCubeUser> listUsersByGroup(long groupId, int start, int end) throws UserManagementSystemException, GroupRetrievalFault, UserRetrievalFault {
        ArrayList<GCubeUser> toReturn = new ArrayList<GCubeUser>();
        try {
            for (User user : UserLocalServiceUtil.getGroupUsers((long)groupId, (int)start, (int)end)) {
                if (!user.isActive()) continue;
                toReturn.add(this.mapLRUser(user));
            }
        }
        catch (PortalException e) {
            throw new GroupRetrievalFault("listUsersByGroup not existing group", groupId, e);
        }
        catch (SystemException e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    @Override
    public int getGroupUsersCount(long groupId) throws GroupRetrievalFault {
        try {
            return UserLocalServiceUtil.getGroupUsersCount((long)groupId);
        }
        catch (SystemException e) {
            throw new GroupRetrievalFault("listUsersByGroup not existing group", groupId, e);
        }
    }

    @Override
    public List<GCubeUser> listUsersByGroup(long groupId, boolean indexed) throws UserManagementSystemException, GroupRetrievalFault, UserRetrievalFault {
        if (indexed) {
            return this.listUsersByGroup(groupId);
        }
        ArrayList<GCubeUser> toReturn = new ArrayList<GCubeUser>();
        try {
            OrderByComparator comparator = OrderByComparatorFactoryUtil.create((String)"User_", (Object[])new Object[]{"screenname", true});
            LinkedHashMap<String, Long> params = new LinkedHashMap<String, Long>();
            params.put("usersGroups", groupId);
            List usersByGroup = UserLocalServiceUtil.search((long)ManagementUtils.getCompany().getCompanyId(), (String)"", (int)0, params, (int)-1, (int)-1, (OrderByComparator)comparator);
            for (User user : usersByGroup) {
                if (!user.isActive()) continue;
                toReturn.add(this.mapLRUser(user));
            }
        }
        catch (PortalException e) {
            throw new GroupRetrievalFault("listUsersByGroup not existing group", groupId, e);
        }
        catch (SystemException e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    @Override
    public List<GCubeUser> searchUsersByGroup(String keywords, long groupId) throws GroupRetrievalFault {
        ArrayList<GCubeUser> toReturn = new ArrayList<GCubeUser>();
        try {
            OrderByComparator comparator = OrderByComparatorFactoryUtil.create((String)"User_", (Object[])new Object[]{"screenname", true});
            LinkedHashMap<String, Long> params = new LinkedHashMap<String, Long>();
            params.put("usersGroups", groupId);
            List usersByGroup = UserLocalServiceUtil.search((long)ManagementUtils.getCompany().getCompanyId(), (String)keywords, (int)0, params, (int)-1, (int)-1, (OrderByComparator)comparator);
            for (User user : usersByGroup) {
                if (!user.isActive()) continue;
                toReturn.add(this.mapLRUser(user));
            }
        }
        catch (PortalException e) {
            throw new GroupRetrievalFault("listUsersByGroup not existing group", groupId, e);
        }
        catch (SystemException e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    @Override
    public List<GCubeUser> listUsersByGroupName(String name) throws UserManagementSystemException, GroupRetrievalFault, UserRetrievalFault {
        ArrayList<GCubeUser> toReturn = new ArrayList<GCubeUser>();
        try {
            Group g = GroupLocalServiceUtil.getGroup((long)ManagementUtils.getCompany().getCompanyId(), (String)name);
            return this.listUsersByGroup(g.getGroupId());
        }
        catch (PortalException e) {
            e.printStackTrace();
        }
        catch (SystemException e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    @Override
    public Map<GCubeUser, List<GCubeRole>> listUsersAndRolesByGroup(long groupId) throws GroupRetrievalFault, UserManagementSystemException, UserRetrievalFault {
        HashMap<GCubeUser, List<GCubeRole>> toReturn = new HashMap<GCubeUser, List<GCubeRole>>();
        try {
            Group g = GroupLocalServiceUtil.getGroup((long)groupId);
            _log.debug((Object)("Asked for users and roles of group: " + g.getName()));
            List usersByGroup = UserLocalServiceUtil.getGroupUsers((long)groupId);
            for (User user : usersByGroup) {
                if (!user.isActive()) continue;
                long userId = user.getUserId();
                this.doAsAdmin();
                List userRoles = RoleServiceUtil.getUserGroupRoles((long)userId, (long)groupId);
                ArrayList<GCubeRole> toAdd = new ArrayList<GCubeRole>();
                for (Role role : userRoles) {
                    if (role.getType() == 2 && role.getName().startsWith("Site")) continue;
                    toAdd.add(LiferayRoleManager.mapLRRole(role));
                }
                toReturn.put(this.mapLRUser(user), toAdd);
            }
        }
        catch (PortalException e1) {
            throw new GroupRetrievalFault("Group not existing (I think you better check)", groupId, e1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    @Override
    public List<GCubeUser> listUsersByGroupAndRole(long groupId, long roleId) throws UserManagementSystemException, RoleRetrievalFault, GroupRetrievalFault, UserRetrievalFault {
        ArrayList<GCubeUser> toReturn = new ArrayList<GCubeUser>();
        try {
            List listTriplet = UserGroupRoleLocalServiceUtil.getUserGroupRolesByGroupAndRole((long)groupId, (long)roleId);
            for (UserGroupRole userGroupRole : listTriplet) {
                toReturn.add(this.getUserById(userGroupRole.getUserId()));
            }
        }
        catch (SystemException e1) {
            e1.printStackTrace();
        }
        return toReturn;
    }

    @Override
    public long[] listUserIdsByGroupAndRole(long groupId, long roleId) {
        List listTriplet = null;
        try {
            listTriplet = UserGroupRoleLocalServiceUtil.getUserGroupRolesByGroupAndRole((long)groupId, (long)roleId);
        }
        catch (SystemException e) {
            e.printStackTrace();
        }
        long[] toReturn = new long[listTriplet.size()];
        int i = 0;
        for (UserGroupRole userGroupRole : listTriplet) {
            toReturn[i] = userGroupRole.getUserId();
            ++i;
        }
        return toReturn;
    }

    @Override
    public List<GCubeUser> listUsersByTeam(long teamId) throws UserManagementSystemException, TeamRetrievalFault, UserRetrievalFault {
        ArrayList<GCubeUser> toReturn = new ArrayList<GCubeUser>();
        Team askedTeam = null;
        try {
            askedTeam = TeamLocalServiceUtil.getTeam((long)teamId);
            _log.debug((Object)("Asked for users of team: " + askedTeam.getName()));
            List users = UserLocalServiceUtil.getTeamUsers((long)teamId);
            for (User user : users) {
                toReturn.add(this.mapLRUser(user));
            }
        }
        catch (PortalException e) {
            throw new TeamRetrievalFault("Team not existing (I think you better check) teamId=" + teamId, e);
        }
        catch (SystemException e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    @Override
    public Set<GCubeUser> getUserContactsByGroup(long userId, long scopeGroupId) throws UserManagementSystemException, GroupRetrievalFault, UserRetrievalFault {
        HashSet<GCubeUser> users = new HashSet<GCubeUser>();
        LiferayGroupManager gm = new LiferayGroupManager();
        try {
            if (gm.isRootVO(scopeGroupId).booleanValue()) {
                Set<GCubeGroup> userGroups = gm.listGroupsByUserAndSiteGroupId(userId, scopeGroupId);
                for (GCubeGroup userGroup : userGroups) {
                    if (!gm.isVRE(userGroup.getGroupId()).booleanValue()) continue;
                    users.addAll(this.listUsersByGroup(userGroup.getGroupId()));
                    _log.debug((Object)("getUserContactsByGroup added users of group " + userGroup.getGroupId() + " for userid=" + userId));
                }
            } else {
                users.addAll(this.listUsersByGroup(scopeGroupId));
            }
        }
        catch (GroupRetrievalFault | UserManagementSystemException | UserRetrievalFault | VirtualGroupNotExistingException e) {
            e.printStackTrace();
        }
        return users;
    }

    @Override
    public List<GCubeMembershipRequest> listMembershipRequestsByGroup(long groupId) throws UserManagementSystemException, GroupRetrievalFault, UserRetrievalFault {
        try {
            Group g = GroupLocalServiceUtil.getGroup((long)groupId);
            _log.debug((Object)("Asked for pending users list of group: " + g.getName()));
        }
        catch (PortalException e1) {
            throw new GroupRetrievalFault("Group not existing", groupId, e1);
        }
        catch (SystemException e) {
            e.printStackTrace();
        }
        DynamicQuery queryListPendingMembershipRequestsByGroup = DynamicQueryFactoryUtil.forClass(MembershipRequest.class, (ClassLoader)PortalClassLoaderUtil.getClassLoader());
        queryListPendingMembershipRequestsByGroup.add(PropertyFactoryUtil.forName((String)"groupId").eq((Object)groupId));
        ArrayList<GCubeMembershipRequest> toReturn = new ArrayList<GCubeMembershipRequest>();
        try {
            List list = MembershipRequestLocalServiceUtil.dynamicQuery((DynamicQuery)queryListPendingMembershipRequestsByGroup);
            for (MembershipRequest req : list) {
                if (req.getGroupId() != groupId) continue;
                try {
                    toReturn.add(this.mapLRMembershipRequest(req));
                }
                catch (NoSuchUserException e) {
                    _log.warn((Object)("Could not map membership request, userid no longer exists: " + req.getUserId()));
                }
            }
        }
        catch (SystemException e) {
            e.printStackTrace();
        }
        catch (PortalException e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    @Override
    public List<GCubeMembershipRequest> listPendingMembershipRequestsByGroup(long groupId) throws UserManagementSystemException, GroupRetrievalFault, UserRetrievalFault {
        try {
            Group g = GroupLocalServiceUtil.getGroup((long)groupId);
            _log.debug((Object)("Asked for pending users list of group: " + g.getName()));
        }
        catch (PortalException e1) {
            throw new GroupRetrievalFault("Group not existing", groupId, e1);
        }
        catch (SystemException e) {
            e.printStackTrace();
        }
        DynamicQuery queryListPendingMembershipRequestsByGroup = DynamicQueryFactoryUtil.forClass(MembershipRequest.class, (ClassLoader)PortalClassLoaderUtil.getClassLoader());
        queryListPendingMembershipRequestsByGroup.add(PropertyFactoryUtil.forName((String)"statusId").eq((Object)Integer.valueOf("2")));
        queryListPendingMembershipRequestsByGroup.add(PropertyFactoryUtil.forName((String)"groupId").eq((Object)groupId));
        ArrayList<GCubeMembershipRequest> toReturn = new ArrayList<GCubeMembershipRequest>();
        try {
            List list = MembershipRequestLocalServiceUtil.dynamicQuery((DynamicQuery)queryListPendingMembershipRequestsByGroup);
            for (MembershipRequest req : list) {
                if (req.getGroupId() != groupId) continue;
                toReturn.add(this.mapLRMembershipRequest(req));
            }
        }
        catch (SystemException e) {
            e.printStackTrace();
        }
        catch (PortalException e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    @Override
    public GCubeMembershipRequest requestMembership(long userId, long groupId, String comment) throws UserManagementSystemException, GroupRetrievalFault, UserRetrievalFault {
        try {
            MembershipRequest req = MembershipRequestLocalServiceUtil.addMembershipRequest((long)userId, (long)groupId, (String)comment, (ServiceContext)new ServiceContext());
            return this.mapLRMembershipRequest(req);
        }
        catch (PortalException e) {
            e.printStackTrace();
        }
        catch (SystemException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public GCubeMembershipRequest acceptMembershipRequest(long requestUserId, long groupId, boolean addUserToGroup, String replyUsername, String replyComment) throws UserManagementSystemException, GroupRetrievalFault, UserManagementPortalException {
        try {
            GCubeUser replyMan = this.getUserByUsername(replyUsername);
            List requests = MembershipRequestLocalServiceUtil.getMembershipRequests((long)requestUserId, (long)groupId, (long)0L);
            for (MembershipRequest req : requests) {
                if (req.getUserId() != requestUserId) continue;
                MembershipRequestLocalServiceUtil.updateStatus((long)replyMan.getUserId(), (long)req.getMembershipRequestId(), (String)replyComment, (long)1L, (boolean)addUserToGroup, (ServiceContext)new ServiceContext());
                this.assignUserToGroup(GroupLocalServiceUtil.getGroup((long)groupId).getParentGroupId(), requestUserId);
                _log.info((Object)("Accepted membership request: requestUserId=" + requestUserId));
                return this.mapLRMembershipRequest(MembershipRequestLocalServiceUtil.getMembershipRequest((long)req.getMembershipRequestId()));
            }
        }
        catch (UserRetrievalFault e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public GCubeMembershipRequest rejectMembershipRequest(long requestUserId, long groupId, String replyUsername, String replyComment) throws UserManagementSystemException, GroupRetrievalFault, UserManagementPortalException {
        try {
            GCubeUser replyMan = this.getUserByUsername(replyUsername);
            List<GCubeMembershipRequest> requests = this.listMembershipRequestsByGroup(groupId);
            for (GCubeMembershipRequest req : requests) {
                if (req.getRequestingUser().getUserId() != requestUserId) continue;
                MembershipRequestLocalServiceUtil.updateStatus((long)replyMan.getUserId(), (long)req.getMembershipRequestId(), (String)replyComment, (long)2L, (boolean)false, (ServiceContext)new ServiceContext());
                return this.mapLRMembershipRequest(MembershipRequestLocalServiceUtil.getMembershipRequest((long)req.getMembershipRequestId()));
            }
        }
        catch (UserRetrievalFault e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public GCubeMembershipRequest getMembershipRequestsById(long membershipRequestId) {
        GCubeMembershipRequest toReturn = null;
        try {
            toReturn = this.mapLRMembershipRequest(MembershipRequestLocalServiceUtil.getMembershipRequest((long)membershipRequestId));
        }
        catch (PortalException e) {
            e.printStackTrace();
        }
        catch (SystemException e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    @Override
    public List<GCubeMembershipRequest> getMembershipRequests(long userId, long groupId, MembershipRequestStatus requestStatus) throws UserManagementSystemException, GroupRetrievalFault, UserRetrievalFault {
        try {
            Group g = GroupLocalServiceUtil.getGroup((long)groupId);
            _log.debug((Object)("Asked for pending users list of group: " + g.getName()));
        }
        catch (PortalException e1) {
            throw new GroupRetrievalFault("Group not existing", groupId, e1);
        }
        catch (SystemException e) {
            e.printStackTrace();
        }
        ArrayList<GCubeMembershipRequest> toReturn = new ArrayList<GCubeMembershipRequest>();
        try {
            int statusId = 0;
            if (requestStatus == MembershipRequestStatus.APPROVED) {
                statusId = 1;
            } else if (requestStatus == MembershipRequestStatus.DENIED) {
                statusId = 2;
            }
            for (MembershipRequest req : MembershipRequestLocalServiceUtil.getMembershipRequests((long)userId, (long)groupId, (long)statusId)) {
                toReturn.add(this.mapLRMembershipRequest(req));
            }
        }
        catch (SystemException e) {
            e.printStackTrace();
        }
        catch (PortalException e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    @Override
    public void assignUserToGroup(long groupId, long userId) throws UserManagementSystemException, GroupRetrievalFault, UserRetrievalFault, UserManagementPortalException {
        try {
            LiferayGroupManager gm = new LiferayGroupManager();
            if (gm.isRootVO(groupId).booleanValue()) {
                UserLocalServiceUtil.addGroupUser((long)groupId, (long)userId);
                return;
            }
            if (gm.isVO(groupId).booleanValue()) {
                long parentGroupId = gm.getGroup(groupId).getParentGroupId();
                UserLocalServiceUtil.addGroupUser((long)parentGroupId, (long)userId);
                UserLocalServiceUtil.addGroupUser((long)groupId, (long)userId);
                return;
            }
            if (gm.isVRE(groupId).booleanValue()) {
                long rootGroupId = gm.getGroup(gm.getGroup(groupId).getParentGroupId()).getParentGroupId();
                UserLocalServiceUtil.addGroupUser((long)rootGroupId, (long)userId);
                long parentGroupId = gm.getGroup(groupId).getParentGroupId();
                UserLocalServiceUtil.addGroupUser((long)parentGroupId, (long)userId);
                UserLocalServiceUtil.addGroupUser((long)groupId, (long)userId);
            }
        }
        catch (SystemException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void dismissUserFromGroup(long groupId, long userId) throws UserManagementSystemException, GroupRetrievalFault, UserRetrievalFault {
        try {
            UserLocalServiceUtil.deleteGroupUser((long)groupId, (long)userId);
        }
        catch (SystemException e) {
            e.printStackTrace();
        }
    }

    @Override
    public List<GCubeUser> listUnregisteredUsersByGroup(long groupId) throws UserManagementSystemException, GroupRetrievalFault, UserRetrievalFault {
        List<GCubeUser> toProcess = this.listUsers();
        toProcess.removeAll(this.listUsersByGroup(groupId));
        return toProcess;
    }

    @Override
    public boolean isPasswordChanged(String emailAddress) {
        _log.debug((Object)("Trying to fetch user by email = " + emailAddress));
        try {
            User user = UserLocalServiceUtil.getUserByEmailAddress((long)ManagementUtils.getCompany().getCompanyId(), (String)emailAddress);
            long creationTime = user.getCreateDate().getTime();
            if (user.getPasswordModifiedDate() == null) {
                return false;
            }
            long changedTime = user.getPasswordModifiedDate().getTime();
            return changedTime > creationTime;
        }
        catch (Exception e) {
            _log.error((Object)("Error while retrieving user with mail=" + emailAddress), (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean userExistsByEmail(String emailAddress) {
        try {
            if (UserLocalServiceUtil.getUserByEmailAddress((long)ManagementUtils.getCompany().getCompanyId(), (String)emailAddress) != null) {
                return true;
            }
        }
        catch (Exception e) {
            _log.error((Object)("Error while retrieving user with mail=" + emailAddress), (Throwable)e);
        }
        return false;
    }

    @Override
    public String getFullNameFromEmail(String email) {
        try {
            User user = UserLocalServiceUtil.getUserByEmailAddress((long)ManagementUtils.getCompany().getCompanyId(), (String)email);
            if (user != null) {
                return user.getFullName();
            }
        }
        catch (Exception e) {
            _log.error((Object)("Unable to find user with email " + email));
        }
        return null;
    }

    @Override
    public void deleteUserByEMail(String email) throws UserManagementSystemException, UserManagementPortalException, PortalException, SystemException {
        User user = UserLocalServiceUtil.getUserByEmailAddress((long)ManagementUtils.getCompany().getCompanyId(), (String)email);
        if (user != null) {
            _log.debug((Object)("Deleting user with email " + email));
            UserLocalServiceUtil.deleteUser((User)user);
            _log.debug((Object)("Delete user with email " + email));
        }
    }

    @Override
    public byte[] getUserAvatarBytes(String screenName) {
        try {
            User user = UserLocalServiceUtil.getUserByScreenName((long)ManagementUtils.getCompany().getCompanyId(), (String)screenName);
            return ImageLocalServiceUtil.getImage((long)user.getPortraitId()).getTextObj();
        }
        catch (Exception e) {
            _log.debug((Object)"Unable to retrieve user's avatar", (Throwable)e);
            return null;
        }
    }

    @Override
    public String getUserOpenId(String screenName) {
        try {
            User user = UserLocalServiceUtil.getUserByScreenName((long)ManagementUtils.getCompany().getCompanyId(), (String)screenName);
            return user.getOpenId();
        }
        catch (PortalException e) {
            _log.debug((Object)"Unable to retrieve user's openId", (Throwable)e);
        }
        catch (SystemException e) {
            _log.debug((Object)"Unable to retrieve user's openId", (Throwable)e);
        }
        return null;
    }

    @Override
    public boolean updateContactInformation(String screenName, String mySpacesn, String twittersn, String facebooksn, String skypesn, String jabbersn, String aimsn) {
        try {
            User user = UserLocalServiceUtil.getUserByScreenName((long)ManagementUtils.getCompany().getCompanyId(), (String)screenName);
            Contact contact = user.getContact();
            contact.setTwitterSn(twittersn);
            contact.setFacebookSn(facebooksn);
            contact.setSkypeSn(skypesn);
            contact.setJabberSn(jabbersn);
            ContactLocalServiceUtil.updateContact((Contact)contact);
            return true;
        }
        catch (Exception e) {
            _log.error((Object)("Error while updating user " + screenName + " contact information"));
            return false;
        }
    }

    @Override
    public Serializable readCustomAttr(long userId, String attributeKey) throws UserRetrievalFault {
        try {
            this.doAsAdmin();
            User u = UserLocalServiceUtil.getUser((long)userId);
            if (u.getExpandoBridge().hasAttribute(attributeKey)) {
                return u.getExpandoBridge().getAttribute(attributeKey);
            }
            return null;
        }
        catch (PortalException e1) {
            throw new UserRetrievalFault("User not existing (I think you better check)", e1);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void saveCustomAttr(long userId, String attributeKey, Serializable value) throws UserRetrievalFault {
        try {
            this.doAsAdmin();
            User u = UserLocalServiceUtil.getUser((long)userId);
            u.getExpandoBridge().setAttribute(attributeKey, value);
        }
        catch (PortalException e1) {
            throw new UserRetrievalFault("User not existing (I think you better check)", e1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean updateJobTitle(long userId, String theJob) {
        try {
            UserLocalServiceUtil.updateJobTitle((long)userId, (String)theJob);
        }
        catch (PortalException | SystemException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public List<GCubeUser> listUsersByGlobalRole(long roleId) {
        return null;
    }

    @Override
    public List<Long> getUserIdsByGroup(long groupId) {
        return null;
    }
}

