package org.gcube.vomanagement.usermanagement.model;

import java.io.Serializable;
import java.util.List;
import java.util.Map;


/**
 * @author Massimiliano Assante, CNR-ISTI
 * 
 */
@SuppressWarnings("serial")
public class GCubeUser implements Serializable {
	private long userId;
	private String username;
	private String email;
	private String firstName;
	private String middleName;
	private String lastName;
	private String fullname;	
	private long registrationDate;
	private String userAvatarURL;
	private boolean male;
	private String jobTitle;
	private String location_industry;
	private Map<String,String> customAttrsMap;
	private List<Email> emailAddresses;
	/**
	 * constructor without custom attrs
	 * @param userId
	 * @param username
	 * @param email
	 * @param firstName
	 * @param middleName
	 * @param lastName
	 * @param fullname
	 * @param registrationDate
	 * @param userAvatarURL
	 * @param male
	 * @param jobTitle
	 * @param customAttrsMap
	 * @param emailAddresses
	 */
	public GCubeUser(long userId, String username, String email,
			String firstName, String middleName, String lastName,
			String fullname, long registrationDate, String userAvatarURL,
			boolean male, String jobTitle, Map<String, String> customAttrsMap,
			List<Email> emailAddresses) {
		super();
		this.userId = userId;
		this.username = username;
		this.email = email;
		this.firstName = firstName;
		this.middleName = middleName;
		this.lastName = lastName;
		this.fullname = fullname;
		this.registrationDate = registrationDate;
		this.userAvatarURL = userAvatarURL;
		this.male = male;
		this.jobTitle = jobTitle;
		this.customAttrsMap = customAttrsMap;
		this.emailAddresses = emailAddresses;
	}
	/**
	 * constructor without custom attrs
	 * @param userId
	 * @param username
	 * @param email
	 * @param firstName
	 * @param middleName
	 * @param lastName
	 * @param fullname
	 * @param registrationDate
	 * @param userAvatarId
	 * @param male
	 * @param jobTitle
	 * @param emailAddresses
	 */
	public GCubeUser(long userId, String username, String email,
			String firstName, String middleName, String lastName,
			String fullname, long registrationDate, String userAvatarId,
			boolean male, String jobTitle,
			List<Email> emailAddresses) {
		super();
		this.userId = userId;
		this.username = username;
		this.email = email;
		this.firstName = firstName;
		this.middleName = middleName;
		this.lastName = lastName;
		this.fullname = fullname;
		this.registrationDate = registrationDate;
		this.userAvatarURL = userAvatarId;
		this.male = male;
		this.jobTitle = jobTitle;
		this.emailAddresses = emailAddresses;
	}
	/**
	 * constructor with location/industry also
	 * @param userId
	 * @param username
	 * @param email
	 * @param firstName
	 * @param middleName
	 * @param lastName
	 * @param fullname
	 * @param registrationDate
	 * @param userAvatarId
	 * @param male
	 * @param jobTitle
	 * @param emailAddresses
	 */
	/**
	 * Instantiates a new g cube user.
	 *
	 * @param userId the user id
	 * @param username the username
	 * @param email the email
	 * @param firstName the first name
	 * @param middleName the middle name
	 * @param lastName the last name
	 * @param fullname the fullname
	 * @param registrationDate the registration date
	 * @param userAvatarId the user avatar id
	 * @param male the male
	 * @param jobTitle the job title
	 * @param location_Industry the location industry
	 * @param emailAddresses the email addresses
	 */
	public GCubeUser(long userId, String username, String email,
			String firstName, String middleName, String lastName,
			String fullname, long registrationDate, String userAvatarId,
			boolean male, String jobTitle, String location_Industry,
			List<Email> emailAddresses) {
		super();
		this.userId = userId;
		this.username = username;
		this.email = email;
		this.firstName = firstName;
		this.middleName = middleName;
		this.lastName = lastName;
		this.fullname = fullname;
		this.registrationDate = registrationDate;
		this.userAvatarURL = userAvatarId;
		this.male = male;
		this.jobTitle = jobTitle;
		this.emailAddresses = emailAddresses;
		this.location_industry = location_Industry;
	}
	/**
	 * Gets the user id.
	 *
	 * @return the user id
	 */
	public long getUserId() {
		return userId;
	}

	/**
	 * Sets the user id.
	 *
	 * @param userId the new user id
	 */
	public void setUserId(long userId) {
		this.userId = userId;
	}

	/**
	 * Gets the username.
	 *
	 * @return the username
	 */
	public String getUsername() {
		return username;
	}
	
	/**
	 * Sets the username.
	 *
	 * @param username the new username
	 */
	public void setUsername(String username) {
		this.username = username;
	}
	/**
	 * @deprecated
	    * please use getUsername
	 * @return the username
	 */
	public String getScreenName() {
		return username;
	}


	/**
	 * Gets the email.
	 *
	 * @return the email
	 */
	public String getEmail() {
		return email;
	}

	/**
	 * Sets the email.
	 *
	 * @param email the new email
	 */
	public void setEmail(String email) {
		this.email = email;
	}

	/**
	 * Gets the first name.
	 *
	 * @return the first name
	 */
	public String getFirstName() {
		return firstName;
	}

	/**
	 * Sets the first name.
	 *
	 * @param firstName the new first name
	 */
	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}

	/**
	 * Gets the middle name.
	 *
	 * @return the middle name
	 */
	public String getMiddleName() {
		return middleName;
	}

	/**
	 * Sets the middle name.
	 *
	 * @param middleName the new middle name
	 */
	public void setMiddleName(String middleName) {
		this.middleName = middleName;
	}

	/**
	 * Gets the last name.
	 *
	 * @return the last name
	 */
	public String getLastName() {
		return lastName;
	}

	/**
	 * Sets the last name.
	 *
	 * @param lastName the new last name
	 */
	public void setLastName(String lastName) {
		this.lastName = lastName;
	}

	/**
	 * Gets the fullname.
	 *
	 * @return the fullname
	 */
	public String getFullname() {
		return fullname;
	}

	/**
	 * Sets the fullname.
	 *
	 * @param fullname the new fullname
	 */
	public void setFullname(String fullname) {
		this.fullname = fullname;
	}

	/**
	 * Gets the registration date.
	 *
	 * @return the registration date
	 */
	public long getRegistrationDate() {
		return registrationDate;
	}

	/**
	 * Sets the registration date.
	 *
	 * @param registrationDate the new registration date
	 */
	public void setRegistrationDate(long registrationDate) {
		this.registrationDate = registrationDate;
	}
	/**
	 * Gets the user avatar id.
	 *
	 * @return the user avatar id
	 */
	@Deprecated
	public String getUserAvatarId() {
		return userAvatarURL;
	}
	/**
	 * Sets the user avatar id.
	 *
	 * @param userAvatarId the new user avatar id
	 */
	@Deprecated
	public void setUserAvatarId(String userAvatarId) {
		this.userAvatarURL = userAvatarId;
	}
	/**
	 * @return the absolute path of the avatar URL comprising security token e.g. /image/user_male_portrait?img_id=12345&img_id_token=0GJ5WkeDV9F9bDZGkqzb7LahygM%3D&t=1457799199747;
	 */
	public String getUserAvatarURL() {
		return userAvatarURL;
	}

	/**
	 * Sets the user avatar URL.
	 *
	 * @param userAvatarURL the new user avatar URL
	 */
	public void setUserAvatarURL(String userAvatarURL) {
		this.userAvatarURL = userAvatarURL;
	}

	/**
	 * Checks if is male.
	 *
	 * @return true, if is male
	 */
	public boolean isMale() {
		return male;
	}

	/**
	 * Sets the male.
	 *
	 * @param male the new male
	 */
	public void setMale(boolean male) {
		this.male = male;
	}

	/**
	 * Gets the job title.
	 *
	 * @return the job title
	 */
	public String getJobTitle() {
		return jobTitle;
	}

	/**
	 * Sets the job title.
	 *
	 * @param jobTitle the new job title
	 */
	public void setJobTitle(String jobTitle) {
		this.jobTitle = jobTitle;
	}

	/**
	 * Gets the custom attrs map.
	 *
	 * @return the custom attrs map
	 */
	public Map<String, String> getCustomAttrsMap() {
		return customAttrsMap;
	}
	/**
	 * Sets the custom attrs map.
	 *
	 * @param customAttrsMap the custom attrs map
	 */
	public void setCustomAttrsMap(Map<String, String> customAttrsMap) {
		this.customAttrsMap = customAttrsMap;
	}
	/**
	 * Gets the email addresses.
	 *
	 * @return the email addresses
	 */
	public List<Email> getEmailAddresses() {
		return emailAddresses;
	}

	/**
	 * Sets the email addresses.
	 *
	 * @param emailAddresses the new email addresses
	 */
	public void setEmailAddresses(List<Email> emailAddresses) {
		this.emailAddresses = emailAddresses;
	}
	
	/**
	 * Gets the location industry.
	 *
	 * @return the location industry
	 */
	public String getLocation_industry() {
		return location_industry;
	}
	/**
	 * Sets the location industry.
	 *
	 * @param location_industry the new location industry
	 */
	public void setLocation_industry(String location_industry) {
		this.location_industry = location_industry;
	}
	
	@Override
	public String toString() {
		return "GCubeUser [userId=" + userId + ", username=" + username
				+ ", email=" + email + ", firstName=" + firstName
				+ ", middleName=" + middleName + ", lastName=" + lastName
				+ ", fullname=" + fullname + ", registrationDate="
				+ registrationDate + ", userAvatarURL=" + userAvatarURL
				+ ", male=" + male + ", jobTitle=" + jobTitle
				+ ", location_industry=" + location_industry
				+ ", customAttrsMap=" + customAttrsMap + ", emailAddresses="
				+ emailAddresses + "]";
	}
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		GCubeUser other = (GCubeUser) obj;
		if (userId != other.userId)
			return false;
		if (username == null) {
			if (other.username != null)
				return false;
		} else if (!username.equals(other.username))
			return false;
		return true;
	}

}