package org.gcube.vomanagement.usermanagement.model;

import java.io.Serializable;
import java.util.List;


/**
 * The Class GCubeGroup.
 */
@SuppressWarnings("serial")
public class GCubeGroup implements Serializable {
	
	long groupId;
	long parentGroupId;
	String groupName;
	String description;
	String friendlyURL;
	long logoId;
	int userCount;
	List<GCubeGroup> children;
	GroupMembershipType membershipType;
	
	/**
	 * Instantiates a new g cube group.
	 */
	public GCubeGroup() {
		super();
	}
	
	/**
	 * Instantiates a new g cube group.
	 *
	 * @param groupId the group id
	 * @param parentGroupId the parent group id
	 * @param groupName the group name
	 * @param description the description
	 * @param friendlyURL the friendly URL
	 * @param logoId the logo id
	 * @param children the children
	 */
	public GCubeGroup(long groupId, long parentGroupId, String groupName,
			String description, String friendlyURL, long logoId,
			List<GCubeGroup> children) {
		super();
		this.groupId = groupId;
		this.parentGroupId = parentGroupId;
		this.groupName = groupName;
		this.description = description;
		this.friendlyURL = friendlyURL;
		this.logoId = logoId;
		this.children = children;
		this.membershipType = GroupMembershipType.RESTRICTED;
	}
	
	/**
	 * Instantiates a new g cube group.
	 *
	 * @param groupId the group id
	 * @param parentGroupId the parent group id
	 * @param groupName the group name
	 * @param description the description
	 * @param friendlyURL the friendly URL
	 * @param logoId the logo id
	 * @param children the children
	 * @param membershipType the membership type
	 */
	public GCubeGroup(long groupId, long parentGroupId, String groupName,
			String description, String friendlyURL, long logoId,
			List<GCubeGroup> children, GroupMembershipType membershipType) {
		super();
		this.groupId = groupId;
		this.parentGroupId = parentGroupId;
		this.groupName = groupName;
		this.description = description;
		this.friendlyURL = friendlyURL;
		this.logoId = logoId;
		this.children = children;
		this.membershipType = membershipType;
	}

	/**
	 * @param groupId
	 * @param parentGroupId
	 * @param groupName
	 * @param description
	 * @param friendlyURL
	 * @param logoId
	 * @param userCount
	 * @param children
	 * @param membershipType
	 */
	public GCubeGroup(long groupId, long parentGroupId, String groupName,
			String description, String friendlyURL, long logoId, int userCount,
			List<GCubeGroup> children, GroupMembershipType membershipType) {
		super();
		this.groupId = groupId;
		this.parentGroupId = parentGroupId;
		this.groupName = groupName;
		this.description = description;
		this.friendlyURL = friendlyURL;
		this.logoId = logoId;
		this.userCount = userCount;
		this.children = children;
		this.membershipType = membershipType;
	}

	/**
	 * Gets the group id.
	 *
	 * @return the group id
	 */
	public long getGroupId() {
		return groupId;
	}


	/**
	 * Sets the group id.
	 *
	 * @param groupId the new group id
	 */
	public void setGroupId(long groupId) {
		this.groupId = groupId;
	}


	/**
	 * Gets the parent group id.
	 *
	 * @return the parent group id
	 */
	public long getParentGroupId() {
		return parentGroupId;
	}


	/**
	 * Sets the parent group id.
	 *
	 * @param parentGroupId the new parent group id
	 */
	public void setParentGroupId(long parentGroupId) {
		this.parentGroupId = parentGroupId;
	}


	/**
	 * Gets the group name.
	 *
	 * @return the group name
	 */
	public String getGroupName() {
		return groupName;
	}
	/**
	 * use getGroupName
	 * @return the name
	 */
	@Deprecated
	public String getName() {
		return groupName;
	}


	/**
	 * Sets the group name.
	 *
	 * @param groupName the new group name
	 */
	public void setGroupName(String groupName) {
		this.groupName = groupName;
	}


	/**
	 * Gets the description.
	 *
	 * @return the description
	 */
	public String getDescription() {
		return description;
	}


	/**
	 * Sets the description.
	 *
	 * @param description the new description
	 */
	public void setDescription(String description) {
		this.description = description;
	}


	/**
	 * Gets the friendly URL.
	 *
	 * @return the friendly URL
	 */
	public String getFriendlyURL() {
		return friendlyURL;
	}


	/**
	 * Sets the friendly URL.
	 *
	 * @param friendlyURL the new friendly URL
	 */
	public void setFriendlyURL(String friendlyURL) {
		this.friendlyURL = friendlyURL;
	}


	/**
	 * Gets the logo id.
	 *
	 * @return the logo id
	 */
	public long getLogoId() {
		return logoId;
	}


	/**
	 * Sets the logo id.
	 *
	 * @param logoId the new logo id
	 */
	public void setLogoId(long logoId) {
		this.logoId = logoId;
	}


	/**
	 * Gets the children.
	 *
	 * @return the children
	 */
	public List<GCubeGroup> getChildren() {
		return children;
	}


	/**
	 * Sets the children.
	 *
	 * @param children the new children
	 */
	public void setChildren(List<GCubeGroup> children) {
		this.children = children;
	}
	
	
	
	/**
	 * Gets the membership type.
	 *
	 * @return the membership type
	 */
	public GroupMembershipType getMembershipType() {
		return membershipType;
	}

	/**
	 * Sets the membership type.
	 *
	 * @param membershipType the new membership type
	 */
	public void setMembershipType(GroupMembershipType membershipType) {
		this.membershipType = membershipType;
	}

	/**
	 * Gets the user count.
	 *
	 * @return the user count
	 */
	public int getUserCount() {
		return userCount;
	}

	/**
	 * Sets the user count.
	 *
	 * @param userCount the new user count
	 */
	public void setUserCount(int userCount) {
		this.userCount = userCount;
	}

	@Override
	public String toString() {
		return "GCubeGroup [groupId=" + groupId + ", parentGroupId="
				+ parentGroupId + ", groupName=" + groupName + ", description="
				+ description + ", friendlyURL=" + friendlyURL + ", logoId="
				+ logoId + ", userCount=" + userCount + ", children="
				+ children + ", membershipType=" + membershipType + "]";
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		GCubeGroup other = (GCubeGroup) obj;
		if (groupId != other.groupId)
			return false;
		if (groupName == null) {
			if (other.groupName != null)
				return false;
		} else if (!groupName.equals(other.groupName))
			return false;
		return true;
	}

	
}
