/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vomanagement.usermanagement.impl.ws;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.gcube.vomanagement.usermanagement.UserManager;
import org.gcube.vomanagement.usermanagement.exception.GroupRetrievalFault;
import org.gcube.vomanagement.usermanagement.exception.RoleRetrievalFault;
import org.gcube.vomanagement.usermanagement.exception.TeamRetrievalFault;
import org.gcube.vomanagement.usermanagement.exception.UserManagementPortalException;
import org.gcube.vomanagement.usermanagement.exception.UserManagementSystemException;
import org.gcube.vomanagement.usermanagement.exception.UserRetrievalFault;
import org.gcube.vomanagement.usermanagement.impl.ws.LiferayWSRoleManager;
import org.gcube.vomanagement.usermanagement.impl.ws.utils.HttpUtils;
import org.gcube.vomanagement.usermanagement.model.Email;
import org.gcube.vomanagement.usermanagement.model.GCubeMembershipRequest;
import org.gcube.vomanagement.usermanagement.model.GCubeRole;
import org.gcube.vomanagement.usermanagement.model.GCubeUser;
import org.gcube.vomanagement.usermanagement.model.MembershipRequestStatus;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiferayWSUserManager
implements UserManager {
    private String schema;
    private String host;
    private int port;
    private HttpClientContext localContext;
    private CredentialsProvider credsProvider;
    private HttpHost target;
    private Long companyId;
    private static final String API_BASE_URL = "/api/jsonws";
    private static final String GET_COMPANY_ID = "/company/get-company-by-web-id/web-id/liferay.com";
    private static final String GET_USER_BY_USERNAME = "/user/get-user-by-screen-name/company-id/$COMPANY_ID/screen-name/$USER_ID";
    private static final String GET_USER_BY_EMAIL = "/user/get-user-by-email-address/company-id/$COMPANY_ID/email-address/$EMAIL";
    private static final String GET_USERS_BY_GROUP = "/user/get-group-users/group-id/$GROUP_ID";
    private static final String GET_USER_CUSTOM_FIELD_BY_KEY = "/expandovalue/get-json-data/company-id/$COMPANY_ID/class-name/com.liferay.portal.model.User/table-name/CUSTOM_FIELDS/column-name/$CUSTOM_FIELD_KEY/class-pk/$USER_ID";
    private static final String GET_CONTACT_BY_USER_ID = "/contact/get-contact/contact-id/$CONTACT_ID";
    private static final String GET_ROLES_IN_GROUP_BY_USER = "/role/get-user-group-roles/user-id/$USER_ID/group-id/$GROUP_ID";
    private static final String GET_IDS_USERS_HAVING_GLOBAL_ROLE = "/user/get-role-user-ids/role-id/$ROLE_ID";
    private static final String GET_USER_BY_ID = "/user/get-user-by-id/user-id/$USER_ID";
    private static final String GET_USER_ID_BY_GROUP = "/user/get-group-user-ids/group-id/$GROUP_ID";
    private static final Logger logger = LoggerFactory.getLogger(LiferayWSUserManager.class);
    private static final String USER_LOCATION_INDUSTRY_KEY = "industry";
    private static final int USERS_EXECUTOR_FACTOR = 20;

    public LiferayWSUserManager(String user, String password, String host, String schema, int port) throws Exception {
        this.host = host;
        this.port = port;
        this.schema = schema;
        this.target = new HttpHost(host, port, schema);
        this.credsProvider = new BasicCredentialsProvider();
        this.credsProvider.setCredentials(new AuthScope(this.target.getHostName(), this.target.getPort()), (Credentials)new UsernamePasswordCredentials(user, password));
        BasicAuthCache authCache = new BasicAuthCache();
        BasicScheme basicAuth = new BasicScheme();
        authCache.put(this.target, (AuthScheme)basicAuth);
        this.localContext = HttpClientContext.create();
        this.localContext.setAuthCache((AuthCache)authCache);
        this.retrieveCompanyId();
    }

    private void retrieveCompanyId() throws Exception {
        String json = HttpUtils.executeHTTPGETRequest("/api/jsonws/company/get-company-by-web-id/web-id/liferay.com", this.credsProvider, this.localContext, this.target);
        if (json == null) {
            throw new Exception("Failed to retrieve the company-id. The following calls will fail!");
        }
        JSONParser parser = new JSONParser();
        JSONObject jsonObject = (JSONObject)parser.parse(json);
        this.companyId = (Long)jsonObject.get("companyId");
        logger.info("Company id retrieved is " + this.companyId);
    }

    private GCubeUser mapLRUser(String json) {
        block4: {
            try {
                if (json == null) break block4;
                JSONParser parser = new JSONParser();
                JSONObject userJSON = (JSONObject)parser.parse(json);
                ArrayList<Email> emails = new ArrayList<Email>();
                String locationIndustry = "";
                try {
                    locationIndustry = (String)((Object)this.readCustomAttr((Long)userJSON.get("userId"), USER_LOCATION_INDUSTRY_KEY));
                }
                catch (Exception e1) {
                    logger.warn("Failed to retrieve property industry", (Throwable)e1);
                }
                long contactId = (Long)userJSON.get("contactId");
                String jsonContact = this.getContactJson(contactId);
                JSONObject contactJSON = (JSONObject)parser.parse(jsonContact);
                return new GCubeUser((long)((Long)userJSON.get("userId")), (String)userJSON.get("screenName"), (String)userJSON.get("emailAddress"), (String)userJSON.get("firstName"), (String)userJSON.get("middleName"), (String)userJSON.get("lastName"), this.buildFullName(userJSON), (long)((Long)userJSON.get("createDate")), this.getUserAvatarAbsoluteURL((String)userJSON.get("uuid"), (Long)userJSON.get("portraitId")), (boolean)((Boolean)contactJSON.get("male")), (String)userJSON.get("jobTitle"), locationIndustry, emails);
            }
            catch (Exception e) {
                logger.error("Exception while mapping the json user object to the GCubeUser java object", (Throwable)e);
            }
        }
        return null;
    }

    private String getUserAvatarAbsoluteURL(String userUuid, long portraitId) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        String imageId = URLEncoder.encode(Base64.encodeBase64String((byte[])md.digest(userUuid.getBytes())), "UTF-8");
        return this.schema + "://" + this.host + ":" + this.port + "/image/user_male_portrait?img_id=" + portraitId + "&img_id_token=" + imageId;
    }

    private String buildFullName(JSONObject userJSON) {
        String first = (String)userJSON.get("firstName");
        String middle = (String)userJSON.get("middleName");
        String last = (String)userJSON.get("lastName");
        String fullname = (String)(first == null | first.isEmpty() ? "" : first + " ") + (String)(middle == null | middle.isEmpty() ? "" : middle + " ") + (last == null | last.isEmpty() ? "" : last);
        fullname = fullname.endsWith(" ") ? fullname.substring(0, fullname.length() - 1) : fullname;
        logger.info("Built fullname is " + fullname);
        return fullname;
    }

    private String getContactJson(long contactId) {
        return HttpUtils.executeHTTPGETRequest(API_BASE_URL + GET_CONTACT_BY_USER_ID.replace("$CONTACT_ID", String.valueOf(contactId)), this.credsProvider, this.localContext, this.target);
    }

    @Override
    public GCubeUser createUser(boolean autoScreenName, String username, String email, String firstName, String middleName, String lastName, String jobTitle, String location_industry, String backgroundSummary, boolean male, String reminderQuestion, String reminderAnswer, int type) throws UserManagementSystemException {
        return null;
    }

    @Override
    public GCubeUser createUser(boolean autoScreenName, String username, String email, String firstName, String middleName, String lastName, String jobTitle, String location_industry, String backgroundSummary, boolean male, String reminderQuestion, String reminderAnswer, boolean sendEmail, boolean forcePasswordReset, int type) throws UserManagementSystemException {
        return null;
    }

    @Override
    public GCubeUser createUser(boolean autoScreenName, String username, String email, String firstName, String middleName, String lastName, String jobTitle, String location_industry, String backgroundSummary, boolean male, String reminderQuestion, String reminderAnswer, boolean sendEmail, boolean forcePasswordReset, byte[] portraitBytes, int type) throws UserManagementSystemException {
        return null;
    }

    @Override
    public GCubeUser createUser(boolean autoScreenName, String username, String email, String firstName, String middleName, String lastName, String jobTitle, String location_industry, String backgroundSummary, boolean male, String reminderQuestion, String reminderAnswer, boolean sendEmail, boolean forcePasswordReset, byte[] portraitBytes, String mySpacesn, String twittersn, String facebooksn, String skypesn, String jabbersn, String aimsn, int type) throws UserManagementSystemException {
        return null;
    }

    @Override
    public GCubeUser getUserByUsername(String username) throws UserManagementSystemException, UserRetrievalFault {
        String jsonUser = HttpUtils.executeHTTPGETRequest(API_BASE_URL + GET_USER_BY_USERNAME.replace("$COMPANY_ID", String.valueOf(this.companyId)).replace("$USER_ID", username), this.credsProvider, this.localContext, this.target);
        if (jsonUser != null) {
            logger.debug("Json user retrieved");
            return this.mapLRUser(jsonUser);
        }
        return null;
    }

    @Override
    public GCubeUser getUserByScreenName(String username) throws UserManagementSystemException, UserRetrievalFault {
        return this.getUserByUsername(username);
    }

    @Override
    public GCubeUser getUserByEmail(String email) throws UserManagementSystemException, UserRetrievalFault {
        String jsonUser = HttpUtils.executeHTTPGETRequest(API_BASE_URL + GET_USER_BY_EMAIL.replace("$COMPANY_ID", String.valueOf(this.companyId)).replace("$EMAIL", email), this.credsProvider, this.localContext, this.target);
        if (jsonUser != null) {
            logger.debug("Json user retrieved");
            return this.mapLRUser(jsonUser);
        }
        return null;
    }

    @Override
    public GCubeUser getUserById(long userId) throws UserManagementSystemException, UserRetrievalFault {
        String jsonUser = HttpUtils.executeHTTPGETRequest(API_BASE_URL + GET_USER_BY_ID.replace("$USER_ID", String.valueOf(userId)), this.credsProvider, this.localContext, this.target);
        if (jsonUser != null) {
            logger.debug("Json user retrieved");
            return this.mapLRUser(jsonUser);
        }
        return null;
    }

    @Override
    public long getUserId(String username) throws UserManagementSystemException, UserRetrievalFault {
        return 0L;
    }

    @Override
    public String getUserProfessionalBackground(long userId) throws UserManagementSystemException, UserRetrievalFault {
        return null;
    }

    @Override
    public void setUserProfessionalBackground(long userId, String summary) throws UserManagementSystemException, UserRetrievalFault {
    }

    @Override
    public List<GCubeUser> listUsers() throws UserManagementSystemException {
        return null;
    }

    @Override
    public List<GCubeUser> listUsers(boolean indexed) throws UserManagementSystemException {
        return null;
    }

    @Override
    public List<GCubeUser> listUsersByGroup(long groupId) throws UserManagementSystemException, GroupRetrievalFault, UserRetrievalFault {
        try {
            ExecutorService executor;
            final ArrayList<GCubeUser> toReturn = new ArrayList<GCubeUser>();
            String jsonUsers = HttpUtils.executeHTTPGETRequest(API_BASE_URL + GET_USERS_BY_GROUP.replace("$GROUP_ID", String.valueOf(groupId)), this.credsProvider, this.localContext, this.target);
            if (jsonUsers != null) {
                logger.debug("Trying to parse json users array ");
                JSONParser parser = new JSONParser();
                JSONArray array = (JSONArray)parser.parse(jsonUsers);
                int numberOfThreads = (int)Math.ceil((double)array.size() / 20.0);
                logger.trace("Number of concurrent threads is going to be " + numberOfThreads);
                executor = Executors.newFixedThreadPool(numberOfThreads);
                int start = 0;
                int offset = 20;
                for (int i = 0; i < numberOfThreads; ++i) {
                    start = 20 * i;
                    offset = start + offset > array.size() ? array.size() - start : offset;
                    logger.trace("Start = " + start + ", offset=" + offset);
                    final List usersPortion = array.subList(start, start + offset);
                    executor.submit(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            logger.debug("Thread is " + Thread.currentThread().getName());
                            ArrayList<GCubeUser> localList = new ArrayList<GCubeUser>();
                            for (int i = 0; i < usersPortion.size(); ++i) {
                                localList.add(LiferayWSUserManager.this.mapLRUser(((JSONObject)usersPortion.get(i)).toJSONString()));
                            }
                            List list = toReturn;
                            synchronized (list) {
                                toReturn.addAll(localList);
                            }
                        }
                    });
                }
            } else {
                return null;
            }
            executor.shutdown();
            executor.awaitTermination(2L, TimeUnit.MINUTES);
            return toReturn;
        }
        catch (Exception e) {
            logger.error("Something went wrong, sorry", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<GCubeUser> listUsersByGroup(long groupId, boolean indexed) throws UserManagementSystemException, GroupRetrievalFault, UserRetrievalFault {
        return null;
    }

    @Override
    public List<GCubeUser> listUsersByGroupName(String name) throws UserManagementSystemException, GroupRetrievalFault, UserRetrievalFault {
        return null;
    }

    @Override
    public Set<GCubeUser> getUserContactsByGroup(long userId, long scopeGroupId) throws UserManagementSystemException, GroupRetrievalFault, UserRetrievalFault {
        return null;
    }

    @Override
    public List<GCubeMembershipRequest> listMembershipRequestsByGroup(long groupId) throws UserManagementSystemException, GroupRetrievalFault, UserRetrievalFault {
        return null;
    }

    @Override
    public List<GCubeMembershipRequest> listPendingMembershipRequestsByGroup(long groupId) throws UserManagementSystemException, GroupRetrievalFault, UserRetrievalFault {
        return null;
    }

    @Override
    public GCubeMembershipRequest getMembershipRequestsById(long membershipRequestId) {
        return null;
    }

    @Override
    public List<GCubeMembershipRequest> getMembershipRequests(long userId, long groupId, MembershipRequestStatus status) throws UserManagementSystemException, GroupRetrievalFault, UserRetrievalFault {
        return null;
    }

    @Override
    public GCubeMembershipRequest requestMembership(long userId, long groupId, String comment) throws UserManagementSystemException, GroupRetrievalFault, UserRetrievalFault {
        return null;
    }

    @Override
    public GCubeMembershipRequest acceptMembershipRequest(long requestUserId, long groupId, boolean addUserToGroup, String replyUsername, String replyComment) throws UserManagementSystemException, GroupRetrievalFault, UserManagementPortalException {
        return null;
    }

    @Override
    public GCubeMembershipRequest rejectMembershipRequest(long userId, long groupId, String replyUsername, String replyComment) throws UserManagementSystemException, GroupRetrievalFault, UserManagementPortalException {
        return null;
    }

    @Override
    public Map<GCubeUser, List<GCubeRole>> listUsersAndRolesByGroup(long groupId) throws GroupRetrievalFault, UserManagementSystemException, UserRetrievalFault {
        return null;
    }

    @Override
    public List<GCubeUser> listUsersByGroupAndRole(final long groupId, final long roleId) throws UserManagementSystemException, RoleRetrievalFault, GroupRetrievalFault, UserRetrievalFault {
        final ArrayList<GCubeUser> toReturn = new ArrayList<GCubeUser>(0);
        try {
            List<GCubeUser> usersInGroup = this.listUsersByGroup(groupId);
            logger.debug("Number of users is " + usersInGroup.size());
            if (usersInGroup == null || usersInGroup.isEmpty()) {
                return toReturn;
            }
            int numberOfThreads = (int)Math.ceil((double)usersInGroup.size() / 20.0);
            logger.trace("Number of concurrent threads is going to be " + numberOfThreads);
            ExecutorService executor = Executors.newFixedThreadPool(numberOfThreads);
            int start = 0;
            int offset = 20;
            for (int i = 0; i < numberOfThreads; ++i) {
                start = 20 * i;
                offset = start + offset > usersInGroup.size() ? usersInGroup.size() - start : offset;
                logger.trace("Start = " + start + ", offset=" + offset);
                final List<GCubeUser> usersPortion = usersInGroup.subList(start, start + offset);
                executor.submit(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        logger.debug("Thread is " + Thread.currentThread().getName());
                        ArrayList<GCubeUser> localUsersHavingRole = new ArrayList<GCubeUser>(0);
                        for (GCubeUser user : usersPortion) {
                            long userId = user.getUserId();
                            String userRoles = HttpUtils.executeHTTPGETRequest(LiferayWSUserManager.API_BASE_URL + LiferayWSUserManager.GET_ROLES_IN_GROUP_BY_USER.replace("$GROUP_ID", String.valueOf(groupId)).replace("$USER_ID", String.valueOf(userId)), LiferayWSUserManager.this.credsProvider, LiferayWSUserManager.this.localContext, LiferayWSUserManager.this.target);
                            boolean userHasRole = false;
                            JSONParser parser = new JSONParser();
                            try {
                                JSONArray array = (JSONArray)parser.parse(userRoles);
                                for (int i = 0; i < array.size(); ++i) {
                                    try {
                                        GCubeRole role = LiferayWSRoleManager.mapLRRole(array.get(i).toString());
                                        if (role.getRoleId() != roleId) continue;
                                        userHasRole = true;
                                        break;
                                    }
                                    catch (PortalException | SystemException | ParseException e) {
                                        logger.warn("Failed to retrieve a role for user " + user.getUsername());
                                    }
                                }
                                if (!userHasRole) continue;
                                localUsersHavingRole.add(user);
                            }
                            catch (ParseException e1) {
                                logger.warn("Failed to parse role for user " + user.getUsername());
                            }
                        }
                        List list = toReturn;
                        synchronized (list) {
                            toReturn.addAll(localUsersHavingRole);
                        }
                    }
                });
            }
            executor.shutdown();
            executor.awaitTermination(2L, TimeUnit.MINUTES);
        }
        catch (Exception e) {
            logger.warn("Failed to retrieve users that have role whit id " + roleId + " in group with id " + groupId);
            return null;
        }
        return toReturn;
    }

    @Override
    public List<GCubeUser> listUsersByTeam(long teamId) throws UserManagementSystemException, TeamRetrievalFault, UserRetrievalFault {
        return null;
    }

    @Override
    public void assignUserToGroup(long groupId, long userId) throws UserManagementSystemException, GroupRetrievalFault, UserRetrievalFault, UserManagementPortalException {
    }

    @Override
    public void dismissUserFromGroup(long groupId, long userId) throws UserManagementSystemException, GroupRetrievalFault, UserRetrievalFault {
    }

    @Override
    public List<GCubeUser> listUnregisteredUsersByGroup(long groupId) throws UserManagementSystemException, GroupRetrievalFault, UserRetrievalFault {
        return null;
    }

    @Override
    public boolean isPasswordChanged(String email) {
        return false;
    }

    @Override
    public boolean userExistsByEmail(String email) {
        return false;
    }

    @Override
    public String getFullNameFromEmail(String email) {
        return null;
    }

    @Override
    public void deleteUserByEMail(String email) throws UserManagementSystemException, UserManagementPortalException, PortalException, SystemException {
    }

    @Override
    public byte[] getUserAvatarBytes(String screenName) {
        return null;
    }

    @Override
    public String getUserOpenId(String screenName) {
        return null;
    }

    @Override
    public boolean updateContactInformation(String screenName, String mySpacesn, String twittersn, String facebooksn, String skypesn, String jabbersn, String aimsn) {
        return false;
    }

    @Override
    public boolean updateJobTitle(long userId, String theJob) {
        return false;
    }

    @Override
    public Serializable readCustomAttr(long userId, String attributeKey) throws UserRetrievalFault {
        String toReturn = null;
        try {
            String jsonCustomField = HttpUtils.executeHTTPGETRequest(API_BASE_URL + GET_USER_CUSTOM_FIELD_BY_KEY.replace("$COMPANY_ID", String.valueOf(this.companyId)).replace("$CUSTOM_FIELD_KEY", attributeKey).replace("$USER_ID", String.valueOf(userId)), this.credsProvider, this.localContext, this.target);
            if (jsonCustomField != null) {
                logger.debug("Trying to parse custom field in json object");
                JSONParser parser = new JSONParser();
                JSONObject obj = (JSONObject)parser.parse(jsonCustomField);
                toReturn = (String)obj.get("data");
            }
        }
        catch (Exception e) {
            logger.error("Something went wrong, sorry", (Throwable)e);
            return null;
        }
        return toReturn;
    }

    @Override
    public void saveCustomAttr(long userId, String attributeKey, Serializable value) throws UserRetrievalFault {
    }

    @Override
    public List<GCubeUser> listUsersByGlobalRole(long roleId) {
        ArrayList<GCubeUser> toReturn = null;
        try {
            String listIds = HttpUtils.executeHTTPGETRequest(API_BASE_URL + GET_IDS_USERS_HAVING_GLOBAL_ROLE.replace("$ROLE_ID", String.valueOf(roleId)), this.credsProvider, this.localContext, this.target);
            if (listIds != null) {
                toReturn = new ArrayList<GCubeUser>();
                JSONParser parser = new JSONParser();
                JSONArray ids = (JSONArray)parser.parse(listIds);
                for (int i = 0; i < ids.size(); ++i) {
                    try {
                        toReturn.add(this.getUserById(Long.valueOf(ids.get(i).toString())));
                        continue;
                    }
                    catch (Exception e) {
                        logger.warn("Failed to retrieve user information", (Throwable)e);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("Failed to retrieve the list");
            return null;
        }
        return toReturn;
    }

    @Override
    public List<Long> getUserIdsByGroup(long groupId) {
        ArrayList<Long> toReturn = null;
        try {
            String listIds = HttpUtils.executeHTTPGETRequest(API_BASE_URL + GET_USER_ID_BY_GROUP.replace("$GROUP_ID", String.valueOf(groupId)), this.credsProvider, this.localContext, this.target);
            if (listIds != null) {
                toReturn = new ArrayList<Long>();
                JSONParser parser = new JSONParser();
                JSONArray ids = (JSONArray)parser.parse(listIds);
                for (int i = 0; i < ids.size(); ++i) {
                    try {
                        toReturn.add(Long.valueOf(ids.get(i).toString()));
                        continue;
                    }
                    catch (Exception e) {
                        logger.warn("Failed to retrieve user information", (Throwable)e);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("Failed to retrieve the list of identifiers", (Throwable)e);
            return null;
        }
        return toReturn;
    }

    @Override
    public List<GCubeUser> listUsers(int start, int end) throws UserManagementSystemException {
        return null;
    }

    @Override
    public int getUsersCount() throws UserManagementSystemException {
        return 0;
    }

    @Override
    public List<GCubeUser> searchUsersByGroup(String keywords, long groupId) throws GroupRetrievalFault {
        return null;
    }

    @Override
    public List<GCubeUser> listUsersByGroup(long groupId, int start, int end) throws UserManagementSystemException, GroupRetrievalFault, UserRetrievalFault {
        return null;
    }

    @Override
    public int getGroupUsersCount(long groupId) throws GroupRetrievalFault {
        return 0;
    }

    @Override
    public long[] listUserIdsByGroupAndRole(long groupId, long roleId) {
        return null;
    }
}

