/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.portal;

import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.VirtualHost;
import com.liferay.portal.kernel.service.CompanyLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.service.VirtualHostLocalServiceUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.gcube.common.authorization.client.Constants;
import org.gcube.common.authorization.client.exceptions.ObjectNotFound;
import org.gcube.common.authorization.library.provider.UserInfo;
import org.gcube.common.security.AuthorizedTasks;
import org.gcube.common.security.providers.SecretManagerProvider;
import org.gcube.common.security.secrets.Secret;
import org.gcube.vomanagement.usermanagement.UserManager;
import org.gcube.vomanagement.usermanagement.exception.UserManagementSystemException;
import org.gcube.vomanagement.usermanagement.exception.UserRetrievalFault;
import org.gcube.vomanagement.usermanagement.impl.LiferayGroupManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayUserManager;
import org.gcube.vomanagement.usermanagement.model.CustomAttributeKeys;
import org.gcube.vomanagement.usermanagement.model.GCubeUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortalContext {
    private static final Logger _log = LoggerFactory.getLogger(PortalContext.class);
    public static final String VRE_ID_ATTR_NAME = "gcube-vreid";
    public static final String USER_ID_ATTR_NAME = "gcube-userId";
    protected static final String SCOPE_SEPARATOR = "/";
    private static final String REGEX_ISNUMBER = "\\d+";
    private static final String DEFAULT_ROLE = "OrganizationMember";
    public static final String CONFIGURATION_FOLDER = "conf";
    public static final String INFRA_PROPERTY_FILENAME = "infrastructure.properties";
    private static final String GCUBE_DEV__CONTEXT_PROPERTY_FILENAME = "gcube-dev-context.properties";
    private static final String DEV_USERNAME_ATTR = "user.username";
    private static final String DEV_USER_NAME_ATTR = "user.name";
    private static final String DEV_USER_LASTNAME_ATTR = "user.lastname";
    private static final String DEV_USER_EMAIL_ATTR = "user.email";
    private static final String DEV_SCOPE_ATTR = "development.context";
    private static final String DEV_GROUP_NAME_ATTR = "development.groupname";
    private static final String DEV_GROUP_ID_ATTR = "development.groupid";
    private static final String DEV_TOKEN_ATTR = "user.token";
    private static final String DEFAULT_INFRA_NAME = "gcube";
    private static final String DEFAULT_VO_NAME = "devsec";
    private static final String DEFAULT_GATEWAY_NAME = "D4science Gateway";
    private static final String DEFAULT_GATEWAY_EMAIL = "do-not-reply@d4science.org";
    private static PortalContext singleton = new PortalContext();
    private UserManager userManager;
    private String infra;
    private String vos;

    private PortalContext() {
        this.initialize();
    }

    public static synchronized PortalContext getConfiguration() {
        return singleton == null ? new PortalContext() : singleton;
    }

    private void initialize() {
        Properties props = new Properties();
        try {
            StringBuilder sb = new StringBuilder(PortalContext.getCatalinaHome());
            sb.append(File.separator).append(CONFIGURATION_FOLDER).append(File.separator).append(INFRA_PROPERTY_FILENAME);
            String propertyfile = sb.toString();
            File propsFile = new File(propertyfile);
            FileInputStream fis = new FileInputStream(propsFile);
            props.load(fis);
            this.infra = props.getProperty("infrastructure");
            this.vos = props.getProperty("scopes");
            this.userManager = new LiferayUserManager();
        }
        catch (IOException e) {
            this.infra = DEFAULT_INFRA_NAME;
            this.vos = DEFAULT_VO_NAME;
            this.userManager = new LiferayUserManager();
            _log.error("infrastructure.properties file not found under $CATALINA_HOME/conf/ dir, setting default infrastructure Name " + this.infra + " and VO Name " + this.vos);
        }
        _log.info("PortalContext configurator correctly initialized on " + this.infra);
    }

    public String getInfrastructureName() {
        return this.infra;
    }

    public String getVOsAsString() {
        return this.vos;
    }

    public GCubeUser getCurrentUser(HttpServletRequest httpServletRequest) {
        String userIdNo = httpServletRequest.getHeader(USER_ID_ATTR_NAME);
        long userId = -1L;
        if (userIdNo != null && userIdNo.matches(REGEX_ISNUMBER)) {
            try {
                _log.debug("The userIdNo is " + userIdNo);
                userId = Long.parseLong(userIdNo);
                return this.userManager.getUserById(userId);
            }
            catch (NumberFormatException e) {
                _log.error("The userId is not a number -> " + userId);
            }
            catch (Exception e) {
                _log.error("Could not read the current userid from header param, either session expired or user not logged in, exception: " + e.getMessage());
            }
        } else {
            if (!this.isWithinPortal()) {
                GCubeUser toReturn = PortalContext.readUserFromPropertyFile();
                _log.debug("getCurrentUser devMode into IDE detected, returning testing user: " + toReturn.toString());
                return toReturn;
            }
            try {
                HttpSession session = httpServletRequest.getSession(false);
                userId = (Long)session.getAttribute(USER_ID_ATTR_NAME);
                _log.debug("read the current userid from the http session userId: " + userId + " sessionid=" + session.getId());
                return this.userManager.getUserById(userId);
            }
            catch (Exception e) {
                _log.error("Could not read the current userid from the http session, either session expired or user not logged in, exception: " + e.getMessage());
                return null;
            }
        }
        return null;
    }

    public static void setUserInSession(RenderRequest request) {
        long userId = Long.parseLong(request.getRemoteUser());
        HttpServletRequest httpServletRequest = PortalUtil.getHttpServletRequest((PortletRequest)request);
        HttpSession session = httpServletRequest.getSession();
        _log.debug("HttpSession#setUserInSession, set userId: " + userId + " sessionid=" + session.getId());
        session.setAttribute(USER_ID_ATTR_NAME, (Object)userId);
    }

    public String getCurrentScope(String scopeGroupId) {
        if (scopeGroupId != null && scopeGroupId.matches(REGEX_ISNUMBER)) {
            long groupId = -1L;
            try {
                groupId = Long.parseLong(scopeGroupId);
                LiferayGroupManager gm = new LiferayGroupManager();
                if (gm.isRootVO(groupId).booleanValue()) {
                    return SCOPE_SEPARATOR + this.getInfrastructureName();
                }
                return new LiferayGroupManager().getInfrastructureScope(groupId);
            }
            catch (NumberFormatException e) {
                _log.error("The groupId is not a number -> " + groupId);
            }
            catch (Exception e) {
                _log.error("This groupId does not belong to any group in this portal -> " + groupId);
            }
        } else if (!this.isWithinPortal()) {
            String toReturn = PortalContext.readContextPropertyFile();
            _log.debug("getCurrentScope devMode into IDE detected, returning scope: " + toReturn.toString());
            _log.debug("The PortalBeanLocatorUtil stacktrace (java.lang.Exception) is acceptable in dev");
            return toReturn;
        }
        return null;
    }

    public String getCurrentScope(HttpServletRequest httpServletRequest) {
        String scopeGroupId = httpServletRequest.getHeader(VRE_ID_ATTR_NAME);
        return this.getCurrentScope(scopeGroupId);
    }

    public String getCurrentGroupName(HttpServletRequest httpServletRequest) {
        String groupIdNo = httpServletRequest.getHeader(VRE_ID_ATTR_NAME);
        if (groupIdNo != null && groupIdNo.matches(REGEX_ISNUMBER)) {
            long groupId = -1L;
            try {
                groupId = Long.parseLong(groupIdNo);
                LiferayGroupManager gm = new LiferayGroupManager();
                return gm.getGroup(groupId).getGroupName();
            }
            catch (NumberFormatException e) {
                _log.error("The groupId is not a number -> " + groupId);
            }
            catch (Exception e) {
                _log.error("This groupId does not belong to any group in this portal -> " + groupId);
            }
        } else if (!this.isWithinPortal()) {
            String toReturn = PortalContext.readGroupNamePropertyFile();
            _log.debug("getCurrentGroupName devMode into IDE detected, returning group name: " + toReturn.toString());
            _log.debug("The PortalBeanLocatorUtil stacktrace (java.lang.Exception) is acceptable in dev");
            return toReturn;
        }
        return null;
    }

    public long getCurrentGroupId(HttpServletRequest httpServletRequest) {
        String groupIdNo = httpServletRequest.getHeader(VRE_ID_ATTR_NAME);
        if (groupIdNo != null && groupIdNo.matches(REGEX_ISNUMBER)) {
            long groupId = -1L;
            try {
                groupId = Long.parseLong(groupIdNo);
                return groupId;
            }
            catch (NumberFormatException e) {
                _log.error("The groupId is not a number -> " + groupId);
            }
            catch (Exception e) {
                _log.error("This groupId does not belong to any group in this portal -> " + groupId);
            }
        } else if (!this.isWithinPortal()) {
            long toReturn = PortalContext.readGroupIdPropertyFile();
            _log.debug("getCurrentGroup devMode into IDE detected, returning groupid = " + toReturn);
            _log.debug("The PortalBeanLocatorUtil stacktrace (java.lang.Exception) is acceptable in dev");
            return toReturn;
        }
        return -1L;
    }

    public String getCurrentUserToken(String scope, long userId) {
        if (this.isWithinPortal()) {
            try {
                String username = this.userManager.getUserById(userId).getUsername();
                return this.getCurrentUserToken(scope, username);
            }
            catch (UserManagementSystemException | UserRetrievalFault e) {
                e.printStackTrace();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        } else {
            String toReturn = PortalContext.readTokenPropertyFile();
            _log.debug("getCurrentToken devMode into IDE detected, returning token: " + toReturn.toString());
            _log.debug("The PortalBeanLocatorUtil stacktrace (java.lang.Exception) is acceptable in dev");
            return toReturn;
        }
        return null;
    }

    public String getCurrentUserToken(String scope, String username) throws Throwable {
        if (this.isWithinPortal()) {
            Secret secret = SecretManagerProvider.get();
            String userToken = (String)AuthorizedTasks.executeSafely(() -> {
                try {
                    return Constants.authorizationService().resolveTokenByUserAndContext(username, scope);
                }
                catch (ObjectNotFound ex) {
                    String token = PortalContext.generateAuthorizationToken(username, scope);
                    _log.debug("generateAuthorizationToken OK for " + username + " in scope " + scope);
                    return token;
                }
                catch (Exception e) {
                    _log.error("Error while trying to generate token for user " + username + "in scope " + scope);
                    e.printStackTrace();
                    return null;
                }
            }, (Secret)secret);
            return userToken;
        }
        String toReturn = PortalContext.readTokenPropertyFile();
        _log.debug("getCurrentToken devMode into IDE detected, returning token: " + toReturn.toString());
        _log.debug("The PortalBeanLocatorUtil stacktrace (java.lang.Exception) is acceptable in dev");
        return toReturn;
    }

    public String getCurrentUserToken(HttpServletRequest httpServletRequest) {
        String groupIdNo = httpServletRequest.getHeader(VRE_ID_ATTR_NAME);
        String userToken = null;
        if (groupIdNo != null && groupIdNo.matches(REGEX_ISNUMBER)) {
            String scope = this.getCurrentScope(httpServletRequest);
            String username = this.getCurrentUser(httpServletRequest).getUsername();
            try {
                userToken = Constants.authorizationService().resolveTokenByUserAndContext(username, scope);
            }
            catch (ObjectNotFound ex) {
                userToken = PortalContext.generateAuthorizationToken(username, scope);
                _log.debug("generateAuthorizationToken OK for " + username + " in scope " + scope);
            }
            catch (Exception e) {
                _log.error("Error while trying to generate token for user " + username + "in scope " + scope);
                e.printStackTrace();
                return null;
            }
        } else if (this.isWithinPortal()) {
            _log.warn("It seems your app is running in Liferay but not context was set on this (HttpServletRequest) request");
        } else {
            String toReturn = PortalContext.readTokenPropertyFile();
            _log.debug("getCurrentToken devMode into IDE detected, returning scope: " + toReturn.toString());
            _log.debug("The PortalBeanLocatorUtil stacktrace (java.lang.Exception) is acceptable in dev");
            return toReturn;
        }
        return userToken;
    }

    private static String generateAuthorizationToken(String username, String scope) {
        String token;
        ArrayList<String> userRoles = new ArrayList<String>();
        userRoles.add(DEFAULT_ROLE);
        try {
            token = Constants.authorizationService().generateUserToken(new UserInfo(username, userRoles), scope);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return token;
    }

    private boolean isWithinPortal() {
        try {
            UserLocalServiceUtil.getService();
            return true;
        }
        catch (Exception ex) {
            _log.trace("Development Mode ON");
            return false;
        }
    }

    public List<String> getVOs() {
        ArrayList<String> toReturn = new ArrayList<String>();
        if (this.vos == null || this.vos.equals("")) {
            return toReturn;
        }
        String[] split = this.vos.split(",");
        for (int i = 0; i < split.length; ++i) {
            toReturn.add(split[i].trim());
        }
        return toReturn;
    }

    @Deprecated
    public static String getPortalInstanceName() {
        return PortalContext.getConfiguration().getGatewayName();
    }

    public String getGatewayURL(HttpServletRequest httpServletRequest) {
        String serverName = httpServletRequest.getServerName();
        Object toReturn = httpServletRequest.isSecure() ? "https://" : "http://";
        toReturn = (String)toReturn + serverName;
        toReturn = httpServletRequest.isSecure() ? (String)toReturn + (String)(httpServletRequest.getServerPort() == 443 ? "" : ":" + httpServletRequest.getServerPort()) : (String)toReturn + (String)(httpServletRequest.getServerPort() == 80 ? "" : ":" + httpServletRequest.getServerPort());
        return toReturn;
    }

    public String getGatewayURL(String serverName, int serverPort, boolean secure) {
        return PortalUtil.getPortalURL((String)serverName, (int)serverPort, (boolean)secure);
    }

    @Deprecated
    public String getGatewayURL() {
        Long defaultCompanyId = PortalUtil.getDefaultCompanyId();
        try {
            CompanyLocalServiceUtil.getCompany((long)defaultCompanyId);
            return PortalUtil.getPortalURL((String)CompanyLocalServiceUtil.getCompany((long)defaultCompanyId).getVirtualHostname(), (int)443, (boolean)true);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public String getSiteLandingPagePath(HttpServletRequest request) {
        String sitePath = "";
        try {
            Group site = this.getSiteFromServletRequest(request);
            if (site.getPrivateLayoutsPageCount() > 0) {
                sitePath = PortalContext.getGroupFriendlyURL(site);
            } else {
                _log.debug(site.getName() + " site doesn't have any private page. Default landing page will be used");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sitePath;
    }

    public String getSiteLandingPagePath(String serverName) {
        String sitePath = "";
        try {
            Group site = this.getSiteFromServerName(serverName);
            if (site.getPrivateLayoutsPageCount() > 0) {
                sitePath = PortalContext.getGroupFriendlyURL(site);
            } else {
                _log.debug(site.getName() + " site doesn't have any private page. Default landing page will be used");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sitePath;
    }

    private Group getSiteFromServletRequest(HttpServletRequest request) throws Exception {
        String serverName = request.getServerName();
        Group site = null;
        List vHosts = VirtualHostLocalServiceUtil.getVirtualHosts((int)0, (int)VirtualHostLocalServiceUtil.getVirtualHostsCount());
        for (VirtualHost virtualHost : vHosts) {
            if (virtualHost.getHostname().compareTo("localhost") == 0 || virtualHost.getLayoutSetId() == 0L || virtualHost.getHostname().compareTo(serverName) != 0) continue;
            long layoutSetId = virtualHost.getLayoutSetId();
            site = LayoutSetLocalServiceUtil.getLayoutSet((long)layoutSetId).getGroup();
            return site;
        }
        _log.warn("serverName is " + serverName + " but i could not find any virtualHost associated to it");
        return null;
    }

    private Group getSiteFromServerName(String serverName) throws Exception {
        _log.debug("serverName passed is " + serverName);
        Group site = null;
        List vHosts = VirtualHostLocalServiceUtil.getVirtualHosts((int)0, (int)VirtualHostLocalServiceUtil.getVirtualHostsCount());
        for (VirtualHost virtualHost : vHosts) {
            _log.debug("Found  " + virtualHost.getHostname());
            if (virtualHost.getHostname().compareTo("localhost") == 0 || virtualHost.getLayoutSetId() == 0L || virtualHost.getHostname().compareTo(serverName) != 0) continue;
            long layoutSetId = virtualHost.getLayoutSetId();
            site = LayoutSetLocalServiceUtil.getLayoutSet((long)layoutSetId).getGroup();
            _log.debug("Found match! Your site is " + site.getName());
            return site;
        }
        return null;
    }

    private static String getGroupFriendlyURL(Group currentGroup) throws Exception {
        String friendlyURL = "/group";
        StringBuffer sb = new StringBuffer();
        sb.append(friendlyURL).append(currentGroup.getFriendlyURL());
        return sb.toString();
    }

    public String getGatewayName(String serverName) {
        String toReturn = DEFAULT_GATEWAY_NAME;
        try {
            Group currSite = this.getSiteFromServerName(serverName);
            toReturn = currSite.getName();
        }
        catch (Exception e) {
            toReturn = DEFAULT_GATEWAY_NAME;
            _log.error("Could not read Site Custom Attr: " + CustomAttributeKeys.GATEWAY_SITE_NAME.getKeyName() + ", returning default Gateway Name " + toReturn);
        }
        return toReturn;
    }

    public String getGatewayName(HttpServletRequest request) {
        String toReturn = DEFAULT_GATEWAY_NAME;
        try {
            Group currSite = this.getSiteFromServletRequest(request);
            toReturn = currSite.getName();
        }
        catch (Exception e) {
            toReturn = DEFAULT_GATEWAY_NAME;
            _log.error("Could not read Site Custom Attr: " + CustomAttributeKeys.GATEWAY_SITE_NAME.getKeyName() + ", returning default Gateway Name " + toReturn);
        }
        return toReturn;
    }

    @Deprecated
    public String getGatewayName() {
        Properties props = new Properties();
        String toReturn = "";
        try {
            String propertyfile = PortalContext.getCatalinaHome() + File.separator + CONFIGURATION_FOLDER + File.separator + "gcube-data.properties";
            File propsFile = new File(propertyfile);
            FileInputStream fis = new FileInputStream(propsFile);
            props.load(fis);
            toReturn = props.getProperty("portalinstancename");
        }
        catch (IOException e) {
            toReturn = DEFAULT_GATEWAY_NAME;
            _log.error("gcube-data.properties file not found under $CATALINA_HOME/conf dir, returning default Portal Name " + toReturn);
            return toReturn;
        }
        _log.debug("Returning Gateway Name: " + toReturn);
        return toReturn;
    }

    public String getSenderEmail(HttpServletRequest request) {
        String toReturn = DEFAULT_GATEWAY_EMAIL;
        try {
            Group currSite = this.getSiteFromServletRequest(request);
            toReturn = (String)((Object)new LiferayGroupManager().readCustomAttr(currSite.getGroupId(), CustomAttributeKeys.GATEWAY_SITE_EMAIL_SENDER.getKeyName()));
        }
        catch (Exception e) {
            toReturn = DEFAULT_GATEWAY_EMAIL;
            _log.error("Could not read Site Custom Attr: " + CustomAttributeKeys.GATEWAY_SITE_EMAIL_SENDER.getKeyName() + ", returning default Gateway Email Sender " + toReturn);
        }
        return toReturn;
    }

    public String getSenderEmail(String serverName) {
        String toReturn = DEFAULT_GATEWAY_EMAIL;
        try {
            Group currSite = this.getSiteFromServerName(serverName);
            toReturn = (String)((Object)new LiferayGroupManager().readCustomAttr(currSite.getGroupId(), CustomAttributeKeys.GATEWAY_SITE_EMAIL_SENDER.getKeyName()));
        }
        catch (Exception e) {
            toReturn = DEFAULT_GATEWAY_EMAIL;
            _log.error("Could not read Site Custom Attr: " + CustomAttributeKeys.GATEWAY_SITE_EMAIL_SENDER.getKeyName() + ", returning default Gateway Email Sender " + toReturn);
        }
        return toReturn;
    }

    public static String getPortalApplicationToken() {
        Properties props = new Properties();
        String toReturn = "";
        try {
            String propertyfile = PortalContext.getCatalinaHome() + File.separator + CONFIGURATION_FOLDER + File.separator + "gcube-data.properties";
            File propsFile = new File(propertyfile);
            FileInputStream fis = new FileInputStream(propsFile);
            props.load(fis);
            toReturn = props.getProperty("portalAuthToken");
        }
        catch (IOException e) {
            toReturn = null;
            _log.error("gcube-data.properties file or portal app token not found under $CATALINA_HOME/conf dir, please add the property and or a valid token: portalAuthToken");
            return toReturn;
        }
        return toReturn;
    }

    public static String getICProxyEndPoint() {
        Properties props = new Properties();
        String toReturn = "";
        try {
            String propertyfile = PortalContext.getCatalinaHome() + File.separator + CONFIGURATION_FOLDER + File.separator + "gcube-data.properties";
            File propsFile = new File(propertyfile);
            FileInputStream fis = new FileInputStream(propsFile);
            props.load(fis);
            toReturn = props.getProperty("ic-proxy-endpointURL");
        }
        catch (IOException e) {
            toReturn = null;
            _log.error("gcube-data.properties file or portal app token not found under $CATALINA_HOME/conf dir, please add the property and or a valid token: portalAuthToken");
            return toReturn;
        }
        return toReturn;
    }

    @Deprecated
    public String getSenderEmail() {
        Properties props = new Properties();
        String toReturn = "";
        try {
            String propertyfile = PortalContext.getCatalinaHome() + File.separator + CONFIGURATION_FOLDER + File.separator + "gcube-data.properties";
            File propsFile = new File(propertyfile);
            FileInputStream fis = new FileInputStream(propsFile);
            props.load(fis);
            toReturn = props.getProperty("notificationSenderEmail");
        }
        catch (IOException e) {
            toReturn = DEFAULT_GATEWAY_EMAIL;
            _log.error("gcube-data.properties file not found under $CATALINA_HOME/conf dir, returning default Email" + toReturn);
            return toReturn;
        }
        _log.debug("Returning SENDER_EMAIL: " + toReturn);
        return toReturn;
    }

    protected static GCubeUser readUserFromPropertyFile() {
        Properties props = new Properties();
        try {
            StringBuilder sb = new StringBuilder(PortalContext.getGCubeDevHome());
            sb.append(File.separator).append(GCUBE_DEV__CONTEXT_PROPERTY_FILENAME);
            String propertyfile = sb.toString();
            File propsFile = new File(propertyfile);
            FileInputStream fis = new FileInputStream(propsFile);
            props.load(fis);
            long userId = -1L;
            String username = props.getProperty(DEV_USERNAME_ATTR);
            String email = props.getProperty(DEV_USER_EMAIL_ATTR);
            String firstName = props.getProperty(DEV_USER_NAME_ATTR);
            String middleName = "";
            String lastName = props.getProperty(DEV_USER_LASTNAME_ATTR);
            String fullname = firstName + lastName;
            long registrationDate = -1L;
            String userAvatarId = "-1";
            boolean male = true;
            String jobTitle = "TestingAccount";
            ArrayList emailAddresses = new ArrayList();
            return new GCubeUser(userId, username, email, firstName, middleName, lastName, fullname, registrationDate, userAvatarId, male, jobTitle, emailAddresses);
        }
        catch (IOException e) {
            _log.error("gcube-dev-context.properties file not found under $GCUBE_DEV_HOME dir");
            return null;
        }
    }

    private static String readTokenPropertyFile() {
        Properties props = new Properties();
        try {
            StringBuilder sb = new StringBuilder(PortalContext.getGCubeDevHome());
            sb.append(File.separator).append(GCUBE_DEV__CONTEXT_PROPERTY_FILENAME);
            String propertyfile = sb.toString();
            File propsFile = new File(propertyfile);
            FileInputStream fis = new FileInputStream(propsFile);
            props.load(fis);
            String token = props.getProperty(DEV_TOKEN_ATTR);
            if (token != null && token.compareTo("") != 0) {
                return token;
            }
            _log.error("Token property user.token is missing or empty in the property file " + propertyfile);
            return null;
        }
        catch (IOException e) {
            _log.error("gcube-dev-context.properties file not found under $GCUBE_DEV_HOME dir");
            return null;
        }
    }

    private static String readContextPropertyFile() {
        Properties props = new Properties();
        try {
            StringBuilder sb = new StringBuilder(PortalContext.getGCubeDevHome());
            sb.append(File.separator).append(GCUBE_DEV__CONTEXT_PROPERTY_FILENAME);
            String propertyfile = sb.toString();
            File propsFile = new File(propertyfile);
            FileInputStream fis = new FileInputStream(propsFile);
            props.load(fis);
            String scope = props.getProperty(DEV_SCOPE_ATTR);
            if (scope.startsWith(SCOPE_SEPARATOR)) {
                return scope;
            }
            _log.error("Scope is not valid, does not start with /");
            return null;
        }
        catch (IOException e) {
            _log.error("gcube-dev-context.properties file not found under $GCUBE_DEV_HOME dir");
            return null;
        }
    }

    private static String readGroupNamePropertyFile() {
        Properties props = new Properties();
        try {
            StringBuilder sb = new StringBuilder(PortalContext.getGCubeDevHome());
            sb.append(File.separator).append(GCUBE_DEV__CONTEXT_PROPERTY_FILENAME);
            String propertyfile = sb.toString();
            File propsFile = new File(propertyfile);
            FileInputStream fis = new FileInputStream(propsFile);
            props.load(fis);
            String groupName = props.getProperty(DEV_GROUP_NAME_ATTR);
            if (groupName != null && !groupName.isEmpty()) {
                return groupName;
            }
            _log.error("groupName is not valid, check property development.groupname");
            return null;
        }
        catch (IOException e) {
            _log.error("gcube-dev-context.properties file not found under $GCUBE_DEV_HOME dir");
            return null;
        }
    }

    private static long readGroupIdPropertyFile() {
        block5: {
            Properties props = new Properties();
            try {
                StringBuilder sb = new StringBuilder(PortalContext.getGCubeDevHome());
                sb.append(File.separator).append(GCUBE_DEV__CONTEXT_PROPERTY_FILENAME);
                String propertyfile = sb.toString();
                File propsFile = new File(propertyfile);
                FileInputStream fis = new FileInputStream(propsFile);
                props.load(fis);
                String groupIdNo = props.getProperty(DEV_GROUP_ID_ATTR);
                long groupId = -1L;
                if (groupIdNo != null) {
                    try {
                        groupId = Long.parseLong(groupIdNo);
                        return groupId;
                    }
                    catch (NumberFormatException e) {
                        _log.error("The groupId is not a number -> " + groupIdNo);
                        break block5;
                    }
                }
                _log.error("groupId is not valid, check property development.groupid");
                return -1L;
            }
            catch (IOException e) {
                _log.error("gcube-dev-context.properties file not found under $GCUBE_DEV_HOME dir");
                return -1L;
            }
        }
        return -1L;
    }

    private static String getCatalinaHome() {
        return System.getenv("CATALINA_HOME").endsWith(SCOPE_SEPARATOR) ? System.getenv("CATALINA_HOME") : System.getenv("CATALINA_HOME") + SCOPE_SEPARATOR;
    }

    private static String getGCubeDevHome() {
        return System.getenv("GCUBE_DEV_HOME").endsWith(SCOPE_SEPARATOR) ? System.getenv("GCUBE_DEV_HOME") : System.getenv("GCUBE_DEV_HOME") + SCOPE_SEPARATOR;
    }
}

