package org.gcube.resourcemanagement.resources;

import java.util.Iterator;
import java.util.List;

import org.gcube.com.fasterxml.jackson.databind.node.ObjectNode;
import org.gcube.informationsystem.model.reference.entities.Facet;
import org.gcube.informationsystem.model.reference.entities.Resource;
import org.gcube.informationsystem.serialization.ElementMapper;
import org.gcube.resourcemanagement.model.reference.relations.consistsof.IsIdentifiedBy;
import org.gcube.resourcemanagement.resource.Instance;

import jakarta.ws.rs.WebApplicationException;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
public class GCubeInstance extends Instance {

    @Override
    protected void setIdentifingProperties(Resource r) throws WebApplicationException {
        @SuppressWarnings("unchecked")
        List<IsIdentifiedBy<Resource, Facet>> isIdentifiedByList = r.getConsistsOf(IsIdentifiedBy.class);
        // GCube model imposes that there is one and only one IsIdentifiedBy relation per resource
        IsIdentifiedBy<Resource, Facet> isIdentifiedBy = isIdentifiedByList.get(0);
        Facet f = (Facet) isIdentifiedBy.getTarget();
        ObjectNode node = (ObjectNode) ElementMapper.getObjectMapper().valueToTree(f);
        Iterator<String> fieldNames = node.fieldNames();
        while(fieldNames.hasNext()) {
            String key = fieldNames.next();
            if(!excludedFacetKeys.contains(key)) {
                addProperty(key, node.get(key));    
            }
        }
    }
    
}
