/**
 * 
 */
package org.gcube.portlets.user.warmanagementwidget.server.csv;

import java.io.File;

import org.gcube.portlets.user.warmanagementwidget.client.progress.OperationProgress;
import org.gcube.portlets.user.warmanagementwidget.client.progress.OperationState;

/**
 * The WAR Wizard import session for the server side.
 * @author Federico De Faveri defaveri@isti.cnr.it
 *
 */
public class ImportSession {
	
	protected String id;
	
	protected ImportStatus status;
	protected String failMessage;

	protected File warFile;
	protected String warName;
	
	protected OperationProgress uploadProgress;
	protected OperationProgress warUploadProgress;
	
	public ImportSession(String id) {
		this.id = id;
		this.status = ImportStatus.CREATED;
		uploadProgress= new OperationProgress();
	}

	/**
	 * @return the id
	 */
	public String getId() {
		return id;
	}

	public File getWarFile() {
		return warFile;
	}

	public void setWarFile(File warFile) {
		this.warFile = warFile;
	}

	public String getWarName() {
		return warName;
	}

	public void setWarName(String warName) {
		this.warName = warName;
	}

	public OperationProgress getUploadProgress() {
		return uploadProgress;
	}
	
	public void setUploadFailed(String failMessage, String failureDetails)
	{
		status = ImportStatus.FAILED;
		this.failMessage = failMessage;
		uploadProgress.setFailed(failMessage, failureDetails);
	}
	
	public void setUploadComplete()
	{
		status = ImportStatus.UPLOAD_COMPLETE;
		uploadProgress.setState(OperationState.COMPLETED);
	}
	
	public void setStatus(ImportStatus status)
	{
		this.status = status;
	}

	/**
	 * @return the war upload progress
	 */
	public OperationProgress getWarUploadProgress() {
		return warUploadProgress;
	}

	/**
	 * @param warUploadProgress the war upload progress
	 */
	public void setWarUpload(OperationProgress warUploadProgress) {
		this.warUploadProgress = warUploadProgress;
	}
}
