/**
 * 
 */
package org.gcube.portlets.user.warmanagementwidget.server.accesslog;

import org.gcube.application.framework.accesslogger.library.impl.AccessLogger;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.portlets.user.warmanagementwidget.client.data.WarProfile;
import org.gcube.portlets.user.warmanagementwidget.server.util.Util;

/**
 * @author Federico De Faveri defaveri@isti.cnr.it
 *
 */
public class AccessLogUtil {

	public final static char ATTRIBUTE_SEPARATOR = '|';
	public final static String LABEL_SEPARATOR = " = ";

	public final static String WAR_ID_LABEL = "ID";
	public final static String WAR_NAME_LABEL = "NAME";
	public final static String WAR_CATEGORY_NAME_LABEL = "CATEGORY_NAME";

	public final static String WAR_APPLICATION_NAME_LABEL = "APPLICATION_NAME";
	public final static String WAR_APPLICATION_VERSION_LABEL = "APPLICATION_VERSION";

	protected static void logAction(String user, GCUBEScope scope, WarManagementAccessLogEntryType action, String message)
	{
		AccessLogger accessLogger = AccessLogger.getAccessLogger();
		try {
			accessLogger.logEntry(user, scope.toString(), new WarManagementAccessLogEntry(action, message));
		} catch (Exception e) {
		}
	}

	public static void logWarUpload(String user, GCUBEScope scope, WarProfile warProfile)
	{
		StringBuilder builder = new StringBuilder(WAR_ID_LABEL);
		builder.append(LABEL_SEPARATOR);
		builder.append(warProfile.getApplicationId());
		builder.append(ATTRIBUTE_SEPARATOR);

		builder.append(WAR_NAME_LABEL);
		builder.append(LABEL_SEPARATOR);
		builder.append(warProfile.getWarFileName());
		builder.append(ATTRIBUTE_SEPARATOR);

		builder.append(WAR_CATEGORY_NAME_LABEL);
		builder.append(LABEL_SEPARATOR);
		builder.append(warProfile.getCategoryName());
		builder.append(ATTRIBUTE_SEPARATOR);

		builder.append(WAR_APPLICATION_NAME_LABEL);
		builder.append(LABEL_SEPARATOR);
		builder.append(warProfile.getApplicationName());
		builder.append(ATTRIBUTE_SEPARATOR);

		builder.append(WAR_APPLICATION_VERSION_LABEL);
		builder.append(LABEL_SEPARATOR);
		builder.append(Util.getVersion(warProfile));
		builder.append(LABEL_SEPARATOR);

		
		WarManagementAccessLogEntryType type = (warProfile.getApplicationId() == null)?WarManagementAccessLogEntryType.WAR_UPLOADED: WarManagementAccessLogEntryType.WAR_UPDATED;
		
		logAction(user, scope, type, builder.toString());

	}
	
	public static void logWarRemoved(String user, GCUBEScope scope, String warId)
	{
		StringBuilder builder = new StringBuilder(WAR_ID_LABEL);
		builder.append(LABEL_SEPARATOR);
		builder.append(warId);
		
		logAction(user, scope, WarManagementAccessLogEntryType.WAR_REMOVED, builder.toString());
	}
	
}
