package org.gcube.portlets.user.td.columnwidget.client.batch;

import java.util.ArrayList;
import java.util.List;

import org.gcube.portlets.user.td.columnwidget.client.custom.ActionButtonCell;
import org.gcube.portlets.user.td.columnwidget.client.dimension.ConnectCodelistDialog;
import org.gcube.portlets.user.td.columnwidget.client.dimension.ConnectCodelistListener;
import org.gcube.portlets.user.td.columnwidget.client.dimension.DimensionRowSelectionDialog;
import org.gcube.portlets.user.td.columnwidget.client.dimension.DimensionRowSelectionListener;
import org.gcube.portlets.user.td.columnwidget.client.properties.ShowOccurrencesTypeProperties;
import org.gcube.portlets.user.td.columnwidget.client.resources.ResourceBundle;
import org.gcube.portlets.user.td.columnwidget.client.store.ShowOccurrencesTypeElement;
import org.gcube.portlets.user.td.columnwidget.client.store.ShowOccurrencesTypeStore;
import org.gcube.portlets.user.td.columnwidget.client.utils.UtilsGXT3;
import org.gcube.portlets.user.td.gwtservice.client.rpc.TDGWTServiceAsync;
import org.gcube.portlets.user.td.gwtservice.shared.Constants;
import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTSessionExpiredException;
import org.gcube.portlets.user.td.gwtservice.shared.task.InvocationS;
import org.gcube.portlets.user.td.gwtservice.shared.tr.ColumnData;
import org.gcube.portlets.user.td.gwtservice.shared.tr.ColumnViewData;
import org.gcube.portlets.user.td.gwtservice.shared.tr.ConditionCode;
import org.gcube.portlets.user.td.gwtservice.shared.tr.DimensionRow;
import org.gcube.portlets.user.td.gwtservice.shared.tr.RefColumn;
import org.gcube.portlets.user.td.gwtservice.shared.tr.batch.Occurrences;
import org.gcube.portlets.user.td.gwtservice.shared.tr.batch.OccurrencesForReplaceBatchColumnSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.batch.ReplaceBatchColumnSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.batch.ReplaceEntry;
import org.gcube.portlets.user.td.gwtservice.shared.tr.batch.ShowOccurrencesType;
import org.gcube.portlets.user.td.widgetcommonevent.client.event.SessionExpiredEvent;
import org.gcube.portlets.user.td.widgetcommonevent.client.type.SessionExpiredType;
import org.gcube.portlets.user.td.widgetcommonevent.shared.CellData;
import org.gcube.portlets.user.td.widgetcommonevent.shared.RequestProperties;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.cell.client.AbstractCell;
import com.google.gwt.cell.client.Cell.Context;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.core.client.Scheduler.ScheduledCommand;
import com.google.gwt.dom.client.Style.Unit;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.safecss.shared.SafeStylesBuilder;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HTML;
import com.google.web.bindery.event.shared.EventBus;
import com.sencha.gxt.cell.core.client.ButtonCell.IconAlign;
import com.sencha.gxt.cell.core.client.form.ComboBoxCell.TriggerAction;
import com.sencha.gxt.core.client.IdentityValueProvider;
import com.sencha.gxt.core.client.Style.SelectionMode;
import com.sencha.gxt.core.client.resources.ThemeStyles;
import com.sencha.gxt.core.client.util.Format;
import com.sencha.gxt.core.client.util.Margins;
import com.sencha.gxt.data.client.loader.RpcProxy;
import com.sencha.gxt.data.shared.LabelProvider;
import com.sencha.gxt.data.shared.ListStore;
import com.sencha.gxt.data.shared.event.StoreDataChangeEvent;
import com.sencha.gxt.data.shared.event.StoreDataChangeEvent.StoreDataChangeHandler;
import com.sencha.gxt.data.shared.loader.ListLoadConfig;
import com.sencha.gxt.data.shared.loader.ListLoadResult;
import com.sencha.gxt.data.shared.loader.ListLoadResultBean;
import com.sencha.gxt.data.shared.loader.ListLoader;
import com.sencha.gxt.data.shared.loader.LoadResultListStoreBinding;
import com.sencha.gxt.widget.core.client.FramedPanel;
import com.sencha.gxt.widget.core.client.button.TextButton;
import com.sencha.gxt.widget.core.client.container.BoxLayoutContainer.BoxLayoutData;
import com.sencha.gxt.widget.core.client.container.BoxLayoutContainer.BoxLayoutPack;
import com.sencha.gxt.widget.core.client.container.HBoxLayoutContainer;
import com.sencha.gxt.widget.core.client.container.HBoxLayoutContainer.HBoxLayoutAlign;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer.VerticalLayoutData;
import com.sencha.gxt.widget.core.client.event.SelectEvent;
import com.sencha.gxt.widget.core.client.event.SelectEvent.SelectHandler;
import com.sencha.gxt.widget.core.client.form.ComboBox;
import com.sencha.gxt.widget.core.client.form.TextField;
import com.sencha.gxt.widget.core.client.grid.CheckBoxSelectionModel;
import com.sencha.gxt.widget.core.client.grid.ColumnConfig;
import com.sencha.gxt.widget.core.client.grid.ColumnModel;
import com.sencha.gxt.widget.core.client.grid.Grid;
import com.sencha.gxt.widget.core.client.grid.RowNumberer;
import com.sencha.gxt.widget.core.client.info.Info;
import com.sencha.gxt.widget.core.client.toolbar.LabelToolItem;
import com.sencha.gxt.widget.core.client.toolbar.ToolBar;

/**
 * 
 * @author "Giancarlo Panichi" <a
 *         href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a>
 * 
 */
public class ReplaceBatchPanel extends FramedPanel implements
		SingleValueReplaceListener, DimensionRowSelectionListener,
		ConnectCodelistListener {
	protected String WIDTH = "560px";
	protected String HEIGHT = "520px";
	protected EventBus eventBus;
	protected TextField label = null;
	protected TRId trId;
	protected String columnName;

	protected RefColumn refColumn;
	protected String columnId;
	protected ConditionCode conditionCode; // For Curation
	protected String validationColumnColumnId; // For Curation
	protected RequestProperties requestProperties;
	protected boolean curation;
	protected ColumnData column;
	protected boolean hasValidationColumns;
	protected ShowOccurrencesType showOccurencesType;
	protected ColumnData connection;

	protected ReplaceBatchDialog parent;

	private ReplaceEntry currentReplaceEntry;
	private int currentRowIndex;

	protected static final String DON_T_REPLACE = "Don't replace";

	private TextButton btnSave;
	private TextButton btnClose;

	private ToolBar toolBarHead;

	private ComboBox<ShowOccurrencesTypeElement> comboShowOccurrencesType = null;
	private ListStore<ShowOccurrencesTypeElement> storeShowOccurrencesType;

	private TextButton btnConnect;
	private TextButton btnDisconnect;
	private TextField connectionField;

	protected ListLoader<ListLoadConfig, ListLoadResult<ReplaceEntry>> loader;
	protected Grid<ReplaceEntry> grid;
	protected ListStore<ReplaceEntry> store;
	protected HTML info;

	private boolean simpleReplace;

	public ReplaceBatchPanel(ReplaceBatchDialog parent, TRId trId,
			RequestProperties requestProperties, EventBus eventBus) {
		this.curation = true;
		this.parent = parent;
		this.trId = trId;
		this.requestProperties = requestProperties;
		this.eventBus = eventBus;

		InvocationS invocationS = (InvocationS) requestProperties.getMap().get(
				Constants.REQUEST_PROPERTIES_INVOCATIONS);

		columnId = invocationS.getColumnId();

		refColumn = invocationS.getRefColumn();

		conditionCode = (ConditionCode) requestProperties.getMap().get(
				Constants.REQUEST_PROPERTIES_CONDITIONCODE);
		validationColumnColumnId = (String) requestProperties.getMap().get(
				Constants.REQUEST_PROPERTIES_VALIDATIONCOLUMNCOLUMNID);

		connection = null;
		hasValidationColumns = false;
		Log.debug("Create BatchReplacePanel(): [" + trId.toString()
				+ " , RequestProperties:" + requestProperties + "]");
		init();
		retrieveConnection();

	}

	public ReplaceBatchPanel(ReplaceBatchDialog parent, TRId trId,
			String columnName, EventBus eventBus) {
		this.curation = false;
		this.parent = parent;
		this.trId = trId;
		this.columnName = columnName;
		this.eventBus = eventBus;
		this.conditionCode = null;
		this.validationColumnColumnId = null;

		connection = null;
		hasValidationColumns = false;
		Log.debug("Create BatchReplacePanel(): [" + trId.toString()
				+ " , columnName:" + columnName + "]");
		init();
		retrieveColumn();

	}

	protected void init() {
		setWidth(WIDTH);
		setHeight(HEIGHT);
		setHeaderVisible(false);
		setBodyBorder(false);
	}

	protected void create() {
		showOccurencesType = ShowOccurrencesType.ONLYERRORS;

		toolBarHead = new ToolBar();
		toolBarHead.add(new LabelToolItem("Show: "));

		// Create Combo Show
		ShowOccurrencesTypeProperties propsShowOccurrencesType = GWT
				.create(ShowOccurrencesTypeProperties.class);
		storeShowOccurrencesType = new ListStore<ShowOccurrencesTypeElement>(
				propsShowOccurrencesType.id());
		
		
		comboShowOccurrencesType = new ComboBox<ShowOccurrencesTypeElement>(
				storeShowOccurrencesType, propsShowOccurrencesType.label());
		Log.trace("ComboMeasureType created");

		addHandlersForShowOccurrencesType(propsShowOccurrencesType.label());

		comboShowOccurrencesType.setEmptyText("Select a show type...");
		comboShowOccurrencesType.setWidth(100);
		comboShowOccurrencesType.setTypeAhead(true);
		comboShowOccurrencesType.setEditable(false);
		comboShowOccurrencesType.setTriggerAction(TriggerAction.ALL);
		comboShowOccurrencesType
				.setValue(ShowOccurrencesTypeStore.onlyErrorsElement);

		toolBarHead.add(comboShowOccurrencesType);

		if (!column.isViewColumn()) {
			// Connect Codelist
			btnConnect = new TextButton();
			btnConnect.setIcon(ResourceBundle.INSTANCE.codelistLink24());
			btnConnect.setIconAlign(IconAlign.TOP);
			btnConnect.setTitle("Connect");
			btnConnect.addSelectHandler(new SelectHandler() {

				public void onSelect(SelectEvent event) {
					Log.debug("Pressed Connect");
					btnConnect.disable();
					connectCodelist();

				}

			});

			toolBarHead.add(btnConnect);

			// Disconnect Codelist
			btnDisconnect = new TextButton();
			btnDisconnect
					.setIcon(ResourceBundle.INSTANCE.codelistLinkBreak24());
			btnDisconnect.setIconAlign(IconAlign.TOP);
			btnDisconnect.setTitle("Disconnect");
			btnDisconnect.addSelectHandler(new SelectHandler() {

				public void onSelect(SelectEvent event) {
					Log.debug("Pressed Disconnect");
					btnDisconnect.disable();
					disconnectCodelist();

				}

			});
			toolBarHead.add(btnDisconnect);

			connectionField = new TextField();
			toolBarHead.add(connectionField);

		} else {
			connectionField = new TextField();
			toolBarHead.add(connectionField);
		}

		// Create Grid
		IdentityValueProvider<ReplaceEntry> identity = new IdentityValueProvider<ReplaceEntry>();
		CheckBoxSelectionModel<ReplaceEntry> sm = new CheckBoxSelectionModel<ReplaceEntry>(
				identity);

		RowNumberer<ReplaceEntry> number = new RowNumberer<ReplaceEntry>(
				identity);
		// number.setFixed(false);
		// number.setResizable(false);
		number.setWidth(50);
		number.setColumnClassSuffix("");
		number.setHeader("N.");
		SafeStylesBuilder styleBuilder = new SafeStylesBuilder();
		styleBuilder.width(50, Unit.PX);
		number.setColumnStyle(styleBuilder.toSafeStyles());

		ReplaceEntryProperties props = GWT.create(ReplaceEntryProperties.class);

		ColumnConfig<ReplaceEntry, String> valueCol = new ColumnConfig<ReplaceEntry, String>(
				props.value(), 130, "Values");
		ColumnConfig<ReplaceEntry, Integer> numberCol = new ColumnConfig<ReplaceEntry, Integer>(
				props.number(), 100, "Occurrences");
		ColumnConfig<ReplaceEntry, String> replacementValueCol = new ColumnConfig<ReplaceEntry, String>(
				props.replacementValue(), 130, "Replacement");

		replacementValueCol.setCell(new AbstractCell<String>() {

			@Override
			public void render(Context context, String value, SafeHtmlBuilder sb) {
				if (value == null) {
					String style = "style='color: black;font-weight:bold'";
					sb.appendHtmlConstant("<span " + style + ">"
							+ DON_T_REPLACE + "</span>");
				} else {
					String style = "style='color: green;font-weight:normal'";
					sb.appendHtmlConstant("<span " + style + ">" + value
							+ "</span>");
				}

			}
		});

		ColumnConfig<ReplaceEntry, String> changeColumn = new ColumnConfig<ReplaceEntry, String>(
				props.value(), 24);

		ActionButtonCell button = new ActionButtonCell();
		button.setIcon(ResourceBundle.INSTANCE.magnifier());
		button.setTitle("Change");
		button.addSelectHandler(new SelectHandler() {

			@Override
			public void onSelect(SelectEvent event) {
				Log.debug("Button Change Pressed");
				Context c = event.getContext();
				int rowIndex = c.getIndex();
				startReplaceEntry(rowIndex);
			}
		});

		changeColumn.setCell(button);

		List<ColumnConfig<ReplaceEntry, ?>> l = new ArrayList<ColumnConfig<ReplaceEntry, ?>>();
		l.add(number);
		l.add(valueCol);
		l.add(numberCol);
		l.add(replacementValueCol);
		l.add(changeColumn);
		ColumnModel<ReplaceEntry> cm = new ColumnModel<ReplaceEntry>(l);

		store = new ListStore<ReplaceEntry>(props.id());

		store.addStoreDataChangeHandler(new StoreDataChangeHandler<ReplaceEntry>() {

			@Override
			public void onDataChange(StoreDataChangeEvent<ReplaceEntry> event) {
				updateInfo();

			}

		});

		RpcProxy<ListLoadConfig, ListLoadResult<ReplaceEntry>> proxy = new RpcProxy<ListLoadConfig, ListLoadResult<ReplaceEntry>>() {

			public void load(ListLoadConfig loadConfig,
					final AsyncCallback<ListLoadResult<ReplaceEntry>> callback) {
				loadData(loadConfig, callback);
			}
		};
		loader = new ListLoader<ListLoadConfig, ListLoadResult<ReplaceEntry>>(
				proxy);

		loader.setRemoteSort(false);
		loader.addLoadHandler(new LoadResultListStoreBinding<ListLoadConfig, ReplaceEntry, ListLoadResult<ReplaceEntry>>(
				store) {
		});

		grid = new Grid<ReplaceEntry>(store, cm) {
			@Override
			protected void onAfterFirstAttach() {
				super.onAfterFirstAttach();
				Scheduler.get().scheduleDeferred(new ScheduledCommand() {

					public void execute() {
						loader.load();
					}
				});
			}
		};

		sm.setSelectionMode(SelectionMode.MULTI);
		grid.setLoader(loader);
		grid.setSelectionModel(sm);
		number.initPlugin(grid);
		grid.setHeight("376px");
		grid.getView().setStripeRows(true);
		grid.getView().setColumnLines(true);
		grid.getView().setAutoFill(true);
		grid.setBorders(false);
		grid.setLoadMask(true);
		grid.setColumnReordering(true);
		grid.setColumnResize(true);
		grid.getView().setAutoExpandColumn(valueCol);

		info = new HTML("No info");

		ToolBar toolBar = new ToolBar();
		toolBar.add(info);
		toolBar.addStyleName(ThemeStyles.getStyle().borderTop());
		toolBar.getElement().getStyle().setProperty("borderBottom", "none");

		btnSave = new TextButton("Save");
		btnSave.setIcon(ResourceBundle.INSTANCE.save());
		btnSave.setIconAlign(IconAlign.RIGHT);
		btnSave.setTitle("Save");
		btnSave.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				Log.debug("Pressed Save");
				btnSave.disable();
				save();

			}
		});

		btnClose = new TextButton("Close");
		btnClose.setIcon(ResourceBundle.INSTANCE.close());
		btnClose.setIconAlign(IconAlign.RIGHT);
		btnClose.setTitle("Close");
		btnClose.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				Log.debug("Pressed Close");
				close();
			}
		});

		HBoxLayoutContainer flowButton = new HBoxLayoutContainer();
		flowButton.setHBoxLayoutAlign(HBoxLayoutAlign.MIDDLE);
		flowButton.setPack(BoxLayoutPack.CENTER);

		flowButton.add(btnSave, new BoxLayoutData(new Margins(2, 4, 2, 4)));
		flowButton.add(btnClose, new BoxLayoutData(new Margins(2, 4, 2, 4)));

		VerticalLayoutContainer v = new VerticalLayoutContainer();
		v.add(toolBarHead, new VerticalLayoutData(1, -1, new Margins(0)));
		v.add(grid, new VerticalLayoutData(-1, -1, new Margins(0)));
		v.add(toolBar, new VerticalLayoutData(1, 25, new Margins(0)));
		v.add(flowButton, new VerticalLayoutData(-1, 36,
				new Margins(5, 2, 5, 2)));
		add(v);

		if (curation) {
			storeShowOccurrencesType.addAll(ShowOccurrencesTypeStore.getShowOccurrencesType());
			if (connection != null) {
				Log.debug("Selected connection: " + connection);
				connectionField.setValue(connection.getLabel());
				connectionField.setVisible(true);
				btnDisconnect.setVisible(true);
				btnConnect.setVisible(false);
				btnConnect.enable();

			} else {

			}
			toolBarHead.forceLayout();
		} else {
			if (column.isViewColumn()) {
				Log.debug("Is View Column");
				storeShowOccurrencesType
						.add(ShowOccurrencesTypeStore.onlyErrorsElement);
				ColumnViewData cViewData = column.getColumnViewData();
				RefColumn refCol = new RefColumn(String.valueOf(cViewData
						.getTargetTableId()),
						cViewData.getTargetTableColumnId());
				retrieveConnectionForViewColumn(refCol);
			} else {
				storeShowOccurrencesType.addAll(ShowOccurrencesTypeStore.getShowOccurrencesType());
				Log.debug("Not Is View Column");
				connectionField.setVisible(false);
				btnDisconnect.setVisible(false);
				toolBarHead.forceLayout();
			}

		}

	}

	protected void retrieveColumn() {
		TDGWTServiceAsync.INSTANCE.getColumn(trId, columnName,
				new AsyncCallback<ColumnData>() {

					public void onFailure(Throwable caught) {
						if (caught instanceof TDGWTSessionExpiredException) {
							eventBus.fireEvent(new SessionExpiredEvent(
									SessionExpiredType.EXPIREDONSERVER));
						} else {
							Log.error("load column failure:"
									+ caught.getLocalizedMessage());
							UtilsGXT3.alert("Error retrieving column",
									"Error retrieving column");
						}
					}

					public void onSuccess(ColumnData result) {
						Log.debug("Column: " + result);
						column = result;
						retriveValidationColumn();
					}

				});
	}

	protected void retrieveColumnByColumnId() {
		Log.debug("Retrieve Column by ColumnId: columnId:" + columnId
				+ ", trId:" + trId);
		TDGWTServiceAsync.INSTANCE.getColumn(columnId, trId,
				new AsyncCallback<ColumnData>() {

					public void onFailure(Throwable caught) {
						if (caught instanceof TDGWTSessionExpiredException) {
							eventBus.fireEvent(new SessionExpiredEvent(
									SessionExpiredType.EXPIREDONSERVER));
						} else {
							Log.error("load column failure:"
									+ caught.getLocalizedMessage());
							UtilsGXT3.alert("Error retrieving column",
									"Error retrieving column");
						}
					}

					public void onSuccess(ColumnData result) {
						Log.debug("Column: " + result);
						column = result;
						columnName = result.getName();
						retriveValidationColumn();
					}

				});
	}

	protected void retriveValidationColumn() {
		TDGWTServiceAsync.INSTANCE.getValidationColumns(trId, columnName,
				new AsyncCallback<ArrayList<ColumnData>>() {

					public void onFailure(Throwable caught) {
						if (caught instanceof TDGWTSessionExpiredException) {
							eventBus.fireEvent(new SessionExpiredEvent(
									SessionExpiredType.EXPIREDONSERVER));
						} else {
							Log.error("load column failure:"
									+ caught.getLocalizedMessage());
							UtilsGXT3.alert("Error retrieving column",
									"Error retrieving column");
						}
					}

					public void onSuccess(ArrayList<ColumnData> result) {
						Log.debug("Validation Columns: " + result.size());
						ArrayList<String> validationColumnReferences = new ArrayList<String>();
						if (result.size() > 0) {
							hasValidationColumns = true;
							for (ColumnData columnData : result) {
								validationColumnReferences.add(columnData
										.getColumnId());
							}
							column.setValidationColumnReferences(validationColumnReferences);
						} else {
							hasValidationColumns = false;
						}
						create();
					}

				});
	}

	protected void addHandlersForShowOccurrencesType(
			final LabelProvider<ShowOccurrencesTypeElement> labelProvider) {
		comboShowOccurrencesType
				.addSelectionHandler(new SelectionHandler<ShowOccurrencesTypeElement>() {
					public void onSelection(
							SelectionEvent<ShowOccurrencesTypeElement> event) {
						Info.display(
								"Show Type Selected",
								"You selected "
										+ (event.getSelectedItem() == null ? "nothing"
												: labelProvider.getLabel(event
														.getSelectedItem())
														+ "!"));
						Log.debug("ComboShowOccurrencesType selected: "
								+ event.getSelectedItem());
						ShowOccurrencesTypeElement showType = event
								.getSelectedItem();
						updateShowType(showType);
					}

				});
	}

	/**
	 * 
	 * @param showType
	 */
	protected void updateShowType(ShowOccurrencesTypeElement showType) {
		showOccurencesType = showType.getType();
		loader.load();
	}

	/**
	 * 
	 * @param loadConfig
	 * @param callback
	 */
	protected void loadData(ListLoadConfig loadConfig,
			final AsyncCallback<ListLoadResult<ReplaceEntry>> callback) {

		OccurrencesForReplaceBatchColumnSession occurrencesSession = new OccurrencesForReplaceBatchColumnSession(
				column, showOccurencesType, hasValidationColumns,
				conditionCode, validationColumnColumnId);

		TDGWTServiceAsync.INSTANCE.getOccurrencesForBatchReplace(
				occurrencesSession,
				new AsyncCallback<ArrayList<Occurrences>>() {

					public void onFailure(Throwable caught) {
						if (caught instanceof TDGWTSessionExpiredException) {
							eventBus.fireEvent(new SessionExpiredEvent(
									SessionExpiredType.EXPIREDONSERVER));
						} else {
							Log.error("load columns failure:"
									+ caught.getLocalizedMessage());
							UtilsGXT3.alert("Error retrieving columns",
									"Error retrieving columns");
						}
						callback.onFailure(caught);
					}

					public void onSuccess(ArrayList<Occurrences> result) {
						Log.trace("loaded " + result.size() + " Occurrences");
						ListLoadResultBean<ReplaceEntry> loadedResult = new ListLoadResultBean<ReplaceEntry>(
								getRecord(result));
						Log.debug("created " + loadedResult.toString());
						try {
							callback.onSuccess(loadedResult);
						} catch (Throwable e) {
							Log.error("Too many different occurrences");
							UtilsGXT3.alert("Attention",
									"Too many different occurrences");
						}
					}

				});

	}

	protected void updateInfo() {
		Log.trace("updating the info bar");
		int total = store.size();
		int totalErrors = 0;
		int assignedErrors = 0;
		int assigned = 0;
		for (ReplaceEntry record : store.getAll()) {
			int errors = record.getNumber();
			totalErrors += errors;
			if (record.getReplacementValue() != null
					&& record.getReplacementValue().compareTo(DON_T_REPLACE) != 0) {
				assigned++;
				assignedErrors += errors;
			}
		}

		String text = Format.substitute(
				"Assigned {0} ({1} occurrences) of {2} ({3} occurrences)",
				String.valueOf(assigned), String.valueOf(assignedErrors),
				String.valueOf(total), String.valueOf(totalErrors));
		info.setText(text);
		Log.debug(text);
	}

	protected ArrayList<ReplaceEntry> getRecord(ArrayList<Occurrences> entries) {
		ArrayList<ReplaceEntry> records = new ArrayList<ReplaceEntry>();
		try {
			for (Occurrences entry : entries)
				records.add(getRecord(entry));

		} catch (Throwable e) {
			Log.debug("Error creating records:" + e.getLocalizedMessage());
			e.printStackTrace();
		}
		return records;

	}

	//
	protected ReplaceEntry getRecord(Occurrences entry) {
		ReplaceEntry data = null;
		if (conditionCode == null) {
			if (column.isViewColumn()) {
				data = new ReplaceEntry(entry.getValue(), entry.getRowId(),
						entry.getNumber(), null, null);
			} else {
				data = new ReplaceEntry(entry.getValue(), entry.getNumber(),
						null, null);
			}
		} else {
			switch (conditionCode) {
			case AllowedColumnType:
				break;
			case AmbiguousValueOnExternalReference:
				data = new ReplaceEntry(entry.getValue(), entry.getRowId(),
						entry.getNumber(), null, null);
				break;
			case CastValidation:
				break;
			case CodeNamePresence:
				break;
			case DuplicateTupleValidation:
				break;
			case DuplicateValueInColumn:
				break;
			case GenericTupleValidity:
				break;
			case GenericValidity:
				break;
			case MaxOneCodenameForDataLocale:
				break;
			case MissingValueOnExternalReference:
				if (column.isViewColumn()) {
					data = new ReplaceEntry(entry.getValue(), entry.getRowId(),
							entry.getNumber(), null, null);
				} else {
					data = new ReplaceEntry(entry.getValue(),
							entry.getNumber(), null, null);
				}
				break;
			case MustContainAtLeastOneDimension:
				break;
			case MustContainAtLeastOneMeasure:
				break;
			case MustHaveDataLocaleMetadataAndAtLeastOneLabel:
				break;
			case OnlyOneCodeColumn:
				break;
			case OnlyOneCodenameColumn:
				break;
			case ValidPeriodFormat:
				break;
			default:
				if (column.isViewColumn()) {
					data = new ReplaceEntry(entry.getValue(), entry.getRowId(),
							entry.getNumber(), null, null);
				} else {
					data = new ReplaceEntry(entry.getValue(),
							entry.getNumber(), null, null);
				}
				break;

			}
		}

		return data;
	}

	protected void startReplaceEntry(int rowIndex) {
		currentRowIndex = rowIndex;
		currentReplaceEntry = store.get(rowIndex);
		Log.debug(currentReplaceEntry.toString() + " was clicked.[rowIndex="
				+ currentRowIndex + " ]");
		if (!curation) {
			Log.debug("Not in curation from validation");
			if (column.isViewColumn()) {
				callDimensionRowSelectionDialog();
			} else {
				callSingleValueReplaceDialog();

			}
		} else {
			Log.debug("In curation from validation");
			if (connection != null) {
				callDimensionRowSelectionDialog();
			} else {

			}
		}
	}

	protected void save() {
		ArrayList<ReplaceEntry> effectiveReplaceList = new ArrayList<ReplaceEntry>();
		for (ReplaceEntry re : store.getAll()) {
			if (re.getReplacementValue() != null) {
				effectiveReplaceList.add(re);
			}

		}

		if (effectiveReplaceList.size() == 0) {
			UtilsGXT3
					.alert("Attention", "Select at least one value to replace");
			btnSave.enable();
		} else {
			startReplaceBatch(effectiveReplaceList);
		}
	}

	protected void startReplaceBatch(
			ArrayList<ReplaceEntry> effectiveReplaceList) {
		ReplaceBatchColumnSession replaceBatchColumnSession = new ReplaceBatchColumnSession(
				trId, column, effectiveReplaceList, column.isViewColumn(),
				connection);
		parent.startBatchReplace(replaceBatchColumnSession);
	}

	protected void close() {
		parent.close();
	}

	protected void callSingleValueReplaceDialog() {
		Log.debug("callSingleValueReplaceDialog");
		simpleReplace = true;
		if (connection == null) {
			SingleValueReplaceDialog dialogSingleValueReplace = new SingleValueReplaceDialog(
					currentReplaceEntry.getValue(),
					currentReplaceEntry.getReplacementValue(), column, eventBus);
			dialogSingleValueReplace.addListener(this);
			dialogSingleValueReplace.show();
		} else {
			Log.debug("callDimensionRowSelectionDialog");
			CellData cellData = new CellData(currentReplaceEntry.getValue(),
					connection.getName(), connection.getColumnId(),
					connection.getLabel(), currentReplaceEntry.getRowId(), 0, 0);
			DimensionRowSelectionDialog dialogDimensionRowSelection = new DimensionRowSelectionDialog(
					connection, cellData, true, eventBus);
			dialogDimensionRowSelection.addListener(this);
			dialogDimensionRowSelection.show();
		}

	}

	protected void callDimensionRowSelectionDialog() {
		simpleReplace = false;
		Log.debug("callDimensionRowSelectionDialog");
		CellData cellData = null;
		ColumnData col = null;
		boolean workOnTable = false;
		if (curation) {
			if (connection != null) {
				cellData = new CellData(currentReplaceEntry.getValue(),
						connection.getName(), connection.getColumnId(),
						connection.getLabel(), currentReplaceEntry.getRowId(),
						0, 0);
				col = connection;
				workOnTable = true;

			} else {
				Log.error("No connection retrieved");
			}
			Log.debug("Col: " + col + ", CellData:" + cellData);
			DimensionRowSelectionDialog dialogDimensionRowSelection;

			switch (conditionCode) {
			case AllowedColumnType:
				break;
			case AmbiguousValueOnExternalReference:
				dialogDimensionRowSelection = new DimensionRowSelectionDialog(
						col, cellData, workOnTable, true, true, true, false,
						eventBus);
				dialogDimensionRowSelection.addListener(this);
				dialogDimensionRowSelection.show();
				break;
			case CastValidation:
				break;
			case CodeNamePresence:
				break;
			case DuplicateTupleValidation:
				break;
			case DuplicateValueInColumn:
				break;
			case GenericTupleValidity:
				break;
			case GenericValidity:
				break;
			case MaxOneCodenameForDataLocale:
				break;
			case MissingValueOnExternalReference:
				dialogDimensionRowSelection = new DimensionRowSelectionDialog(
						col, cellData, workOnTable, eventBus);
				dialogDimensionRowSelection.addListener(this);
				dialogDimensionRowSelection.show();
				break;
			case MustContainAtLeastOneDimension:
				break;
			case MustContainAtLeastOneMeasure:
				break;
			case MustHaveDataLocaleMetadataAndAtLeastOneLabel:
				break;
			case OnlyOneCodeColumn:
				break;
			case OnlyOneCodenameColumn:
				break;
			case ValidPeriodFormat:
				break;
			default:
				dialogDimensionRowSelection = new DimensionRowSelectionDialog(
						col, cellData, workOnTable, eventBus);
				dialogDimensionRowSelection.addListener(this);
				dialogDimensionRowSelection.show();
				break;

			}

		} else {
			cellData = new CellData(currentReplaceEntry.getValue(),
					column.getName(), column.getColumnId(), column.getLabel(),
					currentReplaceEntry.getRowId(), 0, 0);
			col = column;
			workOnTable = false;

			Log.debug("Col: " + col + ", CellData:" + cellData);
			DimensionRowSelectionDialog dialogDimensionRowSelection = new DimensionRowSelectionDialog(
					col, cellData, workOnTable, eventBus);
			dialogDimensionRowSelection.addListener(this);
			dialogDimensionRowSelection.show();
		}
	}

	@Override
	public void selectedDimensionRow(DimensionRow dimensionRow) {
		Log.debug("Change Value: " + dimensionRow);
		if (simpleReplace) {
			currentReplaceEntry.setReplacementValue(dimensionRow.getValue());
			store.update(currentReplaceEntry);
			updateInfo();
		} else {
			currentReplaceEntry.setReplacementValue(dimensionRow.getValue());
			currentReplaceEntry.setReplacementDimensionRow(dimensionRow);
			store.update(currentReplaceEntry);
			updateInfo();
		}
	}

	@Override
	public void abortedDimensionRowSelection() {
		Log.debug("Change Value Aborted");

	}

	@Override
	public void failedDimensionRowSelection(String reason, String detail) {
		Log.error("Change Value Failed:" + reason + " " + detail);

	}

	@Override
	public void selectedSingleValueReplace(String replaceValue) {
		Log.debug("Change Value: " + replaceValue);
		currentReplaceEntry.setReplacementValue(replaceValue);
		store.update(currentReplaceEntry);
		updateInfo();
	}

	@Override
	public void abortedSingleValueReplace() {
		Log.debug("Change Value Aborted");

	}

	@Override
	public void failedSingleValueReplace(String reason, String detail) {
		Log.error("Change Value Failed:" + reason + " " + detail);

	}

	protected void connectCodelist() {
		Log.debug("callConnectCodelistDialog");
		ConnectCodelistDialog connectCodelistDialog = new ConnectCodelistDialog(
				eventBus);
		connectCodelistDialog.addListener(this);
		connectCodelistDialog.show();

	}

	protected void disconnectCodelist() {
		Log.debug("Disconnect codelist");
		this.connection = null;
		connectionField.setValue("");
		connectionField.setVisible(false);
		btnDisconnect.setVisible(false);
		btnConnect.setVisible(true);
		btnConnect.enable();
		toolBarHead.forceLayout();
	}

	@Override
	public void selectedConnectCodelist(ColumnData connection) {
		Log.debug("Selected connection: " + connection);
		this.connection = connection;
		connectionField.setValue(connection.getLabel());
		connectionField.setVisible(true);
		btnDisconnect.setVisible(true);
		btnConnect.setVisible(false);
		btnConnect.enable();
		toolBarHead.forceLayout();
	}

	@Override
	public void abortedConnectCodelist() {
		Log.debug("Connection Aborted");
		btnConnect.enable();
	}

	@Override
	public void failedConnectCodelist(String reason, String detail) {
		Log.debug("Connection Failed: " + reason + " " + detail);
		UtilsGXT3.alert("Error on connect", reason);
		btnConnect.enable();

	}

	protected void retrieveConnection() {
		Log.debug("Retrieve Connection RefColumn:" + refColumn);
		TDGWTServiceAsync.INSTANCE.getConnection(refColumn,
				new AsyncCallback<ColumnData>() {

					public void onFailure(Throwable caught) {
						if (caught instanceof TDGWTSessionExpiredException) {
							eventBus.fireEvent(new SessionExpiredEvent(
									SessionExpiredType.EXPIREDONSERVER));
						} else {
							Log.error("load column failure:"
									+ caught.getLocalizedMessage());
							UtilsGXT3.alert("Error retrieving connection",
									"Error retrieving connection column");
						}
					}

					public void onSuccess(ColumnData result) {
						Log.debug("Column: " + result);
						connection = result;
						retrieveColumnByColumnId();
					}

				});

	}

	protected void retrieveConnectionForViewColumn(RefColumn refCol) {
		Log.debug("Retrieve Connection For View Column: " + refCol);
		TDGWTServiceAsync.INSTANCE.getConnection(refCol,
				new AsyncCallback<ColumnData>() {

					public void onFailure(Throwable caught) {
						if (caught instanceof TDGWTSessionExpiredException) {
							eventBus.fireEvent(new SessionExpiredEvent(
									SessionExpiredType.EXPIREDONSERVER));
						} else {
							Log.error("load column failure:"
									+ caught.getLocalizedMessage());
							UtilsGXT3.alert("Error retrieving connection",
									"Error retrieving connection column");
						}
					}

					public void onSuccess(ColumnData result) {
						Log.debug("Column: " + result);
						connection = result;
						setConnectionForViewColumn();
					}

				});

	}

	protected void setConnectionForViewColumn() {
		Log.debug("Selected connection: " + connection);
		connectionField.setValue(connection.getLabel());
		connectionField.setVisible(true);
		toolBarHead.forceLayout();
	}

}
