/**
 * 
 */
package org.gcube.portlets.user.occurrencemanagement.server.util;

import java.util.HashMap;

import javax.servlet.http.HttpSession;

import org.apache.log4j.Logger;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.portlets.user.csvimportwizard.server.csv.CSVTargetRegistry;
import org.gcube.portlets.user.occurrencemanagement.server.csv.CsvImportServer;
import org.gcube.portlets.user.occurrencemanagement.server.service.ReconciliationService;


/**
 * 
 * @author Francesco Mangiacrapa francesco.mangiacrapa@isti.cnr.it
 *
 */
public class SessionUtil {

	public static final String USERNAME_ATTRIBUTE = "username";
	public static final String RECONCILIATION_SERVICE = "occurrences_reconciliation_service";
	private static final String CSV_SERVICE = "csv_service";
	
	public static final String TEST_SCOPE = "/gcube/devsec/devVRE";
	public static final String TEST_USER = "francesco.mangiacrapa";


	public static Logger logger = Logger.getLogger(SessionUtil.class);

	public static HashMap<String, ReconciliationService> mapReconcilationService = new HashMap<String, ReconciliationService>();

	public static ASLSession getAslSession(HttpSession httpSession)
	{
		String sessionID = httpSession.getId();
		String user = (String) httpSession.getAttribute(USERNAME_ATTRIBUTE);

		if (user == null) {

			logger.error("WORKSPACE PORTLET STARTING IN TEST MODE - NO USER FOUND");

			//for test only
			httpSession.setAttribute(USERNAME_ATTRIBUTE, TEST_USER);
			ASLSession session = SessionManager.getInstance().getASLSession(sessionID, TEST_USER);
			session.setScope(TEST_SCOPE);
			//session.setScope("/d4science.research-infrastructures.eu/Ecosystem/TryIt");

			return session;
		}

		return SessionManager.getInstance().getASLSession(sessionID, user);
	}

//	public static Workspace getWorkspace(final HttpSession httpSession) throws InternalErrorException, HomeNotFoundException, WorkspaceFolderNotFoundException
//	{
//		final ASLSession session = getAslSession(httpSession);
//
//		Workspace workspace = HomeLibrary.getUserWorkspace(session);
//	
//		return workspace;
//
//	}
//	
	public static ReconciliationService getService(ASLSession session) throws Exception
	{
		ReconciliationService service = (ReconciliationService) session.getAttribute(RECONCILIATION_SERVICE);
		
//		ReconciliationService service = mapReconcilationService.get(session.getUsername());
		
		if (service==null) {
			logger.trace("Service not found, creating it");
//			GCUBEScope scope = session.getScope();
			service = new ReconciliationService(session.getScope(), session);
			
//			mapReconcilationService.put(session.getUsername(), service);
			
			session.setAttribute(RECONCILIATION_SERVICE, service);
		}
		
//		System.out.println("return ReconciliationService... " +service);
		
		return service;
	}
	
	
	public static CsvImportServer getCsvImportServer(ASLSession session) throws Exception
	{
		CsvImportServer csvImportService = (CsvImportServer) session.getAttribute(CSV_SERVICE);
		
		if (csvImportService==null) {
			logger.trace("CsvImportServer not found, creating it");
			csvImportService = new CsvImportServer();
			CSVTargetRegistry.getInstance().add(csvImportService);

			session.setAttribute(CSV_SERVICE, csvImportService);
		}

		return csvImportService;
	}

	public static Logger getLogger()
	{
		return logger;
	}

}
