package org.gcube.portlets.user.occurrencemanagement.client.view.panel;



import org.gcube.portlets.user.occurrencemanagement.client.HeaderOccurrence;

import com.extjs.gxt.ui.client.Style.LayoutRegion;
import com.extjs.gxt.ui.client.Style.Scroll;
import com.extjs.gxt.ui.client.util.Margins;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.layout.BorderLayout;
import com.extjs.gxt.ui.client.widget.layout.BorderLayoutData;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;




/**
 * @author Francesco Mangiacrapa francesco.mangiacrapa@isti.cnr.it
 *
 */
public class GxtBorderLayoutMainPanel extends ContentPanel {
	private ContentPanel north = new ContentPanel();
	private ContentPanel center = new ContentPanel();
	private GxtCardLayoutMainPanel gxtCardLayoutMainPanel;


	public GxtBorderLayoutMainPanel(GxtCardLayoutMainPanel gxtCardLayoutMainPanel) {
		this.gxtCardLayoutMainPanel = gxtCardLayoutMainPanel;
		this.initLayout();
		this.createLayouts();
	}

	private void initLayout(){
			
		north.setId("NorthMainPanel");
		north.setLayout(new FitLayout());
		north.setHeaderVisible(false);
		center.setId("CenterMainPanel");
		center.setLayout(new FitLayout());
	    center.setHeaderVisible(false);
		center.setScrollMode(Scroll.AUTOX);
		center.setBorders(false);
	}
		
	public void createLayouts(){
		
		final BorderLayout borderLayout = new BorderLayout();
		setLayout(borderLayout);
		setStyleAttribute("padding", "10px");
		setHeaderVisible(false);

	    BorderLayoutData northData = new BorderLayoutData(LayoutRegion.NORTH, 50, 50, 50);  
	    northData.setCollapsible(false);  

	    BorderLayoutData centerData = new BorderLayoutData(LayoutRegion.CENTER);  
	    centerData.setMargins(new Margins(0));

	    north.add(new HeaderOccurrence());
	   
	    center.add(this.gxtCardLayoutMainPanel);

	    add(north, northData);  
	    add(center, centerData);  
	}

	public void updateHeight(int rootHeight) {
		setHeight(rootHeight);
		gxtCardLayoutMainPanel.updateHeight(rootHeight-74);
	}

	public void updateWidth(int rootWidth) {
		setWidth(rootWidth);
		gxtCardLayoutMainPanel.updateWidth(rootWidth);

	}
}