package org.gcube.portlets.user.occurrencemanagement.client.timers;

import org.gcube.portlets.user.occurrencemanagement.client.OccurrenceApplicationController;
import org.gcube.portlets.user.occurrencemanagement.shared.ElaborationType;

import com.google.gwt.user.client.Timer;

public class PollingOccurrences extends Timer{

	private boolean onlyNotCompleted;
	private boolean notifyChange;
	private ElaborationType elaborationType;
	private int delaySchedule;
	private int delayRepeating;
	 
	@Override
	public void run() {
		OccurrenceApplicationController.excecuteGetListOccurrences(elaborationType, onlyNotCompleted, notifyChange);
		
	}
	
	public PollingOccurrences(ElaborationType elaborationType, boolean onlyNotCompleted, boolean notifyChange){
		this.onlyNotCompleted = onlyNotCompleted;
		this.notifyChange = notifyChange;
		this.elaborationType = elaborationType;
	}

	public boolean isOnlyNotCompleted() {
		return onlyNotCompleted;
	}

	public void setOnlyNotCompleted(boolean onlyNotCompleted) {
		this.onlyNotCompleted = onlyNotCompleted;
	}

	public boolean isNotifyChange() {
		return notifyChange;
	}

	public void setNotifyChange(boolean notifyChange) {
		this.notifyChange = notifyChange;
	}
	
	public void stopPolling(){
		cancel();
	}
	
	public void startPolling(){
		run();
	}
	
	public void scheduleRepeatingPolling(int milliseconds){
		this.delayRepeating = milliseconds;
		scheduleRepeating(delayRepeating);
	}
	
	public void schedulePolling(int milliseconds){
		this.delaySchedule = milliseconds;
		schedule(delaySchedule);
	}

	public ElaborationType getElaborationType() {
		return elaborationType;
	}

	public void setElaborationType(ElaborationType elaborationType) {
		this.elaborationType = elaborationType;
	}

	public int getDelaySchedule() {
		return delaySchedule;
	}

	public void setDelaySchedule(int delaySchedule) {
		this.delaySchedule = delaySchedule;
	}

	public int getDelayRepeating() {
		return delayRepeating;
	}

	public void setDelayRepeating(int delayRepeating) {
		this.delayRepeating = delayRepeating;
	}

}
