package org.gcube.portlets.user.occurrencemanagement.client.statistical.form;


import org.gcube.portlets.user.occurrencemanagement.shared.statisticalparameter.ColumnListParameter;
import org.gcube.portlets.user.occurrencemanagement.shared.statisticalparameter.Parameter;
import org.gcube.portlets.user.occurrencemanagement.shared.statisticalparameter.TableItem;

import com.extjs.gxt.ui.client.data.BeanModel;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.widget.CheckBoxListView;
import com.extjs.gxt.ui.client.widget.Html;
import com.extjs.gxt.ui.client.widget.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;


/**
 * @author ceras
 *
 */
public class ColumnListField extends AbstractField {
	
	private CheckBoxListView<BeanModel> view;
	private VerticalPanel vp = new VerticalPanel();
	String value = null;
//	TableItem selectedColumn = null; 
	private String tableId;
	private ColumnListParameter columnListParameter;

	/**
	 * @param parameter
	 */
	public ColumnListField(Parameter parameter) {
		super(parameter);
		
		this.columnListParameter = (ColumnListParameter)parameter;

		view = new CheckBoxListView<BeanModel>();
		ListStore<BeanModel> store = new ListStore<BeanModel>();
		view.setStore(store);
	    view.setDisplayProperty("name");
	    view.setSize(150, 100);
	    view.mask();
	    
		showNoSelectionField();		
	}

	/**
	 * 
	 */
	private void showNoSelectionField() {
		vp.removeAll();
		vp.add(view);
		vp.add(new Html("<div class='workflow-parameters-description'>Select table from parameter " + 
				this.columnListParameter.getReferredTabularParameterName()+"</div>"));
		vp.layout();
	}

	/**
	 * 
	 */
	private void showFieldWithSelection(TableItem tableItem) {
		vp.removeAll();
		vp.add(view);
		vp.add(new Html("<div class='workflow-parameters-description'>Columns of Table "+tableItem.getName()+"</div>"));
		vp.layout();
	}

	/* (non-Javadoc)
	 * @see org.gcube.portlets.user.statisticalmanager.client.form.AbstractField#getValue()
	 */
	@Override
	public String getValue() {
		String separator = columnListParameter.getSeparator();
		String value = "";
		boolean first = true;
		
		for (BeanModel beanModel: view.getChecked()) {
			String columnName = ((ColumnItem)beanModel).getName();
			value += (first ? "" : separator) + columnName;
			first = false;
		}
		return value;
	}

	/* (non-Javadoc)
	 * @see org.gcube.portlets.user.statisticalmanager.client.form.AbstractField#getComponent()
	 */
	@Override
	public Widget getWidget() {
		return vp;
	}


	/* (non-Javadoc)
	 * @see org.gcube.portlets.user.statisticalmanager.client.form.AbstractField#fireEvent(java.lang.Object)
	 */
	@Override
	public void fireEvent(Object message) {
		if (message==null) {
			view.getStore().removeAll();
			view.mask();
			showNoSelectionField();
		} else {
			TableItem tableItem = (TableItem)message;
			view.getStore().removeAll();
			for (String columnName: tableItem.getColumnNames())
				view.getStore().add(new ColumnItem(columnName));
			
			view.unmask();
			showFieldWithSelection(tableItem);
		}
	}
	
	/* (non-Javadoc)
	 * @see org.gcube.portlets.user.statisticalmanager.client.form.AbstractField#isValid()
	 */
	@Override
	public boolean isValid() {
		return (view.getChecked().size()>0);
	}

	public class ColumnItem extends BeanModel {

		public ColumnItem(String name) {
			set("name", name);
		}
		
		public String getName() {
			return get("name");
		}

	}
}
