/**
 * 
 */
package org.gcube.portlets.user.occurrencemanagement.client.statistical;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.gcube.portlets.user.occurrencemanagement.client.OccurrenceApplicationController;
import org.gcube.portlets.user.occurrencemanagement.client.event.NewComputationEvent;
import org.gcube.portlets.user.occurrencemanagement.client.resources.Resources;
import org.gcube.portlets.user.occurrencemanagement.client.rpc.OccurrenceManagementServiceAsync;
import org.gcube.portlets.user.occurrencemanagement.client.statistical.form.AbstractField;
import org.gcube.portlets.user.occurrencemanagement.client.statistical.form.OperatorFieldWidget;
import org.gcube.portlets.user.occurrencemanagement.client.statistical.form.TabularField;
import org.gcube.portlets.user.occurrencemanagement.shared.JobOccurrencesModel;
import org.gcube.portlets.user.occurrencemanagement.shared.statisticalparameter.ColumnListParameter;
import org.gcube.portlets.user.occurrencemanagement.shared.statisticalparameter.ColumnParameter;
import org.gcube.portlets.user.occurrencemanagement.shared.statisticalparameter.Operator;
import org.gcube.portlets.user.occurrencemanagement.shared.statisticalparameter.Parameter;

import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Html;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.MessageBox;
import com.extjs.gxt.ui.client.widget.Text;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.form.FormButtonBinding;
import com.extjs.gxt.ui.client.widget.form.FormPanel;

/**
 * @author ceras
 *
 */
public class WorkflowOperatorPanel extends LayoutContainer {

	/**
	 * @author ceras
	 *
	 */
	public interface WorkflowOperatorPanelHandler {
		public void startComputation();
	}

	private static final String START_BUTTON_TOOLTIP = "Start Computation";

	private Operator operator;
	private OccurrenceManagementServiceAsync service;
	private FormPanel parametersPanel = new FormPanel();
	private Map<String, OperatorFieldWidget> fieldWidgetsMap = new HashMap<String, OperatorFieldWidget>();
	private Map<Parameter, String> parameterValues = new HashMap<Parameter, String>();
	private WorkflowOperatorPanelHandler handler=null;

	private List<JobOccurrencesModel> listTable;


	public WorkflowOperatorPanel(OccurrenceManagementServiceAsync service, Operator operator, WorkflowOperatorPanelHandler handler, List<JobOccurrencesModel> listTable) {
		this(service, operator, listTable);
		this.setHandler(handler);
		this.listTable = listTable;
	}
	/**
	 * 
	 */
	public WorkflowOperatorPanel(OccurrenceManagementServiceAsync service, Operator operator, List<JobOccurrencesModel> listTable) {
		super();
		this.listTable = listTable;
		this.service = service;
		this.operator = operator;		
		//lc.setLayout(new FitLayout());
		this.setHeight(50);
		this.setAutoHeight(true);
//		this.addStyleName("workflow");

//		Image img = new Image("images/operators/"+(operator.hasImage() ? operator.getId() : "DEFAULT_IMAGE")+".png");
//		img.addStyleName("workflow-icon");
//		this.add(img);

		Html title = new Html(operator.getName());
		title.addStyleName("workflow-title");
		this.add(title);

		String descr = operator.getDescription();
		descr = (descr==null || descr.contentEquals("")) ? "no-description" : operator.getDescription();
		Html description = new Html(descr);
		description.addStyleName("workflow-description");
		this.add(description);
		
		parametersPanel = new FormPanel() {
			@Override
			public boolean isValid(boolean preventMark) {
				boolean flag = super.isValid(preventMark);

				if (flag) {
					for (Map.Entry<String, OperatorFieldWidget> entry : fieldWidgetsMap.entrySet()) {
						OperatorFieldWidget fieldWidget = entry.getValue();
						flag = flag && fieldWidget.isValid();
					}
				}
				return flag;
			}
		};
		
		Text pm = new Text("Parameters");
		
		pm.addStyleName("parameters-fra");
		parametersPanel.setHeaderVisible(false);
		parametersPanel.setBodyBorder(true);
		parametersPanel.add(pm);
		parametersPanel.setCollapsible(false);
		parametersPanel.expand();
//		parametersPanel.addStyleName("workflow");
//		parametersPanel.setHeading("Parameters");
		parametersPanel.setStyleAttribute("margin", "20px");
		
		this.add(parametersPanel);

		loadOperatorParameters();
	}

	/**
	 * @param parametersPanel
	 */
	private void loadOperatorParameters() {
		
		showForm();
		
		
	}

	/**
	 * 
	 */
	protected void showForm() {
		// field widgets creation
		for (Parameter p : operator.getOperatorParameters()) {
			OperatorFieldWidget fieldWidget = new OperatorFieldWidget(p, service);
//			fields.add(fieldWidget);
			fieldWidgetsMap.put(p.getName(), fieldWidget);
			parametersPanel.add(fieldWidget);
		}
		
		for (Parameter p: operator.getOperatorParameters()) {
			if (p.isColumn() || p.isColumnList()) {
				// search for the table parameter which it depends
				String tabParamName = (p.isColumn()
						? ((ColumnParameter)p).getReferredTabularParameterName()
						: ((ColumnListParameter)p).getReferredTabularParameterName());
				
				try {
					// get the column field and the tabular field referred
					TabularField tabularField = (TabularField)fieldWidgetsMap.get(tabParamName).getField();
					AbstractField field = fieldWidgetsMap.get(p.getName()).getField();
					tabularField.addChangeListener(field);				
				} catch (Exception e) {
					e.printStackTrace();
					MessageBox.alert("Error", "Column parameter \""+p.getName()+" refers to a tabular parameter that doesn't exists ("+tabParamName+")\"", null);
				}
			}
			
			else if(p.isTabular()){
				System.out.println("is TABULAR YES");
				TabularField tabularField = (TabularField)fieldWidgetsMap.get(p.getName()).getField();
				tabularField.setListTable(listTable);
			}
		}
		
		parametersPanel.expand();
		
		Button submit = new Button("Start Computation");
		submit.setToolTip(START_BUTTON_TOOLTIP);
		submit.setIcon(Resources.startComputation());
		submit.setStyleAttribute("margin-left","20px");
		submit.setStyleAttribute("margin-bottom","20px");
		submit.addSelectionListener(new SelectionListener<ButtonEvent>(){
			@Override
			public void componentSelected(ButtonEvent ce) {
				updateOperatorParametersValues();
				OccurrenceApplicationController.getEventBus().fireEvent(new NewComputationEvent(operator));
				
			}
		});
		parametersPanel.add(submit);
		
		FormButtonBinding binding = new FormButtonBinding(parametersPanel);		
		binding.addButton(submit);
		
		parametersPanel.layout();
	}
	
	public void updateOperatorParametersValues() {
		for (Map.Entry<String, OperatorFieldWidget> entry : fieldWidgetsMap.entrySet()) {
			OperatorFieldWidget fieldWidget = entry.getValue();
			fieldWidget.updateOperatorParameterValue();
		}
	}
	
	/**
	 * @return the operator
	 */
	public Operator getOperator() {
		return operator;
	}
	
	public void setHandler(WorkflowOperatorPanelHandler handler) {
		this.handler = handler;
	}
}
