/**
 * 
 */
package org.gcube.portlets.user.occurrencemanagement.client.dialog;


import org.gcube.portlets.user.occurrencemanagement.client.ConstantsPortletOccurrence;
import org.gcube.portlets.user.occurrencemanagement.client.OccurrenceApplicationController;
import org.gcube.portlets.user.occurrencemanagement.client.event.ImportOccurrencesEvent;
import org.gcube.portlets.user.occurrencemanagement.client.resources.Resources;
import org.gcube.portlets.widgets.lighttree.client.ItemType;
import org.gcube.portlets.widgets.lighttree.client.event.PopupEvent;
import org.gcube.portlets.widgets.lighttree.client.event.PopupHandler;
import org.gcube.portlets.widgets.lighttree.client.load.WorkspaceLightTreeLoadPopup;

import com.extjs.gxt.ui.client.Style.ButtonScale;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Window;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.form.FormPanel;
import com.extjs.gxt.ui.client.widget.form.TextArea;
import com.extjs.gxt.ui.client.widget.form.TextField;


/**
 * 
 * @author Francesco Mangiacrapa francesco.mangiacrapa@isti.cnr.it
 *
 */
public class ImportOccurrencesFileWindow extends Window {

	protected TextField<String> checkListNameField;
	protected String workspaceItemId;
	protected Button importButton;
	protected TextArea textArea;

	public ImportOccurrencesFileWindow()
	{
		setPixelSize(400, 270);
		//setBlinkModal(true);
		setHeading("Import occurrences list from workspace");
		getHeader().setIcon(Resources.getIconUplad());
		
		setResizable(false);

		final FormPanel panel = new FormPanel();
		panel.setStyleAttribute("margin-top", "5px");
		panel.setWidth(385);
		panel.setHeaderVisible(false);
		panel.setBodyStyle("background: none; padding: 5px");

		
		checkListNameField = new TextField<String>();
		checkListNameField.setFieldLabel("Name");
		checkListNameField.setAllowBlank(false);
		checkListNameField.setEmptyText("Enter the occurrences list name...");
		checkListNameField.setMaxLength(255);
		
		textArea = new TextArea();
		textArea.setStyleAttribute("margin-top", "20px");
		textArea.setFieldLabel("Description");
		
		
		final TextField<String> workspaceItem = new TextField<String>();
		workspaceItem.setReadOnly(true);
		workspaceItem.setFieldLabel("Path");
		workspaceItem.setEmptyText("Press browse...");
		workspaceItem.setToolTip("Press browse to load occurrences list from workspace");
		workspaceItem.setAllowBlank(false);
		
		Button browseButton = new Button("Browse");
		browseButton.addSelectionListener(new SelectionListener<ButtonEvent>() {
			

			@Override
			public void componentSelected(ButtonEvent ce) {
				WorkspaceLightTreeLoadPopup loadPopup = new WorkspaceLightTreeLoadPopup("Select a occurrences list", false, true);
				loadPopup.setShowableTypes(ItemType.EXTERNAL_FILE);
				loadPopup.setSelectableTypes(ItemType.EXTERNAL_FILE);
				loadPopup.setAllowedMimeTypes(ConstantsPortletOccurrence.LISTCSWMIMETYPES);

				
				loadPopup.addPopupHandler(new PopupHandler() {
					
					@Override
					public void onPopup(PopupEvent event) {
						if (!event.isCanceled()) {
							workspaceItem.setValue(event.getSelectedItem().getName());
							workspaceItemId = event.getSelectedItem().getId();
						}
					}
				});
				
				loadPopup.center();
				loadPopup.show();
			}
		});
		
		importButton = new Button("Import");
		importButton.setIcon(Resources.getIconUplad());
		importButton.setScale(ButtonScale.MEDIUM);
		importButton.addSelectionListener(new SelectionListener<ButtonEvent>() {

			@Override
			public void componentSelected(ButtonEvent ce) {
				
				if(panel.isValid())
					doImport();				
			}
		});
	
		setFocusWidget(getButtonBar().getWidget(0));
		
		panel.add(checkListNameField);
		panel.add(workspaceItem);
		panel.add(browseButton);
		panel.add(textArea);
		add(panel);
		
		importButton.setStyleAttribute("margin-left", "160px");
		
		add(importButton);
	}
	
	protected boolean checkValid()
	{
		return checkListNameField.isValid(true) && workspaceItemId!=null;
	}
	
	protected void doImport()
	{
		OccurrenceApplicationController.getEventBus().fireEvent(new ImportOccurrencesEvent(workspaceItemId, cleanValue(checkListNameField.getValue()), cleanValue(textArea.getValue())));
		hide();	
	}
	
	private String cleanValue(String value){
		if(value==null)
			return "";
		return value;
	}

}
