package org.gcube.portlets.user.occurrencemanagement.client.dialog;

import org.gcube.portlets.user.csvimportwizard.client.ImportWizard;
import org.gcube.portlets.user.csvimportwizard.client.general.WizardListener;
import org.gcube.portlets.user.csvimportwizard.client.source.local.LocalSource;
import org.gcube.portlets.user.csvimportwizard.ws.client.WorkspaceSource;
import org.gcube.portlets.user.occurrencemanagement.client.OccurrenceApplicationController;
import org.gcube.portlets.user.occurrencemanagement.client.event.ReLoadListOccurrencesEvent;
import org.gcube.portlets.user.occurrencemanagement.shared.ElaborationType;


public class CsvImport {
	
	public CsvImport(){
			
		ImportWizard importWizard = new ImportWizard("OccurrenceCSVTarget", LocalSource.INSTANCE, WorkspaceSource.INSTANCE);
		importWizard.show();
		
		importWizard.addListener(new WizardListener() {
			 
			@Override
			public void failed(Throwable throwable, String reason, String details) {
				System.out.println("FAILED reason: "+reason+" details: "+details+" throwable: "+throwable);
			}
	 
			@Override
			public void completed() {
				OccurrenceApplicationController.getEventBus().fireEvent(new ReLoadListOccurrencesEvent(ElaborationType.IMPORTED));
			}
	 
			@Override
			public void aborted() {
				System.out.println("ABORT");
			}
		});
		
	}
	

}
