package org.gcube.portlets.user.occurrencemanagement.client;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.gcube.portlets.user.occurrencemanagement.client.dialog.DialogCreateNewComputation;
import org.gcube.portlets.user.occurrencemanagement.client.event.AddComputationPanelEvent;
import org.gcube.portlets.user.occurrencemanagement.client.event.AddComputationPanelEventHandler;
import org.gcube.portlets.user.occurrencemanagement.client.event.DeleteResourceEvent;
import org.gcube.portlets.user.occurrencemanagement.client.event.DeleteResourceEventHandler;
import org.gcube.portlets.user.occurrencemanagement.client.event.DetailsComputationSelectedEvent;
import org.gcube.portlets.user.occurrencemanagement.client.event.DetailsComputationSelectedEventHandler;
import org.gcube.portlets.user.occurrencemanagement.client.event.GridElementSelectedEvent;
import org.gcube.portlets.user.occurrencemanagement.client.event.GridElementSelectedEventHandler;
import org.gcube.portlets.user.occurrencemanagement.client.event.HeaderMenuItemSelectEvent;
import org.gcube.portlets.user.occurrencemanagement.client.event.HeaderMenuItemSelectEventHandler;
import org.gcube.portlets.user.occurrencemanagement.client.event.LoadListOccurrencesEvent;
import org.gcube.portlets.user.occurrencemanagement.client.event.LoadListOccurrencesEventHandler;
import org.gcube.portlets.user.occurrencemanagement.client.event.LoadListOccurrencesFromStoreEvent;
import org.gcube.portlets.user.occurrencemanagement.client.event.LoadListOccurrencesFromStoreEventHandler;
import org.gcube.portlets.user.occurrencemanagement.client.event.NewComputationEvent;
import org.gcube.portlets.user.occurrencemanagement.client.event.NewComputationEventHandler;
import org.gcube.portlets.user.occurrencemanagement.client.event.OpenTableEvent;
import org.gcube.portlets.user.occurrencemanagement.client.event.OpenTableEventHandler;
import org.gcube.portlets.user.occurrencemanagement.client.event.ReLoadListIOccurrencesEventHandler;
import org.gcube.portlets.user.occurrencemanagement.client.event.ReLoadListOccurrencesEvent;
import org.gcube.portlets.user.occurrencemanagement.client.event.SaveResourceEvent;
import org.gcube.portlets.user.occurrencemanagement.client.event.SaveResourceEventHandler;
import org.gcube.portlets.user.occurrencemanagement.client.rpc.OccurrenceManagementService;
import org.gcube.portlets.user.occurrencemanagement.client.rpc.OccurrenceManagementServiceAsync;
import org.gcube.portlets.user.occurrencemanagement.client.statistical.WorkflowOperatorPanel;
import org.gcube.portlets.user.occurrencemanagement.client.timers.PollingOccurrences;
import org.gcube.portlets.user.occurrencemanagement.client.view.panel.GxtBorderLayoutMainPanel;
import org.gcube.portlets.user.occurrencemanagement.shared.ElaborationType;
import org.gcube.portlets.user.occurrencemanagement.shared.JobOccurrencesModel;
import org.gcube.portlets.user.occurrencemanagement.shared.ResourceType;
import org.gcube.portlets.user.occurrencemanagement.shared.TableInfo;
import org.gcube.portlets.user.occurrencemanagement.shared.statisticalparameter.Operator;
import org.gcube.portlets.widgets.lighttree.client.ItemType;
import org.gcube.portlets.widgets.lighttree.client.event.DataLoadEvent;
import org.gcube.portlets.widgets.lighttree.client.event.DataLoadHandler;
import org.gcube.portlets.widgets.lighttree.client.event.PopupEvent;
import org.gcube.portlets.widgets.lighttree.client.event.PopupHandler;
import org.gcube.portlets.widgets.lighttree.client.save.WorkspaceLightTreeSavePopup;

import com.extjs.gxt.ui.client.data.BaseModelData;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.event.BaseEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.widget.Dialog;
import com.extjs.gxt.ui.client.widget.Info;
import com.extjs.gxt.ui.client.widget.MessageBox;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.core.client.Scheduler.ScheduledCommand;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HasWidgets;

/**
 * 
 * @author Francesco Mangiacrapa francesco.mangiacrapa@isti.cnr.it
 *
 */
public class OccurrenceApplicationController{
	private final static HandlerManager eventBus = new HandlerManager(null);
	private OccurrenceManagementMainPanel mainPanel;
	
	private static PollingOccurrences timerOccurrencesImported;
	private static PollingOccurrences timerResultsExecution;
	
	protected static int loadedCounter = 0;
	protected static int loadingCounter = 0;
	protected static int resultCounter = 0;
	
	/**
	 * Create a remote service proxy to talk to the server-side Greeting service.
	 */
	public final static OccurrenceManagementServiceAsync occurrenceManagementService = GWT.create(OccurrenceManagementService.class);
	protected static final int DELAY = 10000;

	public OccurrenceApplicationController() {
		bind();
	}

	public static HandlerManager getEventBus() {
		return eventBus;
	}

	private void bind() {
		// History.addValueChangeHandler(this);
		
		
		eventBus.addHandler(DeleteResourceEvent.TYPE, new DeleteResourceEventHandler() {
			
			@Override
			public void onDeleteResource(DeleteResourceEvent deleteResourceEvent) {
			
				final ElaborationType elab = deleteResourceEvent.getElaborationType();
				final String occurrenceId = deleteResourceEvent.getOcccurrenceId();
				
				if(deleteResourceEvent.getResourceId()!=null)
					occurrenceManagementService.deleteResourceById(deleteResourceEvent.getResourceId(), new AsyncCallback<Void>() {

						@Override
						public void onFailure(Throwable caught) {
							Info.display("Error deleting the resource", "An error occurred deleting the resource, retry.");
							GWT.log("Error deleting the resource, "+"An error occurred deleting the resource, retry "+caught.getMessage());
							
						}

						@Override
						public void onSuccess(Void result) {
							Info.display("Info","The resource was deleted");
							
							if(elab.getLabel().compareTo(ElaborationType.COMPUTATION.getLabel())==0){
								mainPanel.getCenterComputationPanelMng().deleteItemById(occurrenceId);
								mainPanel.getExplorerDataPanelMng().getOccurrencesLoadedPanel().refresh(); //reload data
//								doLoadListImportedOccurrences(ElaborationType.IMPORTED); //reload data
							}
							else if(elab.getLabel().compareTo(ElaborationType.IMPORTED.getLabel())==0)
								mainPanel.getExplorerDataPanelMng().deleteItemById(occurrenceId);
						}
					});
				
			}
		});

		eventBus.addHandler(GridElementSelectedEvent.TYPE, new GridElementSelectedEventHandler() {

			@Override
			public void onGridElementSelected(GridElementSelectedEvent event) {

				doElementGridSelected(true, event.getSource());


			}
		});
		
		
		eventBus.addHandler(SaveResourceEvent.TYPE, new SaveResourceEventHandler() {
			
			@Override
			public void onSaveResource(SaveResourceEvent saveResourceEvent) {
				
				String fileName = saveResourceEvent.getResourceName();
				final String resourceId = saveResourceEvent.getResourceId();
				final ElaborationType elabType = saveResourceEvent.getElaborationType();
				
				WorkspaceLightTreeSavePopup popup = new WorkspaceLightTreeSavePopup("Select where to save the Occurrence points", true, fileName);

				popup.setSelectableTypes(ItemType.FOLDER, ItemType.ROOT);

				popup.center();

				popup.addPopupHandler(new PopupHandler() {

					public void onPopup(PopupEvent event) {
						if (!event.isCanceled()){
							org.gcube.portlets.widgets.lighttree.client.Item destinationFolder = event.getSelectedItem();
							final String name = event.getName();
							
							
							Info.display("Saving in progress", "...");	
							
							occurrenceManagementService.saveSelectedOccurrencePoints(resourceId, elabType, destinationFolder.getId(), name, new AsyncCallback<Boolean>() {

								@Override
								public void onFailure(Throwable caught) {
									Info.display("Error saving the file", "An error occurred saving the file, retry.");
									GWT.log("Error saving the file,"+"An error occurred saving the file, retry "+caught.getMessage());
									
								}

								@Override
								public void onSuccess(Boolean bool) {
									
									if(bool)
										Info.display("File saved", "The "+name+" file has been saved in the workspace.");		
										
								}
				
							});
							
						}
					}

				});
				popup.addDataLoadHandler(new DataLoadHandler() {

					@Override
					public void onDataLoad(DataLoadEvent event) {
						if (event.isFailed())GWT.log("Workspace loading failure", event.getCaught());
					}
				});
				popup.show();	
				
			
				
			}
		});
		
		
		eventBus.addHandler(DetailsComputationSelectedEvent.TYPE, new DetailsComputationSelectedEventHandler() {
			
			@Override
			public void onSelectedComputation(DetailsComputationSelectedEvent detailsComputationSelectedEvent) {
				
				mainPanel.getDetailsOperationManager().displaDetaylsByModel(detailsComputationSelectedEvent.getOccurrencesModel());	
			}
		});
		
		
		eventBus.addHandler(NewComputationEvent.TYPE, new NewComputationEventHandler() {
			
			@Override
			public void onNewComputation(final NewComputationEvent newComputationEvent) {
				
				
				final DialogCreateNewComputation dialog = new DialogCreateNewComputation("Insert computation data");
				
				
				dialog.getButtonById(Dialog.OK).addListener(Events.Select, new Listener<BaseEvent>() {

					@Override
					public void handleEvent(BaseEvent be) {
						
						if(dialog.isValidForm()){
							
							startNewComputation(newComputationEvent.getOperator(), dialog.getName(), dialog.getDescription());
							
						}
						
					}
				});
			}
		});
		
		
		eventBus.addHandler(HeaderMenuItemSelectEvent.TYPE, new HeaderMenuItemSelectEventHandler() {
			
			@Override
			public void onHeaderMenuSelected(HeaderMenuItemSelectEvent event) {
				mainPanel.getGxtCardLayoutMainPanel().setActivePanel(event.getHeaderOccurrenceMenuItem());
				
			}
		});
		
		
		eventBus.addHandler(LoadListOccurrencesEvent.TYPE, new LoadListOccurrencesEventHandler() {
			
			@Override
			public void onLoadListOccurrences(LoadListOccurrencesEvent loadDataSourceEvent) {
				doLoadOccurrences(loadDataSourceEvent.getLoadType(), loadDataSourceEvent.getListData());
				
			}
			
		});
		
		
//		eventBus.addHandler(ImportOccurrencesEvent.TYPE, new ImportOccurrencesEventHandler() {
//			
//			@Override
//			public void onImportOccurrences(ImportOccurrencesEvent importOccurrencesEvent) {
//				
//				Info.display("Import started", "Import of occurences checklist "+importOccurrencesEvent.getListOccurrencesName()+" started");
//				
//				occurrencesToStatisticalService.importOccurrences(importOccurrencesEvent.getWorkspaceItemId(), importOccurrencesEvent.getListOccurrencesName(), importOccurrencesEvent.getDescription(), new AsyncCallback<Void>() {
//
//					@Override
//					public void onFailure(Throwable caught) {
//						Info.display("Error on import", "An error occurred on import occurrences, retry.");
//						Log.error("Error on import", "An error occurred on import occurrences, retry." +caught.getMessage());
//						
//					}
//
//					@Override
//					public void onSuccess(Void result) {
//						
////							excecuteGetListOccurrences(ElaborationType.OCCURRENCESIMPORTING, false, true);
//							excecuteGetListOccurrences(ElaborationType.OCCURRENCESIMPORTED, false, true);
//					}
//				});
//				
//			}
//		});
		
		
		eventBus.addHandler(OpenTableEvent.TYPE, new OpenTableEventHandler() {
			
			@Override
			public void onOpenTable(OpenTableEvent openTableEvent) {
				doOpenTable(openTableEvent.getTableId(), openTableEvent.getListOccurrencesName());
				
			}

		});
		
		eventBus.addHandler(LoadListOccurrencesFromStoreEvent.TYPE, new LoadListOccurrencesFromStoreEventHandler() {
			
			@Override
			public void onLoadListOccurrencesFromStore(LoadListOccurrencesFromStoreEvent loadListOccurrencesFromStoreEvent) {
				
				//TODO ???
				mainPanel.getExplorerDataPanelMng().getOccurrencesLoadedPanel().getOccurrencesLoaded();
				
			}
		});
		
		
		eventBus.addHandler(ReLoadListOccurrencesEvent.TYPE, new ReLoadListIOccurrencesEventHandler() {
			
			@Override
			public void onLoadListImportedOccurrences(ReLoadListOccurrencesEvent loadListImportedOccurrencesEvent) {
				
				ElaborationType loadType = loadListImportedOccurrencesEvent.getLoadType();
				
				doLoadListImportedOccurrences(loadType);
			}
			
		});
		
		
		eventBus.addHandler(AddComputationPanelEvent.TYPE, new AddComputationPanelEventHandler() {

			@Override
			public void onAddComputationPanel(AddComputationPanelEvent addComputationPanelEvent) {
				
				List<BaseModelData> listTable = mainPanel.getExplorerDataPanelMng().getOccurrencesLoadedPanel().getOccurrencesLoadedByResourceType(ResourceType.TABULAR);
				
				if(listTable!=null){
					
					List<JobOccurrencesModel> listJobTable = new ArrayList<JobOccurrencesModel>();
					
					for (BaseModelData jobModel : listTable) {
						
						
						
						String id = jobModel.get(JobOccurrencesModel.JOBINDENTIFIER);
						String name = jobModel.get(JobOccurrencesModel.JOBNAME);
						Date start = (Date) jobModel.get(JobOccurrencesModel.STARTTIME);
						Date end = (Date) jobModel.get(JobOccurrencesModel.ENDTIME);
						String description = jobModel.get(JobOccurrencesModel.DESCRIPTION);
						
						listJobTable.add(new JobOccurrencesModel(id, name, description, start, end));
						
//						System.out.println(" jobOccurrencesModel " + jobModel);
					}

					WorkflowOperatorPanel ws = new WorkflowOperatorPanel(occurrenceManagementService, addComputationPanelEvent.getOperator(), listJobTable);
				
					mainPanel.getCenterOperationPanelMng().addPanel(ws);
				}
				
			}
			
		});

	}
	
	private void doLoadListImportedOccurrences(ElaborationType loadType) {
		
		if(loadType.getLabel().compareTo(ElaborationType.IMPORTED.getLabel())==0){
			
			mainPanel.getExplorerDataPanelMng().getOccurrencesLoadedPanel().mask(ConstantsPortletOccurrence.LOADING, ConstantsPortletOccurrence.LOADINGSTYLE);
			excecuteGetListOccurrences(ElaborationType.IMPORTED, false, false);
		}
			
		else if(loadType.getLabel().compareTo(ElaborationType.COMPUTATION.getLabel())==0){
			
			mainPanel.getCenterComputationPanelMng().getGridComputation().mask(ConstantsPortletOccurrence.LOADING, ConstantsPortletOccurrence.LOADINGSTYLE);
			excecuteGetListOccurrences(ElaborationType.COMPUTATION, false, false);
			
//			mainPanel.getGxtAccordionPanel().getResultLoadPanel().mask(ConstantsPortletOccurrence.LOADING, ConstantsPortletOccurrence.LOADINGSTYLE);
//			excecuteGetListOccurrences(ElaborationType.RESULTELABORATION, false, false);
		}
		
	}
	
	private void startNewComputation(final Operator operator, String computationName, String computationDescription) {
		
		occurrenceManagementService.startComputation(operator, computationName, computationDescription, new AsyncCallback<String>() {
			@Override
			public void onSuccess(String id) {
				if (id==null)
					MessageBox.alert("ERROR", "Failed to start computation "+operator.getName()+", the computation id is null", null);
//				else
//					statusPanel.computationStarted(id);
				
				Info.display("Info", "A new computation was submitted!");
				
				OccurrenceApplicationController.getEventBus().fireEvent(new ReLoadListOccurrencesEvent(ElaborationType.COMPUTATION));
			}

			@Override
			public void onFailure(Throwable caught) {
				MessageBox.alert("ERROR", "Failed to start computation "+operator.getName()+" (2)<br/>Cause:"+caught.getCause()+"<br/>Message:"+caught.getMessage(), null);
			}
		});
		
	}

	private void doOpenTable(String tableId, String listName) {
		
		this.mainPanel.getCenterDataPanelMng().openTableInView(new TableInfo(tableId,null,null), listName);
	}
	
	private void doLoadOccurrences(ElaborationType loadType, List<JobOccurrencesModel> listData) {
		
		if(listData!=null){
			
			if(loadType.getLabel().compareTo(ElaborationType.IMPORTED.getLabel())==0){
				
				this.mainPanel.getExplorerDataPanelMng().getOccurrencesLoadedPanel().getJobManager().addListJob(listData);
				this.mainPanel.getExplorerDataPanelMng().getOccurrencesLoadedPanel().unmask();
				this.mainPanel.getExplorerDataPanelMng().getOccurrencesLoadedPanel().layout();
			}
				
			else if(loadType.getLabel().compareTo(ElaborationType.COMPUTATION.getLabel())==0){
				
				this.mainPanel.getCenterComputationPanelMng().getGridComputation().getJobManager().addListJob(listData);
				this.mainPanel.getCenterComputationPanelMng().getGridComputation().unmask();
				this.mainPanel.getCenterComputationPanelMng().getGridComputation().layout();
				
//				this.mainPanel.getGxtAccordionPanel().getResultLoadPanel().getJobManager().addListJob(listData);
//				this.mainPanel.getGxtAccordionPanel().getResultLoadPanel().unmask();
//				this.mainPanel.getGxtAccordionPanel().getResultLoadPanel().layout();
			}
	
//			else if(loadType.getLabel().compareTo(ElaborationType.OCCURRENCESIMPORTING.getLabel())==0){
//				
////				this.mainPanel.getGxtAccordionPanel().getOccurrencesLoadingPanel().getJobManager().addListJob(listData);
////				this.mainPanel.getGxtAccordionPanel().getOccurrencesLoadingPanel().unmask();
////				this.mainPanel.getGxtAccordionPanel().getOccurrencesLoadingPanel().layout();
//			}
		}

	}
	
	
	private void doElementGridSelected(boolean isSelected, ModelData target) {

	}
	
	/**
	 * init method
	 * @param rootPanel
	 */
	public void go(final HasWidgets rootPanel) {

		this.mainPanel = new OccurrenceManagementMainPanel();
		rootPanel.add(this.mainPanel.getBorderLayoutContainer());
//		this.jobManager = JobManager.getInstance();
		initApplication();
	}


	public GxtBorderLayoutMainPanel getMainPanel(){
		return this.mainPanel.getBorderLayoutContainer();
	}
	
	private void initApplication(){
		
		Scheduler.get().scheduleDeferred(new ScheduledCommand() {

			@Override
			public void execute() {
				
				mainPanel.getExplorerDataPanelMng().getOccurrencesLoadedPanel().mask(ConstantsPortletOccurrence.LOADING,ConstantsPortletOccurrence.LOADINGSTYLE);
				mainPanel.getCenterComputationPanelMng().getGridComputation().mask(ConstantsPortletOccurrence.LOADING,ConstantsPortletOccurrence.LOADINGSTYLE);

				initPollingOccurrencesImported();
				initPollingOccurrencesElaboration();
			
				excecuteGetListOccurrences(ElaborationType.IMPORTED, false, false);
				excecuteGetListOccurrences(ElaborationType.COMPUTATION, false, false);
				
				excecuteGetListOperator();

			}
		});
	}
	
	
	public static void initPollingOccurrencesImported() {

		timerOccurrencesImported = new PollingOccurrences(ElaborationType.IMPORTED, false, true);
		
	}
	
	public static void initPollingOccurrencesElaboration() {

		timerResultsExecution = new PollingOccurrences(ElaborationType.COMPUTATION, false, true);
	
	}
	
	
	public void excecuteGetListOperator(){
		
		 System.out.println("Get List Operators");
		 
		 mainPanel.getExplorerOperationPanelMng().getGridOperationPanel().mask(ConstantsPortletOccurrence.LOADING,ConstantsPortletOccurrence.LOADINGSTYLE);
		 
		 occurrenceManagementService.getListOperator(new AsyncCallback<List<Operator>>() {

			@Override
			public void onFailure(Throwable caught) {
				Info.display("Error on load operators", "An error occurred on load operators, retry.");
				GWT.log("Error on load operators An error occurred on load operators, retry." + "  " +caught.getMessage());
			}

			@Override
			public void onSuccess(List<Operator> result) {
				 mainPanel.getExplorerOperationPanelMng().getGridOperationPanel().unmask();
				if(result.size()>0)
					 mainPanel.getExplorerOperationPanelMng().getGridOperationPanel().loadListOperator(result);
				else{
					Info.display("Error on load operators", "An error occurred on load operators, size 0.");
				}
					
				
			}
		});
	}
	
	/**
	 * 
	 * @param elaborationType
	 * @param onlyNotCompleted
	 * @param notify
	 */
	public static void excecuteGetListOccurrences(final ElaborationType elaborationType, final boolean onlyNotCompleted, final boolean notify){
		
			GWT.log("New rpc GetListOccurences..." + elaborationType.getLabel()  +"  onlyNotCompleted: " + onlyNotCompleted + "  notify: " +notify);
		 
		 lockPolling(elaborationType, true);
		 
		 occurrenceManagementService.getListOccurrencesSet(elaborationType, onlyNotCompleted, new AsyncCallback<List<JobOccurrencesModel>>() {

			@Override
			public void onFailure(Throwable caught) {
//				Info.display("Error on import", "An error occurred on import occurrences, retry.");
				GWT.log("Error on GetListOccurences An error occurred on GetListOccurences, retry. type " + elaborationType.getLabel() + "  " +caught.getMessage());
			
			}

			@Override
			public void onSuccess(List<JobOccurrencesModel> result) {
				
				GWT.log("Return rpc GetListOccurences " + elaborationType.getLabel() + " size: "+result.size());
	 
				if(result.size()>0)
					updateCounters(elaborationType,result.size(), notify);
				
				lockPolling(elaborationType, false);
				
				eventBus.fireEvent(new LoadListOccurrencesEvent(elaborationType, result));
				
				
			}
		
		 });
	}
	
	private static void lockPolling(ElaborationType elaborationType, boolean lock){

		switch (elaborationType) {
				
			case IMPORTED:
			
				if(timerOccurrencesImported!=null){
					if(lock)
						timerOccurrencesImported.stopPolling();
					else
						timerOccurrencesImported.schedulePolling(DELAY);
				}
				break;
			
			case COMPUTATION:
				
				if(timerResultsExecution!=null){
					if(lock)
						timerResultsExecution.stopPolling();
					else
						timerResultsExecution.schedulePolling(DELAY);
				}
				break;	
		}
		
	}
	
	
	private static void updateCounters(ElaborationType elaborationType, int elements, boolean notify){
		
		int oldValue;
		
		switch (elaborationType) {
			
			case IMPORTED:
				
				oldValue = loadedCounter;
				loadedCounter = elements;
				
				if(notify){
					if((loadedCounter-oldValue)>0){
						Info.display("Imported", "A new occurrences list was imported");
					}
						
				}
				break;
				
//			case OCCURRENCESIMPORTING:
//				
//				oldValue = loadingCounter;
//				loadingCounter = elements;
//				
//				
//				if(notify){
//					if((loadingCounter-oldValue)>0){
//						Info.display("Importing", "A new occurrences list is available");
////						eventBus.fireEvent(new ReLoadListOccurrencesEvent(ElaborationType.OCCURRENCESIMPORTED));	
//					}
//				}
//				
//				break;
			
			case COMPUTATION:
				
//				oldValue = resultCounter;
//				resultCounter = elements;
//				
//				if(notify){
//					if((resultCounter-oldValue)>0)
//						Info.display("Info", "A new result list is available");
//				}
				break;	
		}
		
	}
	
	public void stopTimerImporting(){
		timerOccurrencesImported.cancel();
	}
	
	public void startTimerImporting(){
		timerOccurrencesImported.run();
	}
	
	
	public void stopTimerElaboration(){
		timerResultsExecution.cancel();
	}
	
	public void startTimerElaboration(){
		timerResultsExecution.run();
	}

}
