package org.gcube.portlets.user.joinvre.model;

import java.io.Serializable;
import java.util.List;

/**
 * VRECategory Model - Migrated from 6.2 to 7.4
 * 
 * @author Massimiliano Assante, ISTI-CNR (original)
 * @author netfarm-m2 (migration to 7.4)
 */
public class VRECategory implements Serializable {
	
	private static final long serialVersionUID = 1L;
	
	private String name;
	private String description;
	private List<VRE> vres;
	private int vreCount;
	
	public VRECategory() {
		super();
	}
	
	public VRECategory(String name, String description, List<VRE> vres) {
		this.name = name;
		this.description = description;
		this.vres = vres;
		this.vreCount = (vres != null) ? vres.size() : 0;
	}
	
	public String getName() {
		return name;
	}
	
	public void setName(String name) {
		this.name = name;
	}
	
	public String getDescription() {
		return description;
	}
	
	public void setDescription(String description) {
		this.description = description;
	}
	
	public List<VRE> getVres() {
		return vres;
	}
	
	public void setVres(List<VRE> vres) {
		this.vres = vres;
		this.vreCount = (vres != null) ? vres.size() : 0;
	}
	
	public int getVreCount() {
		return vreCount;
	}
	
	public void setVreCount(int vreCount) {
		this.vreCount = vreCount;
	}
	
	@Override
	public String toString() {
		return "VRECategory [name=" + name + ", description=" + description + 
				", vreCount=" + vreCount + "]";
	}
}