/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.gcube;

import java.io.InputStream;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.ExternalResourceLinkPlugin;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ExternalResourceBrokenLinkException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ExternalResourcePluginNotFoundException;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.FolderItemType;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.ExternalResourceLink;
import org.gcube.portlets.user.homelibrary.jcr.JCRExternalResourcePluginManager;
import org.gcube.portlets.user.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.JCRWorkspaceFolderItem;

public class JCRExternalResourceLink
extends JCRWorkspaceFolderItem
implements ExternalResourceLink {
    private static final String NT_CONTENT = "nthl:externalResourceLinkContent";
    private static final String MIME_TYPE = "hl:mimeType";
    private static final String RESOURCE_ID = "hl:resourceId";
    private static final String PLUGIN = "hl:servicePlugin";
    private String mimeType;
    private String resourceId;
    private String plugin;

    public JCRExternalResourceLink(JCRWorkspace workspace, Node node) throws RepositoryException {
        super(workspace, node);
        Node contentNode = node.getNode("jcr:content");
        this.mimeType = contentNode.getProperty(MIME_TYPE).getString();
        this.resourceId = contentNode.getProperty(RESOURCE_ID).getString();
        this.plugin = contentNode.getProperty(PLUGIN).getString();
    }

    public JCRExternalResourceLink(JCRWorkspace workspace, Node node, String name, String mimeType, String description, String resourceId, String plugin) throws RepositoryException {
        super(workspace, node, name, description);
        this.mimeType = mimeType;
        this.resourceId = resourceId;
        this.plugin = plugin;
        Node contentNode = node.addNode("jcr:content", NT_CONTENT);
        contentNode.setProperty(MIME_TYPE, mimeType);
        contentNode.setProperty(RESOURCE_ID, resourceId);
        contentNode.setProperty(PLUGIN, plugin);
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public InputStream getData() throws InternalErrorException, ExternalResourceBrokenLinkException, ExternalResourcePluginNotFoundException {
        ExternalResourceLinkPlugin plugin = JCRExternalResourcePluginManager.getPlugin(this.plugin);
        return plugin.getContent((ExternalResourceLink)this);
    }

    @Override
    public void saveContent(Node node) throws RepositoryException {
    }

    @Override
    public FolderItemType getFolderItemType() {
        return FolderItemType.SERVICE_RESOURCE_LINK;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public String getExternalResourcePlugin() {
        return this.plugin;
    }

    @Override
    public long getLength() throws InternalErrorException {
        return 0L;
    }
}

