package org.gcube.portlets.user.gisviewer.client;

import java.util.logging.Level;
import java.util.logging.Logger;

import org.gwtopenmaps.openlayers.client.Bounds;

public class Constants {

	public static String VERSION = "3.6.2";
	public static String defaultGroup= "group45be7606f-4add-4636-ad14-f353163d0bd3";
	public static String defaultGroup2 = "groupTemplate";

	// LOG AND INFO PRINTING 
	public static boolean printLog=true;
	/* Create Root Logger */
	public static Logger rootLogger = Logger.getLogger("");
	
	public static void log(String s) {
		if (printLog)
			rootLogger.log(Level.INFO, s);
	}
	public static void info(String title, String text) {
		if (printLog)
			rootLogger.log(Level.INFO, title +": "+ text);
	}
	public static void alert(String string, String string2) {
		if (printLog)
			rootLogger.log(Level.WARNING, string +": "+ string2);
	}

	// LAYERS
	public static final double defaultOpacityLayers = 0.7;
	
	public static final String[] brightLayers = {
		"TrueMarble.16km.2700x1350", 
		"Test.TrueMarble.16km.2700x1350_gf", 
		"depthmean",
		"depthmean_annual",
//		"depthMean",
	};
	
	public static final String[][] defaultStyleTransects = {
		{"depth_style", "DepthMean", "depth"},
		{"primprod_style", "PrimProdMean", "primprod"},
		{"salinity_style", "SalinityMean", "salinity"},
		{"sst_style", "SSTAnMean", "sst"},
		{"biodiversity_style", "Biodiv", "biodiversity"},
		{"ice_style", "IceConAnn", "ice"},
		{"occurrence_style", "GoodCell", "occurrence"}
	};
	
	public static final String[] dataStoresWithTransect = {
		"aquamapsdb",
		"aquamapsgeomar"
	};
	
	public static final String borderLayer = "Test.TrueMarble.16km.2700x1350_gf";
	public static final String baseLayer = "TrueMarble.16km.2700x1350";
	public static boolean isBorderLayerVisible=false;

	public static final int MAX_WFS_FEATURES = 200; // zero for no limit
	
	//INTERFACE
	public static final int geoWindowWidth=1000;//900;
	public static final int geoWindowHeight=760;//550;
	public static final int geoWindowMinWidth=300;
	public static final int geoWindowMinHeight=300;
	public static final String geoWindowTitle="GIS Viewer "+ VERSION;
	public static final boolean geoWindowShadow = false;
	public static final boolean geoWindowDataPanelOpenedAtStart = true;
	public static String defaultProjection = "EPSG:4326";
	
	public static final String hcafLegendWidth = "400px";

	public static final int omHeight = 279; //379; 
	public static final int omWidth = 701;
	public static final int omMaxHeight = 550;
	public static final int omMaxWidth = 930;
	
	public static final String panelsBodyStyle = "background-color:#FFFFFF";
	public static final int mapPanelSpacingX = 5;
	public static final int mapPanelSpacingY = 63;
	public static final String MessageLoadingLayersData = "Loading layers data...";
	public static final String FAO_DATA_STORE = "FI Geoserver";
	public static final String FAO_DATA_STORE_PREFIX = "fifao_";

	public static Bounds defaultBounds = new Bounds(-180, -90, 180, 90);// -180, -90, 180, 90 //-20037508.34,-20037508.34,20037508.34,20037508.34);// TODO -180, -90, 180, 90);
	
	public static final String defaultScope = "/gcube/devsec/devVRE";
//	public static final String defaultScope = "/d4science.research-infrastructures.eu/gCubeApps/EcologicalModelling";
	
	public static final int defaultOpenLayersMapDefaultZoom = 2;
	public static final int numZoomLevels = 15;
	
	public static boolean isOverViewMapVisible=false;
	
	public static boolean isSaveButtonEnabled = false;
	
	protected static int legendDialogMaxHeight = 500;
	protected static int legendDialogWidth = 200;

	public static enum Mode {NORMAL, TEST};
	public static Mode MODE = Mode.NORMAL;
	
	public static boolean getLayerTitles = true;
	public static boolean layersDragEnabled = true;
	//protected static String defaultProjection = "EPSG:900913";//"EPSG:4326";
	public static boolean buttonSaveLayerEnabled = true;
	
	public static int minGisViewerHeight = 550;

	
	
	//TRUE MARBLE OPEN LAYER REFERENCES
//	public final static String TRUE_MARBLE_TITLE = "True Marble";
//	public final static String TRUE_MARBLE_NAME = "truemarble";
//	public final static String TRUE_MARBLE_URL = "http://romeo.jrc.it/maps/mapserv.cgi?map=../mapfiles/acpmap_static.map&";
	
	//MAP SERVER PIVOT
	public static final String WXS = "wxs";
	//GEOSERVER PIVOT
	public static final String WMS = "/wms";
	
	//OUTPUT FORMAT
	public static final String CSV = "csv";
	public static final String JSON = "json";
	
	public static final String COOKIE_NAME = "GisViewerD4ScienceCK";
}
