/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.resourcemanagement.server;

import java.util.List;
import org.gcube.common.scope.impl.ScopeBean;
import org.gcube.resourcemanagement.support.client.utils.CurrentStatus;
import org.gcube.resourcemanagement.support.server.managers.resources.CollectionManager;
import org.gcube.resourcemanagement.support.server.managers.resources.GHNManager;
import org.gcube.resourcemanagement.support.server.managers.resources.GenericResourceManager;
import org.gcube.resourcemanagement.support.server.managers.resources.RuntimeResourceManager;
import org.gcube.resourcemanagement.support.server.types.AllowedResourceTypes;
import org.gcube.resourcemanagement.support.server.utils.ServerConsole;
import org.gcube.resourcemanagement.support.shared.exceptions.InvalidParameterException;
import org.gcube.resourcemanagement.support.shared.operations.SupportedOperations;
import org.gcube.resourcemanagement.support.shared.types.datamodel.ResourceDescriptor;
import org.gcube.resourcemanagement.support.shared.util.Assertion;

public class ResourceCommands {
    private static final String LOG_PREFIX = "[RES-CMDS]";

    public static void doOperation(CurrentStatus status, SupportedOperations opCode, String scope, List<ResourceDescriptor> resources) throws Exception {
        ServerConsole.debug((String)LOG_PREFIX, (String)("[RES-COMMANDS-DO] Required operation: " + opCode));
        Assertion checker = new Assertion();
        checker.validate(opCode != null, (Throwable)new InvalidParameterException("Invalid operation required"));
        checker.validate(scope != null && scope.length() > 0, (Throwable)new InvalidParameterException("Invalid scope."));
        checker.validate(resources != null && resources.size() > 0, (Throwable)new InvalidParameterException("Invalid resource descriptor."));
        checker.validate(opCode.isAllowed(status.getCredentials()), (Throwable)new InvalidParameterException("The current user is not allowed to execute the operation."));
        ScopeBean gscope = new ScopeBean(scope);
        if (opCode.equals((Object)SupportedOperations.GHN_SHUTDOWN)) {
            for (ResourceDescriptor resource : resources) {
                checker.validate(resource.getType().equals(AllowedResourceTypes.GHN.name()), (Throwable)new InvalidParameterException("Invalid type. GHN required"));
                new GHNManager(resource.getID(), resource.getName()).shutDown(gscope, false, false);
            }
        }
        if (opCode.equals((Object)SupportedOperations.GHN_RESTART) || opCode.equals((Object)SupportedOperations.GHN_CLEAN_RESTART)) {
            for (ResourceDescriptor resource : resources) {
                checker.validate(resource.getType().equals(AllowedResourceTypes.GHN.name()), (Throwable)new InvalidParameterException("Invalid type. GHN required"));
                new GHNManager(resource.getID(), resource.getName()).shutDown(gscope, true, opCode.equals((Object)SupportedOperations.GHN_CLEAN_RESTART));
            }
        }
        if (opCode.equals((Object)SupportedOperations.GHN_DELETE)) {
            for (ResourceDescriptor resource : resources) {
                checker.validate(resource.getType().equals(AllowedResourceTypes.GHN.name()), (Throwable)new InvalidParameterException("Invalid type. GHN required"));
                new GHNManager(resource.getID()).delete(gscope);
            }
        }
        if (opCode.equals((Object)SupportedOperations.GHN_FORCE_DELETE)) {
            for (ResourceDescriptor resource : resources) {
                checker.validate(resource.getType().equals(AllowedResourceTypes.GHN.name()), (Throwable)new InvalidParameterException("Invalid type. GHN required"));
                new GHNManager(resource.getID()).forceDelete(gscope);
            }
        }
        if (opCode.equals((Object)SupportedOperations.GENERIC_RESOURCE_DELETE)) {
            for (ResourceDescriptor resource : resources) {
                checker.validate(resource.getType().equals(AllowedResourceTypes.GenericResource.name()), (Throwable)new InvalidParameterException("Invalid type. " + AllowedResourceTypes.GenericResource.name() + " required"));
                new GenericResourceManager(resource.getID()).delete(gscope);
            }
        }
        if (opCode.equals((Object)SupportedOperations.GENERIC_RESOURCE_FORCE_DELETE)) {
            for (ResourceDescriptor resource : resources) {
                checker.validate(resource.getType().equals(AllowedResourceTypes.GenericResource.name()), (Throwable)new InvalidParameterException("Invalid type. " + AllowedResourceTypes.GenericResource.name() + " required"));
                new GenericResourceManager(resource.getID()).forceDelete(gscope);
            }
        }
        if (opCode.equals((Object)SupportedOperations.RUNTIME_RESOURCE_DELETE)) {
            System.out.println("DELETING RUNTIME RESOURCE");
            for (ResourceDescriptor resource : resources) {
                checker.validate(resource.getType().equals(AllowedResourceTypes.RuntimeResource.name()), (Throwable)new InvalidParameterException("Invalid type. " + AllowedResourceTypes.RuntimeResource.name() + " required"));
                new RuntimeResourceManager(resource.getID()).delete(gscope);
            }
        }
        if (opCode.equals((Object)SupportedOperations.RUNTIME_RESOURCE_FORCE_DELETE)) {
            for (ResourceDescriptor resource : resources) {
                checker.validate(resource.getType().equals(AllowedResourceTypes.RuntimeResource.name()), (Throwable)new InvalidParameterException("Invalid type. " + AllowedResourceTypes.RuntimeResource.name() + " required"));
                new RuntimeResourceManager(resource.getID()).forceDelete(gscope);
            }
        }
        if (opCode.equals((Object)SupportedOperations.COLLECTION_DELETE)) {
            for (ResourceDescriptor resource : resources) {
                checker.validate(resource.getType().equals(AllowedResourceTypes.Collection.name()), (Throwable)new InvalidParameterException("Invalid type. " + AllowedResourceTypes.Collection.name() + " required"));
                new CollectionManager(resource.getID()).delete(gscope);
            }
        }
        if (opCode.equals((Object)SupportedOperations.COLLECTION_FORCE_DELETE)) {
            for (ResourceDescriptor resource : resources) {
                checker.validate(resource.getType().equals(AllowedResourceTypes.Collection.name()), (Throwable)new InvalidParameterException("Invalid type. " + AllowedResourceTypes.Collection.name() + " required"));
                new CollectionManager(resource.getID()).forceDelete(gscope);
            }
        }
        if (opCode.equals((Object)SupportedOperations.RUNNING_INSTANCE_UNDEPLOY)) {
            for (ResourceDescriptor resource : resources) {
                ServerConsole.debug((String)LOG_PREFIX, (String)("Undeploying RI: " + resource.getID()));
            }
        }
    }
}

