/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.manageusers.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import com.liferay.portal.kernel.bean.BeanLocatorException;
import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.User;
import com.liferay.portal.model.VirtualHost;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.service.CompanyLocalServiceUtil;
import com.liferay.portal.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.service.VirtualHostLocalServiceUtil;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.gcube.applicationsupportlayer.social.ApplicationNotificationsManager;
import org.gcube.applicationsupportlayer.social.NotificationsManager;
import org.gcube.applicationsupportlayer.social.shared.SocialNetworkingSite;
import org.gcube.applicationsupportlayer.social.shared.SocialNetworkingUser;
import org.gcube.common.homelibrary.home.HomeLibrary;
import org.gcube.common.homelibrary.home.workspace.Workspace;
import org.gcube.common.portal.PortalContext;
import org.gcube.common.scope.impl.ScopeBean;
import org.gcube.portal.custom.scopemanager.scopehelper.ScopeHelper;
import org.gcube.portal.notifications.bean.GenericItemBean;
import org.gcube.portal.notifications.thread.MessageNotificationsThread;
import org.gcube.portlets.admin.manageusers.client.ManageUsersService;
import org.gcube.portlets.admin.manageusers.shared.PortalUserDTO;
import org.gcube.vomanagement.usermanagement.impl.LiferayGroupManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayUserManager;
import org.gcube.vomanagement.usermanagement.model.GCubeUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ManageUsersServiceImpl
extends RemoteServiceServlet
implements ManageUsersService {
    private static final Logger _log = LoggerFactory.getLogger(ManageUsersServiceImpl.class);
    public static final String DEFAULT_COMPANY_WEB_ID = "liferay.com";
    private static final String POSITION = "POSITION";
    private static final String LABS = "LABS";

    private boolean isWithinPortal() {
        try {
            UserLocalServiceUtil.getService();
            return true;
        }
        catch (BeanLocatorException ex) {
            _log.trace("Development Mode ON");
            return false;
        }
    }

    public ArrayList<PortalUserDTO> getAvailableUsers() {
        ArrayList<PortalUserDTO> toReturn = new ArrayList<PortalUserDTO>();
        if (this.isWithinPortal()) {
            return this.getNonBelongingUsersForVRE();
        }
        for (int i = 0; i < 20; ++i) {
            String role = i % 2 == 0 ? "Research Staff" : "Graduate Fellow";
            String lastName = "TheLastName " + i;
            String firstLetter = lastName.substring(0, 1);
            PortalUserDTO toAdd = new PortalUserDTO("" + i, firstLetter, "aName " + i, lastName, i + "email@isti.cnr.it", role, "HPC");
            toReturn.add(toAdd);
        }
        PortalUserDTO toAdd = new PortalUserDTO("1", "A", "Massimiliano", "Assante", "assante@isti.cnr.it", "Research Staff", "NeMIS");
        toReturn.add(toAdd);
        toAdd = new PortalUserDTO("1", "M", "Francesco", "Mangiacrapa", "mangi@isti.cnr.it", "Graduate Fellow", "NeMIS");
        toReturn.add(toAdd);
        toAdd = new PortalUserDTO("1", "N", "Salvatore", "Neri", "neri@isti.cnr.it", "Graduate Fellow", "KDD");
        toReturn.add(toAdd);
        toAdd = new PortalUserDTO("1", "P", "Giorgio", "Pini", "pini@isti.cnr.it", "Graduate Fellow", "SI");
        toReturn.add(toAdd);
        toAdd = new PortalUserDTO("1", "F", "Dario", "Faggiu", "faggiu@isti.cnr.it", "Research Staff", "VC");
        toReturn.add(toAdd);
        return toReturn;
    }

    private Group getSiteFromServletRequest(HttpServletRequest request) throws Exception {
        String serverName = request.getServerName();
        Group site = null;
        List vHosts = VirtualHostLocalServiceUtil.getVirtualHosts((int)0, (int)VirtualHostLocalServiceUtil.getVirtualHostsCount());
        for (VirtualHost virtualHost : vHosts) {
            if (virtualHost.getHostname().compareTo("localhost") == 0 || virtualHost.getLayoutSetId() == 0L || virtualHost.getHostname().compareTo(serverName) != 0) continue;
            long layoutSetId = virtualHost.getLayoutSetId();
            site = LayoutSetLocalServiceUtil.getLayoutSet((long)layoutSetId).getGroup();
            return site;
        }
        _log.warn("serverName is " + serverName + " but i could not find any virtualHost associated to it");
        return null;
    }

    public ArrayList<PortalUserDTO> getNonBelongingUsersForVRE() {
        CacheRegistryUtil.clear();
        PortalContext pContext = PortalContext.getConfiguration();
        String scope = pContext.getCurrentScope(this.getThreadLocalRequest());
        GCubeUser currentUser = pContext.getCurrentUser(this.getThreadLocalRequest());
        try {
            long companyId = CompanyLocalServiceUtil.getCompanyByWebId((String)ManageUsersServiceImpl.getDefaultCompanyWebId()).getCompanyId();
            _log.trace("Setting Thread Permission");
            User userAdmin = UserLocalServiceUtil.getUserByScreenName((long)companyId, (String)ScopeHelper.getAdministratorUsername());
            _log.trace("Setting Thread Permission for admin=" + userAdmin.getScreenName());
            PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)userAdmin);
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
            _log.trace("Setting Permission ok!");
            ArrayList<PortalUserDTO> unregisteredUsers = new ArrayList<PortalUserDTO>();
            long currSiteGroupId = this.getSiteFromServletRequest(this.getThreadLocalRequest()).getGroupId();
            LiferayUserManager userM = new LiferayUserManager();
            List nonBelongingUsers = userM.listUsersByGroup(currSiteGroupId, false);
            nonBelongingUsers.removeAll(userM.listUsersByGroup(pContext.getCurrentGroupId(this.getThreadLocalRequest())));
            for (GCubeUser u : nonBelongingUsers) {
                String id = u.getUsername();
                User user = UserLocalServiceUtil.getUserByScreenName((long)companyId, (String)id);
                String position = "";
                String labs = "";
                if (user.getExpandoBridge() != null && user.getExpandoBridge().hasAttribute("POSITION")) {
                    position = user.getExpandoBridge().getAttribute("POSITION") != null ? user.getExpandoBridge().getAttribute("POSITION").toString() : "";
                    String string = labs = user.getExpandoBridge().getAttribute("LABS") != null ? user.getExpandoBridge().getAttribute("LABS").toString() : "";
                }
                if (u.getLastName() == null || u.getLastName().compareTo("") == 0) continue;
                String firstLetter = u.getLastName().substring(0, 1);
                ScopeBean validator = new ScopeBean(scope);
                String email = u.getEmail();
                String username = id;
                if (validator.is(ScopeBean.Type.VRE)) {
                    email = "********@" + email.split("@")[1];
                }
                PortalUserDTO myUser = new PortalUserDTO(username, firstLetter, u.getFirstName(), u.getLastName(), email, position, labs);
                unregisteredUsers.add(myUser);
            }
            _log.trace("Setting Thread Permission back to regular");
            User user = UserLocalServiceUtil.getUserByScreenName((long)companyId, (String)currentUser.getUsername());
            permissionChecker = PermissionCheckerFactoryUtil.create((User)user);
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
            _log.trace("Setting Permission ok!");
            return unregisteredUsers;
        }
        catch (Exception e) {
            _log.error("Failed to retrieve the unregistered users. An exception was thrown", (Throwable)e);
            return null;
        }
    }

    public boolean registerUsers(List<PortalUserDTO> users2Register) {
        long vreGroupId = PortalContext.getConfiguration().getCurrentGroupId(this.getThreadLocalRequest());
        LiferayUserManager userM = new LiferayUserManager();
        for (PortalUserDTO user : users2Register) {
            try {
                userM.assignUserToGroup(vreGroupId, userM.getUserId(user.getId()));
                this.sendNotificationToUser(vreGroupId, user);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    private boolean sendNotificationToUser(long groupId, PortalUserDTO addressee) throws Exception {
        PortalContext pContext = PortalContext.getConfiguration();
        String scope = pContext.getCurrentScope(this.getThreadLocalRequest());
        GCubeUser currentUser = pContext.getCurrentUser(this.getThreadLocalRequest());
        Workspace workspace = HomeLibrary.getUserWorkspace((String)currentUser.getUsername());
        ArrayList<String> recipientIds = new ArrayList<String>();
        recipientIds.add(addressee.getId());
        ArrayList<GenericItemBean> recipients = new ArrayList<GenericItemBean>();
        recipients.add(new GenericItemBean(addressee.getId(), addressee.getId(), addressee.getName() + " " + addressee.getLastName(), ""));
        String gatewayName = PortalContext.getConfiguration().getGatewayName(this.getThreadLocalRequest());
        String gatewayURL = PortalContext.getConfiguration().getGatewayURL(this.getThreadLocalRequest());
        String vreURL = gatewayURL + "/group" + new LiferayGroupManager().getGroup(groupId).getFriendlyURL();
        String subject = "Registration to VRE notification";
        String body = "Dear " + addressee.getName() + ", \n\n I just registered you to the VRE " + pContext.getCurrentGroupName(this.getThreadLocalRequest()) + " on the " + gatewayName + ". \n\n";
        body = body + "Please, click here to access the VRE: " + vreURL;
        String messageId = workspace.getWorkspaceMessageManager().sendMessageToPortalLogins(subject, body, new ArrayList(), recipientIds);
        _log.debug("Sending message notification to: " + ((Object)recipientIds).toString());
        ApplicationNotificationsManager nm = new ApplicationNotificationsManager(new SocialNetworkingSite(this.getThreadLocalRequest()), scope, new SocialNetworkingUser(currentUser.getUsername(), currentUser.getEmail(), currentUser.getFullname(), currentUser.getUserAvatarURL()));
        Thread thread = new Thread((Runnable)new MessageNotificationsThread(recipients, messageId, subject, body, (NotificationsManager)nm));
        thread.start();
        return messageId != null;
    }

    public static String getDefaultCompanyWebId() {
        String defaultWebId = "";
        try {
            defaultWebId = GetterUtil.getString((String)PropsUtil.get((String)"company.default.web.id"));
        }
        catch (NullPointerException e) {
            _log.info("Cound not find property company.default.web.id in portal.ext file returning default web id: liferay.com");
            return "liferay.com";
        }
        return defaultWebId;
    }
}

