/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.accountingmanager.server.amservice.command;

import java.util.Calendar;
import java.util.List;
import java.util.SortedMap;
import org.gcube.accounting.analytics.Filter;
import org.gcube.accounting.analytics.persistence.AccountingPersistenceQuery;
import org.gcube.accounting.analytics.persistence.AccountingPersistenceQueryFactory;
import org.gcube.portlets.admin.accountingmanager.server.amservice.command.AccountingCommand;
import org.gcube.portlets.admin.accountingmanager.server.amservice.command.AccountingCommandSpaces;
import org.gcube.portlets.admin.accountingmanager.server.amservice.query.AccountingQuerySpaces;
import org.gcube.portlets.admin.accountingmanager.server.amservice.response.SeriesResponse4SpaceSpaces;
import org.gcube.portlets.admin.accountingmanager.server.amservice.response.SeriesResponseBuilder;
import org.gcube.portlets.admin.accountingmanager.server.amservice.response.SeriesResponseDirector;
import org.gcube.portlets.admin.accountingmanager.shared.data.AccountingType;
import org.gcube.portlets.admin.accountingmanager.shared.data.Spaces;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.SeriesResponse;
import org.gcube.portlets.admin.accountingmanager.shared.exception.ServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountingCommandSpaces
implements AccountingCommand<SeriesResponse> {
    private static final Logger logger = LoggerFactory.getLogger(AccountingCommandSpaces.class);
    private AccountingQuerySpaces accountingQuerySpaces;
    private AccountingType accountingType;

    public AccountingCommandSpaces(AccountingQuerySpaces accountingQuerySpaces, AccountingType accountingType) {
        this.accountingQuerySpaces = accountingQuerySpaces;
        this.accountingType = accountingType;
    }

    public SeriesResponse execute() throws ServiceException {
        try {
            AccountingPersistenceQuery apq = AccountingPersistenceQueryFactory.getInstance();
            logger.debug("Query Spaces: " + this.accountingQuerySpaces.getSpaces());
            Spaces spaces = this.accountingQuerySpaces.getSpaces();
            if (spaces == null) {
                throw new ServiceException("Error retrieving Spaces param: null!");
            }
            SortedMap spaceSM = apq.getSpaceTimeSeries(this.accountingQuerySpaces.getType(), this.accountingQuerySpaces.getTemporalConstraint(), (List)this.accountingQuerySpaces.getFilters(), (List)spaces.getSpacesList());
            if (spaceSM == null) {
                throw new ServiceException("Error retrieving info for space: sorted map is null!");
            }
            logger.debug("SpaceSM: " + spaceSM);
            SeriesResponseBuilder seriesResponseBuilder = this.getSeriesResponseBuilder(this.accountingType, spaces, spaceSM);
            SeriesResponseDirector seriesResponseDirector = new SeriesResponseDirector();
            seriesResponseDirector.setSeriesResponseBuilder(seriesResponseBuilder);
            seriesResponseDirector.constructSeriesResponse();
            SeriesResponse seriesResponse = seriesResponseDirector.getSeriesResponse();
            if (seriesResponse == null) {
                throw new ServiceException("Error creating series response!");
            }
            logger.debug("SeriesResponse Created: " + seriesResponse);
            return seriesResponse;
        }
        catch (Throwable e) {
            logger.error("Error in AccountingCommandSpace(): " + e.getLocalizedMessage());
            e.printStackTrace();
            throw new ServiceException("No data available!");
        }
    }

    private SeriesResponseBuilder getSeriesResponseBuilder(AccountingType accountingType, Spaces spaces, SortedMap<Filter, SortedMap<Calendar, Long>> spaceSM) throws ServiceException {
        if (accountingType == null) {
            throw new ServiceException("Error accounting type is null");
        }
        switch (1.$SwitchMap$org$gcube$portlets$admin$accountingmanager$shared$data$AccountingType[accountingType.ordinal()]) {
            case 1: {
                return new SeriesResponse4SpaceSpaces(spaces, spaceSM);
            }
        }
        throw new ServiceException("Error request type is unknow!");
    }
}

