/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.accountingmanager.client.carousel;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.event.dom.client.MouseUpEvent;
import com.google.gwt.event.dom.client.MouseWheelEvent;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import com.sencha.gxt.chart.client.draw.DrawComponent;
import com.sencha.gxt.chart.client.draw.sprite.ImageSprite;
import com.sencha.gxt.chart.client.draw.sprite.Sprite;
import com.sencha.gxt.chart.client.draw.sprite.SpriteOutEvent;
import com.sencha.gxt.chart.client.draw.sprite.SpriteOverEvent;
import com.sencha.gxt.chart.client.draw.sprite.SpriteSelectionEvent;
import com.sencha.gxt.core.client.util.Margins;
import com.sencha.gxt.widget.core.client.FramedPanel;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import java.util.ArrayList;
import java.util.Iterator;
import org.gcube.portlets.admin.accountingmanager.client.graphics.Vector2D;
import org.gcube.portlets.admin.accountingmanager.client.resource.AccountingManagerResources;

public class CarouselPanel
extends FramedPanel {
    private static final int WIDTH = 1024;
    private static final int HEIGHT = 768;
    private DrawComponent paint;
    private ArrayList<ImageSprite> sprites;
    private Timer mouseTimer;
    private Sprite currentSprite;
    private Sprite activeSprite;
    private Vector2D startPosition;
    private Vector2D currentPosition;
    private Vector2D endPosition;
    private Vector2D displacement;

    public CarouselPanel() {
        this.init();
        this.create();
        this.unmask();
        this.drawInit();
    }

    private void init() {
        this.setWidth(1024);
        this.setHeight(768);
        this.setHeaderVisible(false);
        this.setBodyBorder(false);
        this.setResize(true);
    }

    private void create() {
        VerticalLayoutContainer layout = new VerticalLayoutContainer();
        this.add((Widget)layout);
        this.paint = new DrawComponent();
        this.paint.setLayoutData((Object)new VerticalLayoutContainer.VerticalLayoutData(1.0, 1.0));
        this.paint.addSpriteSelectionHandler((SpriteSelectionEvent.SpriteSelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.paint.addSpriteOverHandler((SpriteOverEvent.SpriteOverHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.paint.addSpriteOutHandler((SpriteOutEvent.SpriteOutHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.paint.addDomHandler((EventHandler)new /* Unavailable Anonymous Inner Class!! */, MouseUpEvent.getType());
        this.paint.addDomHandler((EventHandler)new /* Unavailable Anonymous Inner Class!! */, MouseWheelEvent.getType());
        layout.add((IsWidget)this.paint, new VerticalLayoutContainer.VerticalLayoutData(1.0, 1.0, new Margins(0)));
    }

    protected void drawInit() {
        this.addSprites();
        this.paint.redrawSurfaceForced();
    }

    private void addSprites() {
        this.sprites = new ArrayList();
        this.sprites.add(new ImageSprite(AccountingManagerResources.INSTANCE.accountingStorage128()));
        for (ImageSprite sprite : this.sprites) {
            this.paint.addSprite((Sprite)sprite);
        }
    }

    protected void createMouseTimer() {
        this.mouseTimer = new /* Unavailable Anonymous Inner Class!! */;
        this.mouseTimer.scheduleRepeating(200);
        Log.debug((String)"MouseTimer Start");
    }

    protected void activeSprite(SpriteSelectionEvent event) {
        block1: {
            ImageSprite sprite;
            Event browseEvent = event.getBrowserEvent();
            browseEvent.preventDefault();
            Log.debug((String)("Active Position: " + browseEvent.getClientX() + ", " + browseEvent.getClientY()));
            this.activeSprite = event.getSprite();
            this.startPosition = new Vector2D((double)browseEvent.getClientX(), (double)browseEvent.getClientY());
            if (this.activeSprite == null) break block1;
            Iterator i$ = this.sprites.iterator();
            while (i$.hasNext() && this.activeSprite != (sprite = (ImageSprite)i$.next())) {
            }
        }
    }

    protected void spriteMouseUp(MouseUpEvent event) {
        Log.debug((String)("Deactive Position: " + event.getClientX() + ", " + event.getClientY()));
        this.endPosition = new Vector2D((double)event.getClientX(), (double)event.getClientY());
        this.displacement = this.startPosition.sub(this.endPosition);
        this.activeSprite = null;
        if (this.mouseTimer != null) {
            this.mouseTimer.cancel();
        }
    }

    protected void spriteLeave(SpriteOutEvent event) {
        Event browseEvent = event.getBrowserEvent();
        Log.debug((String)("Leave Position: " + browseEvent.getClientX() + ", " + browseEvent.getClientY()));
        this.activeSprite = null;
        if (this.mouseTimer != null) {
            this.mouseTimer.cancel();
        }
    }

    protected void spriteOver(SpriteOverEvent event) {
        Event browseEvent = event.getBrowserEvent();
        Log.debug((String)("Over Position: " + browseEvent.getClientX() + ", " + browseEvent.getClientY()));
        this.currentPosition = new Vector2D((double)browseEvent.getClientX(), (double)browseEvent.getClientY());
        if (this.activeSprite != null) {
            this.currentSprite = event.getSprite();
            for (ImageSprite sprite : this.sprites) {
                if (this.currentSprite != sprite) continue;
                this.displacement = this.startPosition.sub(this.currentPosition);
                Log.debug((String)"Chart Sprite Selected");
                this.actionOnChartSpriteWhenMove();
                break;
            }
        }
    }

    protected void spriteMouseWheel(MouseWheelEvent event) {
        int deltaY = event.getDeltaY();
        Log.debug((String)("Wheel: " + deltaY));
        this.draw();
    }

    protected void actionOnChartSpriteWhenMove() {
        this.draw();
    }

    protected void actionOnChartSpriteWhenMouseLeftDown() {
        this.draw();
    }

    protected void draw() {
        this.paint.redrawSurfaceForced();
    }
}

