/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.action;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.ConfigurationAction;
import com.liferay.portal.kernel.portlet.DefaultConfigurationAction;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;

@Component(configurationPolicy=ConfigurationPolicy.OPTIONAL, immediate=true, property={"javax.portlet.name=org_gcube_portlets_admin_RPTTokenPortlet"}, service={ConfigurationAction.class})
public class RPTTokenConfigurationAction
extends DefaultConfigurationAction {
    private static final Log _log = LogFactoryUtil.getLog(RPTTokenConfigurationAction.class);

    public void processAction(PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        if (!"update".equals(cmd)) {
            return;
        }
        String exchangeClientId = ParamUtil.getString((PortletRequest)actionRequest, (String)"exchangeClientId");
        String exchangeClientSecret = ParamUtil.getString((PortletRequest)actionRequest, (String)"exchangeClientSecret");
        String defaultTokenUrl = ParamUtil.getString((PortletRequest)actionRequest, (String)"defaultTokenUrl");
        boolean debugMode = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"debugMode");
        if (Validator.isNull((String)exchangeClientId)) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"exchangeClientIdRequired");
            return;
        }
        if (Validator.isNull((String)exchangeClientSecret)) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"exchangeClientSecretRequired");
            return;
        }
        if (Validator.isNull((String)defaultTokenUrl)) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"defaultTokenUrlRequired");
            return;
        }
        try {
            PortletPreferences preferences = actionRequest.getPreferences();
            preferences.setValue("exchangeClientId", exchangeClientId);
            preferences.setValue("exchangeClientSecret", exchangeClientSecret);
            preferences.setValue("defaultTokenUrl", defaultTokenUrl);
            preferences.setValue("debugMode", String.valueOf(debugMode));
            preferences.store();
            if (_log.isInfoEnabled()) {
                _log.info((Object)"RPT Token configuration updated successfully");
                _log.info((Object)("Exchange Client ID: " + exchangeClientId));
                _log.info((Object)("Default Token URL: " + defaultTokenUrl));
                _log.info((Object)("Debug Mode: " + debugMode));
            }
            SessionMessages.add((PortletRequest)actionRequest, (String)"configurationSaved");
        }
        catch (Exception e) {
            _log.error((Object)"Error saving RPT Token configuration", (Throwable)e);
            SessionErrors.add((PortletRequest)actionRequest, (String)"configurationError");
        }
    }
}

