<%--
/**
 * Copyright (c) 2000-2013 Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */
--%>

<%@page import="com.liferay.portal.kernel.language.LanguageUtil"%>
<%@ include file="/html/portlet/login/init.jsp"%>

<script>
	window.jQuery
			|| document
					.write(
							'<script src="https://ajax.googleapis.com/ajax/libs/jquery/1.8.2/jquery.min.js" type="text/javascript"><\/script>')
</script>
<script type="text/javascript"
	src="/html/portlet/login/js/bootstrap-collapse.js"></script>
<script type="text/javascript"
	src="/html/portlet/login/js/bootstrap-transition.js"></script>
<script type="text/javascript"
	src="/html/portlet/login/js/login-hook.js"></script>

<link rel="stylesheet" href="/html/portlet/login/css/login-hook.css">

<%
	String[] socials = PropsUtil.getArray("login.form.navigation.socials");

	PortalContext context = PortalContext.getConfiguration();
	String siteUrl = context.getSiteLandingPagePath(request);
	String workspaceUrl = siteUrl + GCubePortalConstants.USER_WORKSPACE_FRIENDLY_URL;
	final String GET_CLIENT_ID_PARAMETER = "client_id";
	final String GET_SCOPE_PARAMETER = "scope";
	final String GET_REDIRECTURL_PARAMETER = "redirect_uri";
	final String GET_STATE_PARAMETER = "state";
	boolean hideCreateAccountAndForgotPassword = false;
	boolean clientNotAuthorised = false;
%>
<c:choose>
	<c:when test="<%=themeDisplay.isSignedIn()%>">

		<%
			String signedInAs = HtmlUtil.escape(user.getFullName());

					if (themeDisplay.isShowMyAccountIcon() && (themeDisplay.getURLMyAccount() != null)) {
						String myAccountURL = String.valueOf(themeDisplay.getURLMyAccount());

						if (PropsValues.DOCKBAR_ADMINISTRATIVE_LINKS_SHOW_IN_POP_UP) {
							signedInAs = "<a class=\"signed-in\" href=\"javascript:Liferay.Util.openWindow({dialog: {destroyOnHide: true}, title: '"
									+ HtmlUtil.escapeJS(LanguageUtil.get(pageContext, "my-account")) + "', uri: '"
									+ HtmlUtil.escapeJS(myAccountURL) + "'});\">" + signedInAs + "</a>";
						} else {
							myAccountURL = HttpUtil.setParameter(myAccountURL, "controlPanelCategory",
									PortletCategoryKeys.MY);

							signedInAs = "<a class=\"signed-in\" href=\"" + HtmlUtil.escape(myAccountURL) + "\">"
									+ signedInAs + "</a>";
						}
					}
		%>

		<%
			String siteMarkUp = "<a href=\"" + HtmlUtil.escape(siteUrl) + "\">"
							+ themeDisplay.getSiteGroupName() + "</a>";
					String workSpaceMarkUp = "<a href=\"" + HtmlUtil.escape(workspaceUrl) + "\">"
							+ LanguageUtil.get(pageContext, "shared-workspace") + "</a>";
		%>

		<%=LanguageUtil.format(pageContext, "you-are-signed-in-as-x", signedInAs, false)%>
		<br>
		<%=LanguageUtil.format(pageContext, "go-to-x", siteMarkUp, false)%>
		<br>
		<%=LanguageUtil.format(pageContext, "go-to-x", workSpaceMarkUp, false)%>

	</c:when>
	<c:otherwise>
		<%
			String redirect = ParamUtil.getString(request, "redirect");
		%>

		<!-- include for recognising requesting apps-->
		<%@ include file="/html/portlet/login/RequestingApplication.jsp"%>
		<!-- end include for recognising requesting apps-->


		<h4 class="login-sign-in"><%=LanguageUtil.get(pageContext, "sign-in")%></h4>

		<%
			String login = LoginUtil.getLogin(request, "login", company);
					String password = StringPool.BLANK;
					boolean rememberMe = ParamUtil.getBoolean(request, "rememberMe");

					if (Validator.isNull(authType)) {
						authType = company.getAuthType();
					}
		%>
		<portlet:actionURL
			secure="<%=PropsValues.COMPANY_SECURITY_AUTH_REQUIRES_HTTPS || request.isSecure()%>"
			var="loginURL">
			<portlet:param name="struts_action" value="/login/login" />
		</portlet:actionURL>
<!-- START CLIENT NOT AUTHORISED -->		
<c:if test="<%=clientNotAuthorised == false%>">
		
		<aui:form action="<%=loginURL%>"
			autocomplete='<%=PropsValues.COMPANY_SECURITY_LOGIN_FORM_AUTOCOMPLETE ? "on" : "off"%>'
			cssClass="sign-in-form" method="post" name="fm">
			<aui:input name="saveLastPath" type="hidden" value="<%=false%>" />
			<aui:input name="redirect" type="hidden" value="<%=redirect%>" />
			<aui:input name="doActionAfterLogin" type="hidden"
				value="<%=portletName.equals(PortletKeys.FAST_LOGIN) ? true : false%>" />

			<c:choose>
				<c:when test='<%=SessionMessages.contains(request, "userAdded")%>'>

					<%
						String userEmailAddress = (String) SessionMessages.get(request, "userAdded");
											String userPassword = (String) SessionMessages.get(request, "userAddedPassword");
					%>

					<div class="alert alert-success">
						<c:choose>
							<c:when
								test="<%=company.isStrangersVerify() || Validator.isNull(userPassword)%>">
								<%=LanguageUtil.get(pageContext, "thank-you-for-creating-an-account")%>

								<c:if test="<%=company.isStrangersVerify()%>">
									<%=LanguageUtil.format(pageContext,
													"your-email-verification-code-has-been-sent-to-x",
													userEmailAddress)%>
								</c:if>
							</c:when>
							<c:otherwise>
								<%=LanguageUtil.format(pageContext,
												"thank-you-for-creating-an-account.-your-password-is-x", userPassword,
												false)%>
							</c:otherwise>
						</c:choose>

						<%-- <c:if test="<%= PrefsPropsUtil.getBoolean(company.getCompanyId(), PropsKeys.ADMIN_EMAIL_USER_ADDED_ENABLED) %>">
								<%= LanguageUtil.format(pageContext, "your-password-has-been-sent-to-x", userEmailAddress) %>
							</c:if> --%>
					</div>
				</c:when>
				<c:when
					test='<%=SessionMessages.contains(request, "userPending")%>'>

					<%
						String userEmailAddress = (String) SessionMessages.get(request, "userPending");
					%>

					<div class="alert alert-success">
						<%=LanguageUtil.format(pageContext,
										"thank-you-for-creating-an-account.-you-will-be-notified-via-email-at-x-when-your-account-has-been-approved",
										userEmailAddress)%>
					</div>
				</c:when>
			</c:choose>

			<liferay-ui:error exception="<%=AuthException.class%>"
				message="authentication-failed" />
			<liferay-ui:error exception="<%=CompanyMaxUsersException.class%>"
				message="unable-to-login-because-the-maximum-number-of-users-has-been-reached" />
			<liferay-ui:error
				exception="<%=CookieNotSupportedException.class%>"
				message="authentication-failed-please-enable-browser-cookies" />
			<liferay-ui:error exception="<%=NoSuchUserException.class%>"
				message="authentication-failed" />
			<liferay-ui:error exception="<%=PasswordExpiredException.class%>"
				message="your-password-has-expired" />
			<liferay-ui:error exception="<%=UserEmailAddressException.class%>"
				message="authentication-failed" />
			<liferay-ui:error exception="<%=UserLockoutException.class%>"
				message="this-account-has-been-locked" />
			<liferay-ui:error exception="<%=UserPasswordException.class%>"
				message="authentication-failed" />
			<liferay-ui:error exception="<%=UserScreenNameException.class%>"
				message="authentication-failed" />

			<aui:fieldset>

				<%
					String loginLabel = null;

									if (authType.equals(CompanyConstants.AUTH_TYPE_EA)) {
										loginLabel = "email-address";
									} else if (authType.equals(CompanyConstants.AUTH_TYPE_SN)) {
										loginLabel = "screen-name";
									} else if (authType.equals(CompanyConstants.AUTH_TYPE_ID)) {
										loginLabel = "id";
									}
				%>
				<div class="custom-form-login-wrapper">
					<aui:input
						autoFocus="<%=windowState.equals(LiferayWindowState.EXCLUSIVE)
										|| windowState.equals(WindowState.MAXIMIZED)%>"
						cssClass="clearable login-identifier input-xlarge"
						placeholder="<%=loginLabel%>" label="" name="login"
						showRequiredLabel="<%=false%>" type="text">
						<aui:validator name="required" />
					</aui:input>

					<aui:input name="password" placeholder="password"
						cssClass="login-password input-xlarge" label=""
						showRequiredLabel="<%=false%>" type="password"
						value="<%=password%>">
						<aui:validator name="required" />
					</aui:input>

					<aui:button type="submit"
						cssClass="login-sign-in-button input-xlarge" value="sign-in" />

					<span id="<portlet:namespace />passwordCapsLockSpan"
						style="display: none;"><liferay-ui:message
							key="caps-lock-is-on" /></span>

					<c:if
						test="<%=company.isAutoLogin() && !PropsValues.SESSION_DISABLED%>">
						<div class="login-remember-me">
							<aui:input checked="<%=rememberMe%>" name="rememberMe"
								type="checkbox" />
						</div>
					</c:if>
				</div>
			</aui:fieldset>

		</aui:form>
		<c:if test="<%=hideCreateAccountAndForgotPassword == true%>">
		<%
		Map<String, String> queryMap = AuthUtil.getQueryMap(redirect);
		String redirectURI = queryMap.get(GET_REDIRECTURL_PARAMETER);
		String responseWithError = redirectURI+"?error=user_cancelled_login&error_description=refused%2flogin&state="+queryMap.get(GET_STATE_PARAMETER);
		%>
			<div style="text-align: center;">
				<button class="btn input-xlarge"
					onClick="location.href='<%=responseWithError%>'">Deny Access</button>
			</div>
		</c:if>
		<liferay-util:include page="/html/portlet/login/navigation.jsp" />

		<c:if test="<%=socials.length > 0%>">
			<div class="accordion" id="accordion" role="tablist">
				<div class="accordion-group">
					<div class="accordion-heading">
						<a data-toggle="collapse" data-parent="#accordion"
							href="#collapseMe" aria-expanded="true"
							aria-controls="collapseMe">
							<h4>
								<i class="icon-double-angle-up"></i>
							</h4>
						</a>
					</div>
					<div id="collapseMe" class="accordion-body collapse in">
						<div class="accordion-inner">
							<liferay-util:include page="/html/portlet/login/social.jsp" />
						</div>
					</div>
				</div>
				<div class="span12 text-center">
					<p class="text-info">E-mail addresses already connected with existing accounts allow signing in with them. If a new e-mail address is used, a new account will be automatically created.</p>
				</div>
			</div>
		</c:if>
<!-- END CLIENT NOT AUTHORISED -->		
</c:if> 

		<aui:script use="aui-base">
			var password = A.one('#<portlet:namespace />password');

			if (password) {
				password.on(
					'keypress',
					function(event) {
						Liferay.Util.showCapsLock(event, '<portlet:namespace />passwordCapsLockSpan');
					}
				);
			}
		</aui:script>
	</c:otherwise>
</c:choose>
<c:if test="<%=hideCreateAccountAndForgotPassword == true%>">
	<script>
		$(".taglib-icon-list").hide();
	</script>
</c:if>
