/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.messaging.accounting.portal.logparser.entry;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.gcube.messaging.accounting.portal.logparser.AccessLogParser;
import org.gcube.messaging.accounting.portal.logparser.entry.Message;
import org.gcube.messaging.common.messages.records.HLRecord;
import org.gcube.messaging.common.messages.records.WebAppRecord;

public class Message {
    protected static final String messageTokensSeparator = "|";
    protected static final String hlAddresssesSeparator = ";";
    protected static final String hlAddresssesSeparator2 = ":";
    private AccessLogParser.EntryType type;
    private String message;
    private String term;
    private String operator;
    private String browseBy;
    private boolean isDistinct;
    private HashMap<String, String> collections = null;
    private HashMap<String, String> terms = null;
    private String[] content = new String[2];
    private String[] hlentry = new String[3];
    private String[] annotationEntry = new String[4];
    private String[] workflowDocumentsEntry = new String[3];
    private String[] reportEntry = new String[3];
    private String[] webAppEntry = new String[5];
    private String[] warEntry = new String[5];
    private ArrayList<WebAppRecord.GHN> listGHN = new ArrayList();
    private ArrayList<WebAppRecord.WebApplication> listApplication = new ArrayList();
    private String[] aquamapsEntry = new String[5];
    private ArrayList<HLRecord.GCUBEUser> addresseeUsers = null;
    private String[] aisentry = new String[2];
    private String tstitle;
    protected StringTokenizer tokenizer = null;

    public Message(String token, AccessLogParser.EntryType type) {
        this.message = token;
        this.type = type;
    }

    public void parse() throws ParseException {
        switch (1.$SwitchMap$org$gcube$messaging$accounting$portal$logparser$AccessLogParser$EntryType[this.type.ordinal()]) {
            case 1: {
                this.collections = new HashMap();
                StringTokenizer tokenizer = new StringTokenizer(this.message, messageTokensSeparator);
                while (tokenizer.hasMoreElements()) {
                    String tok = tokenizer.nextToken();
                    if (tok.contains(SearchAndBrowseTokens.collectionName.tokens)) {
                        String[] col = this.getDetails(tok);
                        this.collections.put(col[0], col[1]);
                        continue;
                    }
                    if (!tok.contains(SearchAndBrowseTokens.term.tokens)) continue;
                    this.term = this.getValue(tok);
                }
                break;
            }
            case 2: 
            case 3: {
                this.collections = new HashMap();
                this.terms = new HashMap();
                StringTokenizer tokenizer = new StringTokenizer(this.message, messageTokensSeparator);
                while (tokenizer.hasMoreElements()) {
                    String tok = tokenizer.nextToken();
                    if (tok.contains(SearchAndBrowseTokens.collectionName.tokens)) {
                        String[] col = this.getDetails(tok);
                        this.collections.put(col[0], col[1]);
                        continue;
                    }
                    if (tok.contains(SearchAndBrowseTokens.term.tokens)) {
                        String[] term = this.getDetails(tok);
                        this.terms.put(term[1], term[0]);
                        continue;
                    }
                    if (tok.contains(SearchAndBrowseTokens.Browse_by.tokens)) {
                        this.browseBy = this.getValue(tok);
                        continue;
                    }
                    if (tok.contains(SearchAndBrowseTokens.DISTINCT.tokens)) {
                        this.isDistinct = Boolean.getBoolean(this.getValue(tok));
                        continue;
                    }
                    if (!tok.contains(SearchAndBrowseTokens.operator.tokens)) continue;
                    this.operator = this.getValue(tok);
                }
                break;
            }
            case 4: {
                StringTokenizer tokenizer = new StringTokenizer(this.message, messageTokensSeparator);
                while (tokenizer.hasMoreElements()) {
                    String tok = tokenizer.nextToken();
                    if (tok.contains(RetrieveContentTokens.contentID.tokens)) {
                        this.content[0] = this.getValue(tok);
                        continue;
                    }
                    if (!tok.contains(RetrieveContentTokens.contentName.tokens)) continue;
                    this.content[1] = this.getValue(tok);
                }
                break;
            }
            case 5: 
            case 6: {
                StringTokenizer tokenizer = new StringTokenizer(this.message, messageTokensSeparator);
                while (tokenizer.hasMoreElements()) {
                    String tok = tokenizer.nextToken();
                    if (!tok.contains(SearchAndBrowseTokens.term.tokens)) continue;
                    this.term = this.getValue(tok);
                }
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                StringTokenizer tokenizer = new StringTokenizer(this.message, messageTokensSeparator);
                while (tokenizer.hasMoreElements()) {
                    String tok = tokenizer.nextToken();
                    if (tok.contains(HLTokens.ID.tokens)) {
                        this.hlentry[0] = this.getValue(tok);
                        continue;
                    }
                    if (tok.contains(HLTokens.NAME.tokens)) {
                        this.hlentry[1] = this.getValue(tok);
                        continue;
                    }
                    if (!tok.contains(HLTokens.TYPE.tokens)) continue;
                    this.hlentry[2] = this.getValue(tok);
                }
                break;
            }
            case 10: {
                StringTokenizer tokenizer = new StringTokenizer(this.message, messageTokensSeparator);
                while (tokenizer.hasMoreElements()) {
                    String tok = tokenizer.nextToken();
                    if (tok.contains(HLTokens.ID.tokens)) {
                        this.hlentry[0] = this.getValue(tok);
                        continue;
                    }
                    if (tok.contains(HLTokens.NAME.tokens)) {
                        this.hlentry[1] = this.getValue(tok);
                        continue;
                    }
                    if (tok.contains(HLTokens.TYPE.tokens)) {
                        this.hlentry[2] = this.getValue(tok);
                        continue;
                    }
                    if (!tok.contains(HLTokens.ADDRESSEES.tokens)) continue;
                    this.addresseeUsers = this.getAddresseesUser(tok);
                }
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                StringTokenizer tokenizer = new StringTokenizer(this.message, messageTokensSeparator);
                while (tokenizer.hasMoreElements()) {
                    String tok = tokenizer.nextToken();
                    if (tok.contains(AISTokens.ID.tokens)) {
                        this.aisentry[0] = this.getValue(tok);
                        continue;
                    }
                    if (!tok.contains(AISTokens.NAME.tokens)) continue;
                    this.aisentry[1] = this.getValue(tok);
                }
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                StringTokenizer tokenizer = new StringTokenizer(this.message, messageTokensSeparator);
                while (tokenizer.hasMoreElements()) {
                    String tok = tokenizer.nextToken();
                    if (!tok.contains(TSTokens.TITLE.tokens)) continue;
                    this.tstitle = this.getValue(tok);
                }
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                StringTokenizer tokenizer = new StringTokenizer(this.message, messageTokensSeparator);
                while (tokenizer.hasMoreElements()) {
                    String tok = tokenizer.nextToken();
                    if (tok.contains(AnnotationTokens.annotationType.tokens)) {
                        this.annotationEntry[0] = this.getValue(tok);
                        continue;
                    }
                    if (tok.contains(AnnotationTokens.annotationName.tokens)) {
                        this.annotationEntry[1] = this.getValue(tok);
                        continue;
                    }
                    if (tok.contains(AnnotationTokens.objectID.tokens)) {
                        this.annotationEntry[2] = this.getValue(tok);
                        continue;
                    }
                    if (!tok.contains(AnnotationTokens.objectName.tokens)) continue;
                    this.annotationEntry[3] = this.getValue(tok);
                }
                break;
            }
            case 22: 
            case 23: {
                StringTokenizer tokenizer = new StringTokenizer(this.message, messageTokensSeparator);
                while (tokenizer.hasMoreElements()) {
                    String tok = tokenizer.nextToken();
                    if (tok.contains(WorkflowDocumentTokens.WORKFLOWID.tokens)) {
                        this.workflowDocumentsEntry[0] = this.getValue(tok);
                        continue;
                    }
                    if (tok.contains(WorkflowDocumentTokens.WorkflowDocuementName.tokens)) {
                        this.workflowDocumentsEntry[1] = this.getValue(tok);
                        continue;
                    }
                    if (tok.contains(WorkflowDocumentTokens.STATUS.tokens)) {
                        this.workflowDocumentsEntry[2] = this.getValue(tok);
                        continue;
                    }
                    if (!tok.contains(WorkflowDocumentTokens.STEPS_NO.tokens)) continue;
                    this.workflowDocumentsEntry[2] = this.getValue(tok);
                }
                break;
            }
            case 24: 
            case 25: {
                StringTokenizer tokenizer = new StringTokenizer(this.message, messageTokensSeparator);
                while (tokenizer.hasMoreElements()) {
                    String tok = tokenizer.nextToken();
                    if (tok.contains(ReportTokens.ID.tokens)) {
                        this.reportEntry[0] = this.getValue(tok);
                        continue;
                    }
                    if (!tok.contains(ReportTokens.Name.tokens)) continue;
                    this.reportEntry[1] = this.getValue(tok);
                }
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                StringTokenizer tokenizer = new StringTokenizer(this.message, messageTokensSeparator);
                while (tokenizer.hasMoreElements()) {
                    String tok = tokenizer.nextToken();
                    if (tok.contains(ReportTokens.ID.tokens)) {
                        this.reportEntry[0] = this.getValue(tok);
                        continue;
                    }
                    if (tok.contains(ReportTokens.Name.tokens)) {
                        this.reportEntry[1] = this.getValue(tok);
                        continue;
                    }
                    if (!tok.contains(ReportTokens.AUTHOR.tokens)) continue;
                    this.reportEntry[2] = this.getValue(tok);
                }
                break;
            }
            case 30: {
                StringTokenizer tokenizer = new StringTokenizer(this.message, messageTokensSeparator);
                while (tokenizer.hasMoreElements()) {
                    String tok = tokenizer.nextToken();
                    if (tok.contains(ReportTokens.Name.tokens)) {
                        this.reportEntry[0] = this.getValue(tok);
                        continue;
                    }
                    if (tok.contains(ReportTokens.MIMETYPE.tokens)) {
                        this.reportEntry[1] = this.getValue(tok);
                        continue;
                    }
                    if (!tok.contains(ReportTokens.TYPE.tokens)) continue;
                    this.reportEntry[2] = this.getValue(tok);
                }
                break;
            }
            case 31: 
            case 32: {
                StringTokenizer tokenizer = new StringTokenizer(this.message, messageTokensSeparator);
                while (tokenizer.hasMoreElements()) {
                    String tok = tokenizer.nextToken();
                    if (tok.contains(WebAppTokens.ID.tokens)) {
                        this.webAppEntry[0] = this.getValue(tok);
                        continue;
                    }
                    if (tok.contains(WebAppTokens.NAME.tokens)) {
                        this.webAppEntry[1] = this.getValue(tok);
                        continue;
                    }
                    if (tok.contains(WebAppTokens.VERSION.tokens)) {
                        this.webAppEntry[2] = this.getValue(tok);
                        continue;
                    }
                    if (tok.contains(WebAppTokens.GHN_ID.tokens)) {
                        this.webAppEntry[3] = this.getValue(tok);
                        continue;
                    }
                    if (!tok.contains(WebAppTokens.GHN_NAME.tokens)) continue;
                    this.webAppEntry[4] = this.getValue(tok);
                }
                break;
            }
            case 33: {
                StringTokenizer tokenizer = new StringTokenizer(this.message, messageTokensSeparator);
                while (tokenizer.hasMoreElements()) {
                    String tok = tokenizer.nextToken();
                    if (tok.contains(WebAppTokens.GHN_ID.tokens)) {
                        this.webAppEntry[0] = this.getValue(tok);
                        continue;
                    }
                    if (tok.contains(WebAppTokens.GHN_NAME.tokens)) {
                        this.webAppEntry[1] = this.getValue(tok);
                        continue;
                    }
                    if (!tok.contains(WebAppTokens.APPLICATIONS.tokens)) continue;
                    this.listApplication = this.getApplications(tok);
                }
                break;
            }
            case 34: {
                StringTokenizer tokenizer = new StringTokenizer(this.message, messageTokensSeparator);
                while (tokenizer.hasMoreElements()) {
                    String tok = tokenizer.nextToken();
                    if (!tok.contains(WebAppTokens.APPLICATIONS.tokens)) continue;
                    this.listApplication = this.getApplications(tok);
                    this.listGHN = this.getGHN(tok);
                }
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                StringTokenizer tokenizer = new StringTokenizer(this.message, messageTokensSeparator);
                while (tokenizer.hasMoreElements()) {
                    String tok = tokenizer.nextToken();
                    if (tok.contains(WarTokens.ID.tokens)) {
                        this.warEntry[0] = this.getValue(tok);
                        continue;
                    }
                    if (tok.contains(WarTokens.APPLICATION_NAME.tokens)) {
                        this.warEntry[1] = this.getValue(tok);
                        continue;
                    }
                    if (tok.contains(WarTokens.APPLICATION_VERSION.tokens)) {
                        this.warEntry[2] = this.getValue(tok);
                        continue;
                    }
                    if (tok.contains(WarTokens.CATEGORY_NAME.tokens)) {
                        this.warEntry[3] = this.getValue(tok);
                        continue;
                    }
                    if (!tok.contains(WarTokens.NAME.tokens)) continue;
                    this.warEntry[4] = this.getValue(tok);
                }
                break;
            }
            case 38: 
            case 39: {
                StringTokenizer tokenizer = new StringTokenizer(this.message, messageTokensSeparator);
                while (tokenizer.hasMoreElements()) {
                    String tok = tokenizer.nextToken();
                    if (tok.contains(AquamapsTokens.TITLE.tokens)) {
                        this.aquamapsEntry[0] = this.getValue(tok);
                        continue;
                    }
                    if (tok.contains(AquamapsTokens.TYPE.tokens)) {
                        this.aquamapsEntry[1] = this.getValue(tok);
                        continue;
                    }
                    if (tok.contains(AquamapsTokens.GIS.tokens)) {
                        this.aquamapsEntry[2] = this.getValue(tok);
                        continue;
                    }
                    if (tok.contains(AquamapsTokens.SPECIES_COUNT.tokens)) {
                        this.aquamapsEntry[3] = this.getValue(tok);
                        continue;
                    }
                    if (tok.contains(AquamapsTokens.HSPEC.tokens)) {
                        this.aquamapsEntry[4] = this.getValue(tok);
                        continue;
                    }
                    if (!tok.contains(AquamapsTokens.ID.tokens)) continue;
                    this.aquamapsEntry[4] = this.getValue(tok);
                }
                break;
            }
        }
    }

    public String[] getAquamapsEntry() {
        return this.aquamapsEntry;
    }

    public void setAquamapsEntry(String[] aquamapsEntry) {
        this.aquamapsEntry = aquamapsEntry;
    }

    public String[] getReportEntry() {
        return this.reportEntry;
    }

    public void setReportEntry(String[] reportEntry) {
        this.reportEntry = reportEntry;
    }

    private ArrayList<HLRecord.GCUBEUser> getAddresseesUser(String line) {
        ArrayList<HLRecord.GCUBEUser> users = new ArrayList<HLRecord.GCUBEUser>();
        String userString = line.substring(line.indexOf("=") + 1).trim();
        StringTokenizer tokenizer = new StringTokenizer(userString, hlAddresssesSeparator);
        while (tokenizer.hasMoreElements()) {
            String tok = tokenizer.nextToken();
            HLRecord.GCUBEUser user = new HLRecord.GCUBEUser(new HLRecord());
            user.setUser(tok.substring(0, tok.indexOf(hlAddresssesSeparator2)));
            user.setVre(tok.substring(tok.indexOf(hlAddresssesSeparator2) + 1));
            users.add(user);
        }
        return users;
    }

    private ArrayList<WebAppRecord.GHN> getGHN(String line) {
        ArrayList<WebAppRecord.GHN> ghns = new ArrayList<WebAppRecord.GHN>();
        String ghnString = line.substring(line.indexOf("=") + 1).trim();
        StringTokenizer tokenizer = new StringTokenizer(ghnString, hlAddresssesSeparator);
        while (tokenizer.hasMoreElements()) {
            String tok = tokenizer.nextToken();
            WebAppRecord.GHN ghn = new WebAppRecord.GHN(new WebAppRecord());
            ghn.setGHN_ID(tok.substring(0, tok.indexOf(hlAddresssesSeparator2)));
            ghn.setGHN_NAME(tok.substring(tok.indexOf(hlAddresssesSeparator2) + 1));
            ghns.add(ghn);
        }
        return ghns;
    }

    private ArrayList<WebAppRecord.WebApplication> getApplications(String line) {
        ArrayList<WebAppRecord.WebApplication> webApps = new ArrayList<WebAppRecord.WebApplication>();
        String ghnString = line.substring(line.indexOf("=") + 1).trim();
        StringTokenizer tokenizer = new StringTokenizer(ghnString, hlAddresssesSeparator);
        while (tokenizer.hasMoreElements()) {
            String tok = tokenizer.nextToken();
            WebAppRecord.WebApplication webApp = new WebAppRecord.WebApplication(new WebAppRecord());
            if (tok.contains(WebAppTokens.ID.tokens)) {
                webApp.setWEB_APPLICATION_ID(this.getValue(tok));
            } else if (tok.contains(WebAppTokens.NAME.tokens)) {
                webApp.setWEB_APPLICATION_NAME(this.getValue(tok));
            } else if (tok.contains(WebAppTokens.VERSION.tokens)) {
                webApp.setWEB_APPLICATION_NAME(this.getValue(tok));
            }
            webApps.add(webApp);
        }
        return webApps;
    }

    private String[] getDetails(String token) {
        String[] col = new String[2];
        String nameString = token.substring(0, token.indexOf(OperatorType.AND.operator));
        String idString = token.substring(token.indexOf(OperatorType.AND.operator) + OperatorType.AND.operator.length() + 1);
        col[0] = idString.substring(idString.indexOf("=") + 1).trim();
        col[1] = nameString.substring(nameString.indexOf("=") + 1).trim();
        return col;
    }

    private String getValue(String token) {
        return token.substring(token.indexOf("=") + 1).trim();
    }

    public String[] getWorkflowDocumentsEntry() {
        return this.workflowDocumentsEntry;
    }

    public void setWorkflowDocumentsEntry(String[] workflowDocumentsEntry) {
        this.workflowDocumentsEntry = workflowDocumentsEntry;
    }

    public String toString() {
        return this.message;
    }

    public HashMap<String, String> getCollections() {
        return this.collections;
    }

    public void setCollections(HashMap<String, String> collections) {
        this.collections = collections;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getTerm() {
        return this.term;
    }

    public void setTerm(String term) {
        this.term = term;
    }

    public HashMap<String, String> getTerms() {
        return this.terms;
    }

    public void setTerms(HashMap<String, String> terms) {
        this.terms = terms;
    }

    public AccessLogParser.EntryType getType() {
        return this.type;
    }

    public void setType(AccessLogParser.EntryType type) {
        this.type = type;
    }

    public String getBrowseBy() {
        return this.browseBy;
    }

    public void setBrowseBy(String browseBy) {
        this.browseBy = browseBy;
    }

    public boolean isDistinct() {
        return this.isDistinct;
    }

    public void setDistinct(boolean isDistinct) {
        this.isDistinct = isDistinct;
    }

    public String getOperator() {
        return this.operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public String[] getContent() {
        return this.content;
    }

    public void setContent(String[] content) {
        this.content = content;
    }

    public String[] getHlentry() {
        return this.hlentry;
    }

    public void setHlentry(String[] hlentry) {
        this.hlentry = hlentry;
    }

    public ArrayList<HLRecord.GCUBEUser> getAddresseeUsers() {
        return this.addresseeUsers;
    }

    public void setAddresseeUsers(ArrayList<HLRecord.GCUBEUser> addresseeUsers) {
        this.addresseeUsers = addresseeUsers;
    }

    public static String getMessagetokensseparator() {
        return messageTokensSeparator;
    }

    public String[] getAisentry() {
        return this.aisentry;
    }

    public void setAisentry(String[] aisentry) {
        this.aisentry = aisentry;
    }

    public String getTstitle() {
        return this.tstitle;
    }

    public void setTstitle(String tstitle) {
        this.tstitle = tstitle;
    }

    public String[] getAnnotationEntry() {
        return this.annotationEntry;
    }

    public void setAnnotationEntry(String[] annotationEntry) {
        this.annotationEntry = annotationEntry;
    }

    public String[] getWebAppEntry() {
        return this.webAppEntry;
    }

    public void setWebAppEntry(String[] webAppEntry) {
        this.webAppEntry = webAppEntry;
    }

    public ArrayList<WebAppRecord.GHN> getListGHN() {
        return this.listGHN;
    }

    public void setListGHN(ArrayList<WebAppRecord.GHN> listGHN) {
        this.listGHN = listGHN;
    }

    public ArrayList<WebAppRecord.WebApplication> getListApplication() {
        return this.listApplication;
    }

    public void setListApplication(ArrayList<WebAppRecord.WebApplication> listApplication) {
        this.listApplication = listApplication;
    }

    public String[] getWarEntry() {
        return this.warEntry;
    }

    public void setWarEntry(String[] warEntry) {
        this.warEntry = warEntry;
    }
}

