/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.environments.administration;

import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.ORule;
import com.orientechnologies.orient.core.metadata.security.OSecurity;
import java.util.UUID;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.environments.Environment;
import org.gcube.informationsystem.resourceregistry.environments.SystemEnvironment;
import org.gcube.informationsystem.resourceregistry.environments.administration.AdminEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminEnvironment
extends SystemEnvironment {
    private static Logger logger = LoggerFactory.getLogger(Environment.class);
    private static final String ADMIN_SECURITY_CONTEXT = "00000000-0000-0000-0000-000000000000";
    private static final UUID ADMIN_SECURITY_CONTEXT_UUID = UUID.fromString(ADMIN_SECURITY_CONTEXT);
    private static AdminEnvironment instance;

    public static AdminEnvironment getInstance() throws ResourceRegistryException {
        if (instance == null) {
            instance = new AdminEnvironment();
        }
        return instance;
    }

    private AdminEnvironment() throws ResourceRegistryException {
        super(ADMIN_SECURITY_CONTEXT_UUID);
    }

    public void create() {
        throw new RuntimeException("Cannot use this method for Admin Context");
    }

    protected ORole getSuperRole(OSecurity oSecurity, Environment.PermissionMode permissionMode) {
        return oSecurity.getRole("admin");
    }

    protected ORole addExtraRules(ORole role, Environment.PermissionMode permissionMode) {
        logger.trace("Adding extra rules for {}", (Object)role.getName());
        switch (1.$SwitchMap$org$gcube$informationsystem$resourceregistry$environments$Environment$PermissionMode[permissionMode.ordinal()]) {
            case 1: {
                role.addRule(ORule.ResourceGeneric.BYPASS_RESTRICTED, null, ORole.PERMISSION_ALL);
                break;
            }
            case 2: {
                role.addRule(ORule.ResourceGeneric.BYPASS_RESTRICTED, null, ORole.PERMISSION_READ);
                break;
            }
        }
        return role;
    }
}

