/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.rest;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.enums.ParameterIn;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.Content;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameters;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponses;
import org.eclipse.microprofile.openapi.annotations.tags.Tag;
import org.gcube.informationsystem.resourceregistry.api.exceptions.NotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.queries.InvalidQueryException;
import org.gcube.informationsystem.resourceregistry.queries.templates.QueryTemplateManagement;
import org.gcube.informationsystem.resourceregistry.rest.BaseRest;
import org.gcube.informationsystem.resourceregistry.rest.Method;
import org.gcube.informationsystem.resourceregistry.rest.requests.ServerRequestInfo;

@Path(value="query-templates")
@Tag(name="Query Templates", description="Operations for managing query templates in the Resource Registry.")
public class QueryTemplateManager
extends BaseRest {
    public static final String QUERY_TEMPLATE_NAME_PATH_PARAMETER = "query-template-name";

    @GET
    @Consumes(value={"text/plain", "application/json;charset=UTF-8"})
    @Produces(value={"application/json;charset=UTF-8"})
    @Operation(summary="List Query Templates", description="Retrieves all query templates from the Resource Registry.\n\nThe response can include metadata and provides pagination based on query parameters and user authorization.\n\n\n**Request Examples:**\n- GET /query-templates;\n- GET /query-templates?limit=20&offset=40;\n- GET /query-templates?includeMeta=true;\n- GET /query-templates?limit=15&offset=30&includeMeta=true.\n\n\n**Authorization Requirements:**\n- **IS-Manager:**\n\t- Full access to all query templates;\n\t- Can access query templates across all contexts;\n\t- Receives complete, unfiltered metadata including all administrative fields.\n\n- **Infrastructure-Manager:**\n\t- Full access to all query templates;\n\t- Can access query templates across all contexts;\n\t- Receives complete, unfiltered metadata including all administrative fields.\n\n- **Other Users:**\n\t- Basic access with metadata filtering;\n\t- Receive metadata with sensitive information filtered when includeMeta=true.\n")
    @Parameters(value={@Parameter(name="limit", in=ParameterIn.QUERY, description="Maximum number of query templates to return in a single response.\n- Default: 10;\n- Example: ?limit=50 (returns at most 50 query templates).\n", required=false, schema=@Schema(type=SchemaType.INTEGER, defaultValue="10", example="10")), @Parameter(name="offset", in=ParameterIn.QUERY, description="Number of query templates to skip from the beginning of the result set.\n- Default: 0 (starts from the first query template);\n- Example: ?offset=100 (skips the first 100 query templates).\n", required=false, schema=@Schema(type=SchemaType.INTEGER, defaultValue="0", example="0")), @Parameter(name="includeMeta", in=ParameterIn.QUERY, description="Whether to include metadata in the response query templates.\n- Default: false (basic information only);\n- Example: ?includeMeta=true (includes metadata with appropriate filtering based on user role);\n- Restriction: IS-Manager and Infrastructure-Manager see complete metadata including sensitive information (createdBy, lastUpdatedBy); other users see filtered metadata with sensitive fields obfuscated.\n", required=false, schema=@Schema(type=SchemaType.BOOLEAN, defaultValue="false", example="false"))})
    @APIResponses(value={@APIResponse(responseCode="200", description="Query templates successfully retrieved", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="400", description="Invalid query parameters (e.g., invalid limit/offset values)"), @APIResponse(responseCode="403", description="Insufficient permissions to access query templates")})
    public String all() throws NotFoundException, ResourceRegistryException {
        this.logger.info("Requested to read all {}s", (Object)"QueryTemplate");
        this.setAccountingMethod(Method.LIST, "QueryTemplate");
        ServerRequestInfo serverRequestInfo = this.initRequestInfo();
        serverRequestInfo.setAllMeta(true);
        serverRequestInfo.checkBooleanQueryParameter("includeMeta");
        serverRequestInfo.checkLimitOffset();
        QueryTemplateManagement queryTemplateManagement = new QueryTemplateManagement();
        return queryTemplateManagement.all(false);
    }

    @PUT
    @Path(value="{query-template-name}")
    @Consumes(value={"text/plain", "application/json;charset=UTF-8"})
    @Produces(value={"application/json;charset=UTF-8"})
    @Operation(summary="Create or Update Query Template", description="Creates a new query template or updates an existing query template with the specified name in the Resource Registry.\n\n\n**Request Examples:**\n- PUT /query-templates/GetAllEServiceWithState;\n- PUT /query-templates/GetAllEServiceWithState?includeMeta=true.\n\n\n**Authorization Requirements:**\n- **IS-Manager:**\n\t- Full access to create/update any query template;\n\t- Can create/update query templates across all contexts;\n\t- Receives complete, unfiltered metadata including all administrative fields in the response.\n\n- **Infrastructure-Manager:**\n\t- Full access to create/update any query template;\n\t- Can create/update query templates across all contexts;\n\t- Receives complete, unfiltered metadata including all administrative fields in the response.\n\n- **Other Users:**\n\t- Limited create/update permissions based on context access;\n\t- Receive metadata with sensitive information filtered when includeMeta=true.\n\n\n**Operation Behavior:**\n- **Create**: If the query template with the specified name does not exist, creates a new query template;\n- **Update**: If the query template with the specified name exists, updates the existing query template;\n- **Name Validation**: The path parameter **query-template-name** must exactly match the \"name\" field in the JSON body;\n- **Query Validation**: The template query is automatically tested during creation/update;\n- **Parameter Declaration**: Every parameter used in the query (prefixed with $) must have a corresponding declaration in templateVariables;\n- **Default Value Substitution**: During validation, parameters are replaced with their default values before executing the query;\n- **Valid Default Values**: Default values must be valid for the query execution - the query must be able to run on the system;\n- **Result Independence**: The query doesn't need to return results during validation (empty results are acceptable), but it must execute without errors;\n- The operation is idempotent and atomic.\n")
    @Parameter(name="includeMeta", in=ParameterIn.QUERY, description="Whether to include metadata in the response query template.\n- Default: false (basic information only);\n- Values: true|false;\n- Example: ?includeMeta=true (includes metadata with appropriate filtering based on user role);\n- Restriction: IS-Manager and Infrastructure-Manager see complete metadata including sensitive information (createdBy, lastUpdatedBy); other users see filtered metadata with sensitive fields obfuscated.\n", required=false, schema=@Schema(type=SchemaType.BOOLEAN, defaultValue="false", example="false"))
    @APIResponses(value={@APIResponse(responseCode="200", description="Query template successfully updated (existing template modified)", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="201", description="Query template successfully created (new template)", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="400", description="Invalid request body, malformed JSON, or path parameter name does not match JSON name field"), @APIResponse(responseCode="403", description="Insufficient permissions to create/update the query template")})
    public String updateCreate(@PathParam(value="query-template-name") @Parameter(name="query-template-name", in=ParameterIn.PATH, description="The name of the query template to create or update.\n- Must match the \"name\" field in the JSON body (e.g., \"GetAllEServiceWithState\");\n- Important: This name must exactly match the \"name\" field in the JSON body, otherwise a 400 Bad Request error will be returned.\n", required=true, schema=@Schema(type=SchemaType.STRING, example="GetAllEServiceWithState")) String queryTemplateName, String json) throws InvalidQueryException, ResourceRegistryException {
        this.logger.info("Requested {} creation with name {} and content {}", new Object[]{"QueryTemplate", queryTemplateName, json});
        this.setAccountingMethod(Method.UPDATE, "QueryTemplate");
        ServerRequestInfo serverRequestInfo = this.initRequestInfo();
        serverRequestInfo.setAllMeta(true);
        serverRequestInfo.checkBooleanQueryParameter("includeMeta");
        QueryTemplateManagement queryTemplateManagement = new QueryTemplateManagement();
        queryTemplateManagement.setName(queryTemplateName);
        queryTemplateManagement.setJson(json);
        return queryTemplateManagement.createOrUpdate();
    }

    @GET
    @Path(value="{query-template-name}")
    @Produces(value={"application/json;charset=UTF-8"})
    @Operation(summary="Read Query Template", description="Retrieves a specific query template by its name from the Resource Registry.\n\nThe response includes metadata based on query parameters and user authorization.\n\n\n**Request Examples:**\n- GET /query-templates/GetAllEServiceWithState;\n- GET /query-templates/GetAllEServiceWithState?includeMeta=true.\n\n\n**Authorization Requirements:**\n- **IS-Manager:**\n\t- Full access to retrieve any query template;\n\t- Can access query templates across all contexts;\n\t- Receives complete, unfiltered metadata including all administrative fields.\n\n- **Infrastructure-Manager:**\n\t- Full access to retrieve any query template;\n\t- Can access query templates across all contexts;\n\t- Receives complete, unfiltered metadata including all administrative fields.\n\n- **Other Users:**\n\t- Basic access with metadata filtering;\n\t- Receive metadata with sensitive information filtered when includeMeta=true.\n")
    @Parameter(name="includeMeta", in=ParameterIn.QUERY, description="Whether to include metadata in the response query template.\n- Default: false (basic information only);\n- Example: ?includeMeta=true (includes metadata with appropriate filtering based on user role);\n- Restriction: IS-Manager and Infrastructure-Manager see complete metadata including sensitive information (createdBy, lastUpdatedBy); other users see filtered metadata with sensitive fields obfuscated.\n", required=false, schema=@Schema(type=SchemaType.BOOLEAN, defaultValue="false", example="false"))
    @APIResponses(value={@APIResponse(responseCode="200", description="Query template successfully retrieved", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="404", description="Query template with the specified name does not exist"), @APIResponse(responseCode="403", description="Insufficient permissions to access the query template")})
    public String read(@PathParam(value="query-template-name") @Parameter(name="query-template-name", in=ParameterIn.PATH, description="The name of the query template to retrieve (e.g., \"GetAllEServiceWithState\")", required=true, schema=@Schema(type=SchemaType.STRING, example="GetAllEServiceWithState")) String queryTemplateName) throws NotFoundException, ResourceRegistryException {
        this.logger.info("Requested {} with name", (Object)"QueryTemplate", (Object)queryTemplateName);
        this.setAccountingMethod(Method.READ, "QueryTemplate");
        ServerRequestInfo serverRequestInfo = this.initRequestInfo();
        serverRequestInfo.setAllMeta(true);
        serverRequestInfo.checkBooleanQueryParameter("includeMeta");
        QueryTemplateManagement queryTemplateManagement = new QueryTemplateManagement();
        queryTemplateManagement.setName(queryTemplateName);
        return queryTemplateManagement.read();
    }

    @POST
    @Path(value="{query-template-name}")
    @Produces(value={"application/json;charset=UTF-8"})
    @Operation(summary="Execute Query Template", description="Executes a query template with the specified name and parameters in the Resource Registry.\n\n\n**Request Examples:**\n- POST /query-templates/GetAllEServiceWithState;\n- POST /query-templates/GetAllEServiceWithState?polymorphic=false;\n- POST /query-templates/GetAllEServiceWithState?includeMeta=true;\n- POST /query-templates/GetAllEServiceWithState?hierarchical=true;\n- POST /query-templates/GetAllEServiceWithState?includeMeta=true&allMeta=true;\n- POST /query-templates/GetAllEServiceWithState?includeContexts=true.\n\n\n**Authorization Requirements:**\n- **IS-Manager:**\n\t- Full access to execute any query template;\n\t- Can use hierarchical querying across all contexts;\n\t- Receives complete, unfiltered metadata including all administrative fields.\n\n- **Infrastructure-Manager:**\n\t- Full access to execute any query template;\n\t- Can use hierarchical querying across all contexts;\n\t- Receives complete, unfiltered metadata including all administrative fields.\n\n- **Context-Manager:**\n\t- Can execute query templates with hierarchical querying within their managed context hierarchy;\n\t- Must be Context-Manager of the current context (derived from the authorization token);\n\t- Receives complete, unfiltered metadata including all administrative fields.\n\n- **Other Users:**\n\t- Can execute query templates in the current context only;\n\t- Cannot use hierarchical querying (hierarchical parameter ignored);\n\t- Receive metadata with sensitive information filtered when includeMeta=true.\n\n\n**Operation Behavior:**\n- **Parameter Substitution**: Parameters in the template query (prefixed with $) are replaced with values from the request body;\n- **Default Values**: Parameters not provided in the request body use their default values from the template definition;\n- **Query Execution**: The resulting query is executed against the Resource Registry;\n- **Response Type**: Can return complete instances or individual fields (when using _emit in the query);\n- **Metadata Effect**: includeMeta, allMeta, and includeContexts only affect queries returning complete instances, not _emit queries;\n- **Polymorphic Behavior**: When disabled (polymorphic=false), may impact query performance but ensures exact type matching;\n- **No Pagination**: Pagination is not currently supported for query template execution.\n")
    @Parameters(value={@Parameter(name="polymorphic", in=ParameterIn.QUERY, description="Whether the query should consider instances polymorphically (include subtypes).\n- Default: true (includes all subtypes);\n- Values: true|false;\n- Example: ?polymorphic=false (exact type match only, may slow down the query);\n- When false, only instances of the exact types defined in the query are returned;\n- When true, instances of derived types are also included.\n", required=false, schema=@Schema(type=SchemaType.BOOLEAN, defaultValue="true", example="true")), @Parameter(name="includeMeta", in=ParameterIn.QUERY, description="Whether to include metadata in the response instances.\n- Default: false (basic information only);\n- Values: true|false;\n- Example: ?includeMeta=true (includes metadata with appropriate filtering based on user role);\n- Effect: Only applies when query returns complete instances of defined types;\n- No Effect: When query uses _emit to return individual fields instead of complete instances;\n- Restriction: IS-Manager and Infrastructure-Manager see complete metadata; other users see filtered metadata with sensitive fields obfuscated.\n", required=false, schema=@Schema(type=SchemaType.BOOLEAN, defaultValue="false", example="false")), @Parameter(name="allMeta", in=ParameterIn.QUERY, description="Whether to include metadata for all nested instances (ConsistsOf relations, Facets, etc.).\n- Must be used in conjunction with includeMeta=true;\n- Default: false (metadata only for main instances, more human-readable);\n- Values: true|false;\n- Example: ?includeMeta=true&allMeta=true (includes metadata for all nested elements);\n- Effect: Only applies when query returns complete instances of defined types;\n- No Effect: When query uses _emit to return individual fields instead of complete instances.\n", required=false, schema=@Schema(type=SchemaType.BOOLEAN, defaultValue="false", example="false")), @Parameter(name="hierarchical", in=ParameterIn.QUERY, description="Whether to execute the query across child contexts of the current context.\n- Default: false (current context only);\n- Values: true|false;\n- Restriction: Only available to IS-Manager, Infrastructure-Manager, and Context-Manager roles (Context-Manager must be of the current context derived from the authorization token);\n- Example: ?hierarchical=true (executes query in current and child contexts);\n- Current context is determined from the authorization token.\n", required=false, schema=@Schema(type=SchemaType.BOOLEAN, defaultValue="false", example="false")), @Parameter(name="includeContexts", in=ParameterIn.QUERY, description="Whether to include the list of contexts where each returned instance is available.\n- Default: false (context information not included);\n- Values: true|false;\n- Example: ?includeContexts=true (shows context availability for each instance);\n- Effect: Only applies when query returns complete instances of defined types;\n- No Effect: When query uses _emit to return individual fields instead of complete instances;\n- Note: A Resource is present in all contexts that form the union of contexts of all its Facets.\n", required=false, schema=@Schema(type=SchemaType.BOOLEAN, defaultValue="false", example="false"))})
    @APIResponses(value={@APIResponse(responseCode="200", description="Query template successfully executed", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="400", description="Invalid query parameters or malformed parameter values"), @APIResponse(responseCode="404", description="Query template with the specified name does not exist"), @APIResponse(responseCode="403", description="Insufficient permissions to execute the query template")})
    public String run(@PathParam(value="query-template-name") @Parameter(name="query-template-name", in=ParameterIn.PATH, description="The name of the query template to execute (e.g., \"GetAllEServiceWithState\")", required=true, schema=@Schema(type=SchemaType.STRING, example="GetAllEServiceWithState")) String queryTemplateName, String params) throws NotFoundException, InvalidQueryException, ResourceRegistryException {
        this.logger.info("Requested {} with name", (Object)"QueryTemplate", (Object)queryTemplateName);
        this.setAccountingMethod(Method.RUN, "QueryTemplate");
        ServerRequestInfo serverRequestInfo = this.initRequestInfo();
        serverRequestInfo.checkAllBooleanQueryParameters();
        QueryTemplateManagement queryTemplateManagement = new QueryTemplateManagement();
        queryTemplateManagement.setName(queryTemplateName);
        queryTemplateManagement.setParams(params);
        return queryTemplateManagement.run();
    }

    @DELETE
    @Consumes(value={"text/plain", "application/json;charset=UTF-8"})
    @Path(value="{query-template-name}")
    @Operation(summary="Delete Query Template", description="Deletes a query template with the specified name from the Resource Registry.\n\n\n**IMPORTANT: This is an irreversible operation that permanently removes the query template from the system.**\n\n\n**Request Examples:**\n- DELETE /query-templates/GetAllEServiceWithState.\n\n\n**Authorization Requirements:**\n- **IS-Manager:**\n\t- Full access to delete any query template;\n\t- Can delete query templates across all contexts.\n\n- **Infrastructure-Manager:**\n\t- Full access to delete any query template;\n\t- Can delete query templates across all contexts.\n\n- **Other Users:**\n\t- Basic access to delete query templates;\n\t- Same deletion permissions as administrative users.\n\n\n**Operation Behavior:**\n- **Permanent Deletion**: The query template is permanently removed from the system;\n- **Irreversible Operation**: This operation cannot be undone;\n- **Template Unavailability**: Once deleted, the query template name becomes available for reuse;\n- **Atomicity**: The operation is atomic - either the template is completely deleted or the operation fails.\n\n\n**Query Parameters:**\n- This endpoint does not accept any query parameters;\n- No filtering or metadata options are available for delete operations.\n")
    @APIResponses(value={@APIResponse(responseCode="204", description="Query template successfully deleted"), @APIResponse(responseCode="404", description="Query template with the specified name does not exist"), @APIResponse(responseCode="403", description="Insufficient permissions to delete the query template")})
    public Response delete(@PathParam(value="query-template-name") @Parameter(name="query-template-name", in=ParameterIn.PATH, description="The name of the query template to delete (e.g., \"GetAllEServiceWithState\")", required=true, schema=@Schema(type=SchemaType.STRING, example="GetAllEServiceWithState")) String queryTemplateName) throws NotFoundException, ResourceRegistryException {
        this.logger.info("Requested to delete {} with name {} ", (Object)"QueryTemplate", (Object)queryTemplateName);
        this.setAccountingMethod(Method.DELETE, "QueryTemplate");
        QueryTemplateManagement queryTemplateManagement = new QueryTemplateManagement();
        queryTemplateManagement.setName(queryTemplateName);
        queryTemplateManagement.delete();
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }
}

