/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.queries.operators;

import jakarta.ws.rs.BadRequestException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.com.fasterxml.jackson.databind.node.ArrayNode;
import org.gcube.com.fasterxml.jackson.databind.node.ObjectNode;
import org.gcube.com.fasterxml.jackson.databind.node.TextNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public enum MatemathicsOperator {
    SUM("_sum", "+", ""),
    MINUS("_minus", "-", ""),
    MULTIPLY("_multiply", "*", ""),
    DIVIDE("_divide", "/", ""),
    MODULE("_mod", "%", ""),
    BITWISE_RIGHT_SHIFT("_bitrshift", ">>", ""),
    BITWISE_LEFT_SHIFT("_bitlshift", "<<", ""),
    BITWISE_AND("_bitand", "&", ""),
    BITWISE_OR("_bitor", "|", ""),
    BITWISE_XOR("_bitxor", "^", ""),
    ARRAY_CONCATENATION("_arrayconcat", "||", "");

    protected static Logger logger;
    public static final String VALUES_KEY = "values";
    public static final String SEPARATOR_KEY = "separator";
    public static final String AS_KEY = "as";
    protected final String operatorKey;
    protected final String dbOperator;
    protected final String description;
    private static Set<String> operators;
    private static Map<String, MatemathicsOperator> operatorByKey;

    private MatemathicsOperator(String operatorKey, String dbOperator, String description) {
        this.operatorKey = operatorKey;
        this.dbOperator = dbOperator;
        this.description = description;
    }

    protected String getOperatorKey() {
        return this.operatorKey;
    }

    protected String getDbOperator() {
        return this.dbOperator;
    }

    public String getDescription() {
        return this.description;
    }

    public static Set<String> getOperators() {
        return operators;
    }

    public static MatemathicsOperator getOperator(String key) {
        return (MatemathicsOperator)operatorByKey.get(key);
    }

    protected String getError(String key, Class<?> clazz, boolean mandatory) {
        StringBuffer error = new StringBuffer();
        error.append("Root emitting MatemathicsOperator (i.e. ");
        error.append(this.operatorKey);
        error.append(")");
        error.append(" contains ");
        if (mandatory) {
            error.append("mandatory ");
        }
        error.append(key);
        error.append(" which must be a");
        error.append(clazz.getSimpleName());
        error.append(". This is a client error. Please fix your query");
        logger.error(error.toString());
        throw new BadRequestException(error.toString());
    }

    public String generateFieldToEmit(JsonNode jsonNode, String fieldPrefix) {
        JsonNode jn = jsonNode.get("values");
        if (jn.isNull() || !jn.isArray()) {
            this.getError("values", ArrayNode.class, true);
        }
        String fieldSeparator = null;
        if (this == SUM && jsonNode.has("separator")) {
            JsonNode sep = jsonNode.get("separator");
            if (!sep.isTextual()) {
                this.getError("separator", TextNode.class, false);
            }
            fieldSeparator = sep.asText();
        }
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        sb.append(this.generateFieldToEmit((ArrayNode)jn, fieldSeparator, fieldPrefix));
        JsonNode jnAs = jsonNode.get("as");
        if (jnAs.isNull() || !jnAs.isTextual()) {
            this.getError("as", TextNode.class, true);
        }
        sb.append(") AS `");
        sb.append(jnAs.asText());
        sb.append("`");
        return sb.toString();
    }

    protected StringBuffer addFieldPrefix(StringBuffer sb, String fieldPrefix) {
        if (fieldPrefix != null && fieldPrefix.trim().length() > 0) {
            sb.append(fieldPrefix.trim());
            sb.append(".");
        }
        return sb;
    }

    protected StringBuffer generateFieldToEmit(ArrayNode arrayNode, String fieldsSeparator, String fieldPrefix) {
        StringBuffer buffer = new StringBuffer();
        int size = arrayNode.size();
        for (int i = 0; i < size; ++i) {
            JsonNode jn = arrayNode.get(i);
            if (jn.isObject()) {
                ObjectNode on = (ObjectNode)jn;
                String key = (String)on.fieldNames().next();
                MatemathicsOperator mo = MatemathicsOperator.getOperator((String)key);
                ArrayNode an = (ArrayNode)on.get(key);
                buffer.append("(");
                buffer.append(mo.generateFieldToEmit(an, null, fieldPrefix));
                buffer.append(")");
            }
            if (jn.isTextual()) {
                buffer = this.addFieldPrefix(buffer, fieldPrefix);
                buffer.append(jn.asText());
            }
            if (i >= size - 1) continue;
            buffer.append(" ");
            buffer.append(this.dbOperator);
            buffer.append(" ");
            if (fieldsSeparator == null) continue;
            buffer.append("'");
            buffer.append(fieldsSeparator);
            buffer.append("' ");
            buffer.append(this.dbOperator);
            buffer.append(" ");
        }
        return buffer;
    }

    static {
        logger = LoggerFactory.getLogger(MatemathicsOperator.class);
        operators = new HashSet();
        operatorByKey = new HashMap();
        for (MatemathicsOperator matemathicsOperator : MatemathicsOperator.values()) {
            operators.add(matemathicsOperator.getOperatorKey());
            operatorByKey.put(matemathicsOperator.getOperatorKey(), matemathicsOperator);
        }
    }
}

