/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.contexts;

import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.record.ODirection;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.OVertex;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.UUID;
import org.gcube.common.security.ContextBean;
import org.gcube.common.security.providers.SecretManagerProvider;
import org.gcube.common.security.secrets.Secret;
import org.gcube.informationsystem.contexts.reference.entities.Context;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.contexts.ContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.contexts.ContextNotFoundException;
import org.gcube.informationsystem.resourceregistry.base.ElementManagementUtility;
import org.gcube.informationsystem.resourceregistry.contexts.ServerContextCache;
import org.gcube.informationsystem.resourceregistry.environments.Environment;
import org.gcube.informationsystem.resourceregistry.environments.HierarchicalEnvironment;
import org.gcube.informationsystem.resourceregistry.environments.administration.AdminEnvironment;
import org.gcube.informationsystem.resourceregistry.environments.instances.InstanceEnvironment;
import org.gcube.informationsystem.resourceregistry.utils.OrientDBUtility;
import org.gcube.informationsystem.resourceregistry.utils.UUIDUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ContextUtility {
    private static final Logger logger = LoggerFactory.getLogger(ContextUtility.class);
    private Map<UUID, InstanceEnvironment> contexts = new HashMap();
    private static ContextUtility contextUtility;

    public static ContextUtility getInstance() {
        if (contextUtility == null) {
            contextUtility = new ContextUtility();
        }
        return contextUtility;
    }

    private ContextUtility() {
    }

    public static String getCurrentContextFullName() {
        return SecretManagerProvider.get().getContext();
    }

    public static InstanceEnvironment getCurrentRequestEnvironment() throws ResourceRegistryException {
        String fullName = ContextUtility.getCurrentContextFullName();
        if (fullName == null) {
            throw new ContextException("Null Token and Scope. Please set your token first.");
        }
        return ContextUtility.getInstance().getRequestEnvironmentByContextFullName(fullName);
    }

    public static String getCurrentUserUsername() {
        Secret secret = SecretManagerProvider.get();
        return secret.getOwner().getId();
    }

    public synchronized void addInstanceEnvironment(InstanceEnvironment instanceEnvironment) {
        this.contexts.put(instanceEnvironment.getUUID(), instanceEnvironment);
    }

    public synchronized InstanceEnvironment getRequestEnvironmentByContextFullName(String fullName) throws ContextException {
        ODatabaseDocument current = ContextUtility.getCurrentODatabaseDocumentFromThreadLocal();
        ODatabaseDocument oDatabaseDocument = null;
        try {
            InstanceEnvironment instanceEnvironment = null;
            logger.trace("Trying to get {} for {}", (Object)InstanceEnvironment.class.getSimpleName(), (Object)fullName);
            UUID uuid = ServerContextCache.getInstance().getUUIDByFullName(fullName);
            if (uuid != null) {
                instanceEnvironment = (InstanceEnvironment)this.contexts.get(uuid);
            }
            if (instanceEnvironment == null) {
                logger.trace("{} for {} is not in cache. Going to get it", (Object)InstanceEnvironment.class.getSimpleName(), (Object)fullName);
                oDatabaseDocument = AdminEnvironment.getInstance().getDatabaseDocument(Environment.PermissionMode.READER);
                OVertex contextVertex = this.getContextVertexByFullName(oDatabaseDocument, fullName);
                uuid = UUIDUtility.getUUID((OElement)contextVertex);
                instanceEnvironment = this.getEnvironmentByUUID(uuid, contextVertex);
                this.addInstanceEnvironment(instanceEnvironment);
            }
            InstanceEnvironment instanceEnvironment2 = instanceEnvironment;
            return instanceEnvironment2;
        }
        catch (ContextException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ContextException("Unable to retrieve Context UUID from current Context", (Throwable)e);
        }
        finally {
            if (oDatabaseDocument != null) {
                oDatabaseDocument.close();
            }
            if (current != null) {
                current.activateOnCurrentThread();
            }
        }
    }

    public InstanceEnvironment getEnvironmentByUUID(UUID uuid) throws ResourceRegistryException {
        return this.getEnvironmentByUUID(uuid, null);
    }

    public static ODatabaseDocument getCurrentODatabaseDocumentFromThreadLocal() {
        ODatabaseDocumentInternal current = null;
        try {
            current = ODatabaseRecordThreadLocal.instance().get();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InstanceEnvironment getEnvironmentByUUID(UUID uuid, OVertex contextVertex) throws ResourceRegistryException {
        InstanceEnvironment instanceEnvironment = (InstanceEnvironment)this.contexts.get(uuid);
        if (instanceEnvironment == null) {
            instanceEnvironment = new InstanceEnvironment(uuid);
            ODatabaseDocument current = ContextUtility.getCurrentODatabaseDocumentFromThreadLocal();
            ODatabaseDocument oDatabaseDocument = null;
            try {
                OVertex parentVertex;
                if (contextVertex == null) {
                    oDatabaseDocument = AdminEnvironment.getInstance().getDatabaseDocument(Environment.PermissionMode.READER);
                    contextVertex = (OVertex)OrientDBUtility.getElementByUUID((ODatabaseDocument)oDatabaseDocument, (String)"Context", (UUID)uuid, OVertex.class);
                }
                if ((parentVertex = (OVertex)contextVertex.getVertices(ODirection.IN, new String[]{"IsParentOf"}).iterator().next()) != null) {
                    UUID parentUUID = UUIDUtility.getUUID((OElement)parentVertex);
                    instanceEnvironment.setParentEnvironment((HierarchicalEnvironment)this.getEnvironmentByUUID(parentUUID, parentVertex));
                }
            }
            catch (NoSuchElementException noSuchElementException) {
            }
            finally {
                if (oDatabaseDocument != null) {
                    oDatabaseDocument.close();
                }
                if (current != null) {
                    current.activateOnCurrentThread();
                }
            }
            this.contexts.put(uuid, instanceEnvironment);
        }
        return instanceEnvironment;
    }

    private OVertex getContextVertexByFullName(ODatabaseDocument oDatabaseDocument, String fullName) throws ResourceRegistryException {
        logger.trace("Going to get {} {} with full name '{}'", new Object[]{"Context", OVertex.class.getSimpleName(), fullName});
        ContextBean contexBean = new ContextBean(fullName);
        String name = contexBean.name();
        String select = "SELECT FROM " + Context.class.getSimpleName() + " WHERE name = :name";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", name);
        OResultSet resultSet = oDatabaseDocument.query(select, map);
        if (resultSet == null || !resultSet.hasNext()) {
            throw new ContextNotFoundException("Error retrieving context with name " + fullName);
        }
        OResult oResult = resultSet.next();
        OVertex context = (OVertex)ElementManagementUtility.getElementFromOptional((Optional)oResult.getVertex());
        logger.trace("Context Representing Vertex : {}", (Object)OrientDBUtility.getAsStringForLogging((ORecord)context));
        if (resultSet.hasNext()) {
            throw new ContextNotFoundException("Found more than one context with name " + name + "but required the one with path" + fullName + ". Please Reimplement the query");
        }
        return context;
    }
}

