/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.queries.templates;

import org.gcube.informationsystem.resourceregistry.api.rest.ServiceInstance;
import org.gcube.informationsystem.resourceregistry.queries.templates.ResourceRegistryQueryTemplateClient;
import org.gcube.informationsystem.resourceregistry.queries.templates.ResourceRegistryQueryTemplateClientImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceRegistryQueryTemplateClientFactory {
    private static final Logger logger = LoggerFactory.getLogger(ResourceRegistryQueryTemplateClientFactory.class);

    public static String getResourceRegistryURL() {
        String address = "%s/%s".formatted(ServiceInstance.getServiceURL(), "resource-registry");
        return address;
    }

    public static String getResourceRegistryURL(String context) {
        String address = "%s/%s".formatted(ServiceInstance.getServiceURL((String)context), "resource-registry");
        return address;
    }

    public static ResourceRegistryQueryTemplateClient create() {
        String address = ResourceRegistryQueryTemplateClientFactory.getResourceRegistryURL();
        logger.trace("The {} will be contacted at {}", (Object)"resource-registry", (Object)address);
        return new ResourceRegistryQueryTemplateClientImpl(address);
    }

    public static ResourceRegistryQueryTemplateClient create(String context) {
        String address = ResourceRegistryQueryTemplateClientFactory.getResourceRegistryURL(context);
        logger.trace("The {} will be contacted at {}", (Object)"resource-registry", (Object)address);
        return new ResourceRegistryQueryTemplateClientImpl(address);
    }
}

