/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.keycloak.storage.ldap.mappers;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.ModelException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.reflection.Property;
import org.keycloak.storage.ldap.LDAPStorageProvider;
import org.keycloak.storage.ldap.LDAPUtils;
import org.keycloak.storage.ldap.idm.model.LDAPObject;
import org.keycloak.storage.ldap.idm.query.internal.LDAPQuery;
import org.keycloak.storage.ldap.mappers.AbstractLDAPStorageMapper;

public class UserAttributeTemplatedLDAPStorageMapper
extends AbstractLDAPStorageMapper {
    private static final Logger logger = Logger.getLogger(UserAttributeTemplatedLDAPStorageMapper.class);
    private static final Map<String, Property<Object>> userModelProperties = LDAPUtils.getUserModelProperties();
    public static final String TEMPLATE_ATTRIBUTE = "template.string";
    public static final String USER_MODEL_ATTRIBUTE = "user.model.attribute";
    public static final String LDAP_ATTRIBUTE = "ldap.attribute";
    public static final String READ_ONLY = "read.only";
    public static final String ALWAYS_READ_VALUE_FROM_LDAP = "always.read.value.from.ldap";
    public static final String IS_MANDATORY_IN_LDAP = "is.mandatory.in.ldap";
    public static final String VALUE = "VALUE";
    public static final String ATTRIBUTE_VALUE = "${VALUE}";
    public static Pattern substitution = Pattern.compile("\\$\\{([^}]+)\\}");

    public UserAttributeTemplatedLDAPStorageMapper(ComponentModel mapperModel, LDAPStorageProvider ldapProvider) {
        super(mapperModel, ldapProvider);
    }

    public void onImportUserFromLDAP(LDAPObject ldapUser, UserModel user, RealmModel realm, boolean isCreate) {
        String userModelAttrName = this.getUserModelAttribute();
        String ldapAttrName = this.getLdapAttributeName();
        Property<Object> userModelProperty = userModelProperties.get(userModelAttrName.toLowerCase());
        if (userModelProperty != null) {
            String ldapAttrValue = ldapUser.getAttributeAsString(ldapAttrName);
            this.checkDuplicateEmail(userModelAttrName, ldapAttrValue, realm, this.ldapProvider.getSession(), user);
            this.setPropertyOnUserModel(userModelProperty, user, ldapAttrValue);
        } else {
            Set ldapAttrValue = ldapUser.getAttributeAsSet(ldapAttrName);
            if (ldapAttrValue != null) {
                user.setAttribute(userModelAttrName, new ArrayList(ldapAttrValue));
            } else {
                user.removeAttribute(userModelAttrName);
            }
        }
    }

    protected String computeAttributeValue(String template, String value) {
        Matcher matcher = substitution.matcher(template);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String token = matcher.group(1);
            if (token.equals(VALUE)) {
                matcher.appendReplacement(sb, value);
                continue;
            }
            matcher.appendReplacement(sb, token);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public void onRegisterUserToLDAP(LDAPObject ldapUser, UserModel localUser, RealmModel realm) {
        String template = this.getTemplate();
        String userModelAttrName = this.getUserModelAttribute();
        String ldapAttrName = this.getLdapAttributeName();
        boolean isMandatoryInLdap = UserAttributeTemplatedLDAPStorageMapper.parseBooleanParameter((ComponentModel)this.mapperModel, (String)IS_MANDATORY_IN_LDAP);
        Property<Object> userModelProperty = userModelProperties.get(userModelAttrName.toLowerCase());
        if (userModelProperty != null) {
            Object attrValue = userModelProperty.getValue((Object)localUser);
            if (attrValue == null) {
                if (isMandatoryInLdap) {
                    ldapUser.setSingleAttribute(ldapAttrName, " ");
                } else {
                    ldapUser.setAttribute(ldapAttrName, new LinkedHashSet());
                }
            } else {
                ldapUser.setSingleAttribute(ldapAttrName, this.computeAttributeValue(template, attrValue.toString()));
            }
        } else {
            List attrValues = localUser.getAttributeStream(userModelAttrName).collect(Collectors.toList());
            if (attrValues.size() == 0) {
                if (isMandatoryInLdap) {
                    ldapUser.setSingleAttribute(ldapAttrName, " ");
                } else {
                    ldapUser.setAttribute(ldapAttrName, new LinkedHashSet());
                }
            } else {
                logger.trace((Object)"Computing value from template for all the elements in the list");
                List newList = attrValues.stream().map(e -> this.computeAttributeValue(template, (String)e)).collect(Collectors.toList());
                ldapUser.setAttribute(ldapAttrName, new LinkedHashSet(newList));
            }
        }
        if (this.isReadOnly()) {
            ldapUser.addReadOnlyAttributeName(ldapAttrName);
        }
    }

    protected void checkDuplicateEmail(String userModelAttrName, String email, RealmModel realm, KeycloakSession session, UserModel user) {
        if (email == null || realm.isDuplicateEmailsAllowed()) {
            return;
        }
        if ("email".equalsIgnoreCase(userModelAttrName)) {
            email = KeycloakModelUtils.toLowerCaseSafe((String)email);
            UserModel that = session.users().getUserByEmail(realm, email);
            if (that != null && !that.getId().equals(user.getId())) {
                session.getTransactionManager().setRollbackOnly();
                String exceptionMessage = String.format("Can't import user '%s' from LDAP because email '%s' already exists in Keycloak. Existing user with this email is '%s'", user.getUsername(), email, that.getUsername());
                throw new ModelDuplicateException(exceptionMessage, "email");
            }
        }
    }

    protected void checkDuplicateUsername(String userModelAttrName, String username, RealmModel realm, KeycloakSession session, UserModel user) {
        if ("username".equalsIgnoreCase(userModelAttrName)) {
            boolean usernameChanged;
            if (username == null || username.isEmpty()) {
                throw new ModelException("Cannot set an empty username");
            }
            boolean bl = usernameChanged = !username.equals(user.getUsername());
            if (realm.isEditUsernameAllowed() && usernameChanged) {
                UserModel that = session.users().getUserByUsername(realm, username);
                if (that != null && !that.getId().equals(user.getId())) {
                    throw new ModelDuplicateException(String.format("Cannot change the username to '%s' because the username already exists in keycloak", username), "username");
                }
            } else if (usernameChanged) {
                throw new ModelException("Cannot change username if the realm is not configured to allow edit the usernames");
            }
        }
    }

    public UserModel proxy(LDAPObject ldapUser, UserModel delegate, RealmModel realm) {
        String ldapAttrName = this.mapperModel.get(LDAP_ATTRIBUTE);
        ldapUser.addReadOnlyAttributeName(ldapAttrName);
        return delegate;
    }

    public void beforeLDAPQuery(LDAPQuery query) {
        String ldapAttrName = this.getLdapAttributeName();
        query.addReturningLdapAttribute(ldapAttrName);
        if (this.isReadOnly()) {
            query.addReturningReadOnlyLdapAttribute(ldapAttrName);
        }
    }

    private String getTemplate() {
        return (String)this.mapperModel.getConfig().getFirst((Object)TEMPLATE_ATTRIBUTE);
    }

    private String getUserModelAttribute() {
        return (String)this.mapperModel.getConfig().getFirst((Object)USER_MODEL_ATTRIBUTE);
    }

    String getLdapAttributeName() {
        return (String)this.mapperModel.getConfig().getFirst((Object)LDAP_ATTRIBUTE);
    }

    private boolean isReadOnly() {
        return UserAttributeTemplatedLDAPStorageMapper.parseBooleanParameter((ComponentModel)this.mapperModel, (String)READ_ONLY);
    }

    protected void setPropertyOnUserModel(Property<Object> userModelProperty, UserModel user, String ldapAttrValue) {
        if (ldapAttrValue == null) {
            userModelProperty.setValue((Object)user, null);
        } else {
            Class clazz = userModelProperty.getJavaClass();
            if (String.class.equals((Object)clazz)) {
                userModelProperty.setValue((Object)user, (Object)ldapAttrValue);
            } else if (Boolean.class.equals((Object)clazz) || Boolean.TYPE.equals(clazz)) {
                Boolean boolVal = Boolean.valueOf(ldapAttrValue);
                userModelProperty.setValue((Object)user, (Object)boolVal);
            } else {
                logger.warnf("Don't know how to set the property '%s' on user '%s' . Value of LDAP attribute is '%s' ", (Object)userModelProperty.getName(), (Object)user.getUsername(), (Object)ldapAttrValue.toString());
            }
        }
    }
}

