package org.gcube.keycloak.protocol.oidc;

import org.gcube.keycloak.protocol.oidc.EOSCNodeAccessTokenIntrospectionProvider.Configuration;
import org.jboss.logging.Logger;
import org.keycloak.Config.Scope;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.protocol.oidc.TokenIntrospectionProvider;
import org.keycloak.protocol.oidc.TokenIntrospectionProviderFactory;
import org.keycloak.representations.AccessToken;

/**
 * @author <a href="mailto:mauro.mugnaini@nubisware.com">Mauro Mugnaini</a>
 */
public class EOSCNodeAccessTokenIntrospectionProviderFactory implements TokenIntrospectionProviderFactory {

    private static final Logger logger = Logger.getLogger(EOSCNodeAccessTokenIntrospectionProviderFactory.class);

    public static final String PROVIDER_ID = "eosc_node_access_token";

    protected Configuration eoscNodeConfiguration;

    @Override
    public String getId() {
        return PROVIDER_ID;
    }

    @Override
    public void init(Scope config) {
        this.eoscNodeConfiguration = new Configuration(config);
        if (!this.eoscNodeConfiguration.isConfigured()) {
            logger.warn("Provider factory is not configured properly, it will act as normal introspection endpoint");
        }
    }

    @Override
    public void postInit(KeycloakSessionFactory factory) {
    }

    @Override
    public TokenIntrospectionProvider create(KeycloakSession session) {
        return new EOSCNodeAccessTokenIntrospectionProvider<AccessToken>(session, eoscNodeConfiguration);
    }

    @Override
    public void close() {
    }

}
