/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.keycloak.protocol.oidc;

import org.gcube.keycloak.protocol.oidc.EOSCNodeAccessTokenIntrospectionProvider;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.protocol.oidc.TokenIntrospectionProvider;
import org.keycloak.protocol.oidc.TokenIntrospectionProviderFactory;

public class EOSCNodeAccessTokenIntrospectionProviderFactory
implements TokenIntrospectionProviderFactory {
    private static final Logger logger = Logger.getLogger(EOSCNodeAccessTokenIntrospectionProviderFactory.class);
    public static final String PROVIDER_ID = "access_token_with_myaccess";
    protected EOSCNodeAccessTokenIntrospectionProvider.MyAccessIDConfiguration myAccessIDConfiguration;

    public String getId() {
        return PROVIDER_ID;
    }

    public void init(Config.Scope config) {
        String introspectionURL = config.get("introspection-url");
        String clientId = config.get("client-id");
        String clientScret = config.get("client-secret");
        String[] claimRenaming = config.getArray("claim-renaming");
        this.myAccessIDConfiguration = new EOSCNodeAccessTokenIntrospectionProvider.MyAccessIDConfiguration(introspectionURL, clientId, clientScret, claimRenaming);
        logger.infof("EOSCNodeAccessTokenIntrospectionProviderFactory configuration is: %s", (Object)this.myAccessIDConfiguration.toString());
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public TokenIntrospectionProvider create(KeycloakSession session) {
        return new EOSCNodeAccessTokenIntrospectionProvider(session, this.myAccessIDConfiguration);
    }

    public void close() {
    }
}

