/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.keycloak.protocol.oidc;

import com.fasterxml.jackson.databind.node.ObjectNode;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.jboss.logging.Logger;
import org.keycloak.events.EventBuilder;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.JWSInputException;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.oidc.AccessTokenIntrospectionProvider;
import org.keycloak.protocol.oidc.TokenIntrospectionProvider;
import org.keycloak.representations.AccessToken;
import org.keycloak.services.Urls;
import org.keycloak.util.BasicAuthHelper;
import org.keycloak.util.JsonSerialization;

public class EOSCNodeAccessTokenIntrospectionProvider<T extends AccessToken>
extends AccessTokenIntrospectionProvider<T>
implements TokenIntrospectionProvider {
    private static final int SOCKET_TIMEOUT = 10000;
    private static final int CONNECTION_TIMEOUT = 5000;
    private static final Logger logger = Logger.getLogger(EOSCNodeAccessTokenIntrospectionProvider.class);
    protected static String serverIssuer;
    protected final MyAccessIDConfiguration myAccessIDConfiguration;

    public EOSCNodeAccessTokenIntrospectionProvider(KeycloakSession session, MyAccessIDConfiguration myAccessIDConfiguration) {
        super(session);
        if (serverIssuer == null) {
            serverIssuer = Urls.realmIssuer((URI)session.getContext().getUri().getBaseUri(), (String)session.getContext().getRealm().getName());
            logger.infof("Keycloak server instance 'issuer' is: %s", (Object)serverIssuer);
        }
        this.myAccessIDConfiguration = myAccessIDConfiguration;
    }

    public void close() {
        super.close();
    }

    public Response introspect(String accessTokenString, EventBuilder eventBuilder) {
        AccessToken accessToken = null;
        try {
            logger.debug((Object)"Deserializing the recevide access token");
            accessToken = (AccessToken)new JWSInput(accessTokenString).readJsonContent(AccessToken.class);
        }
        catch (JWSInputException e) {
            logger.error((Object)"Can't deserialize access token from string", (Throwable)e);
            eventBuilder.detail("reason", "Can't deserialize access token from string. Reason: " + e.getMessage());
            eventBuilder.error("token_introspection_failed");
            throw new RuntimeException("Error parsing access token string", e);
        }
        logger.trace((Object)"Getting the issuer from the access token");
        String tokenIssuer = accessToken.getIssuer();
        logger.debugf("Access token issued by: %s", (Object)tokenIssuer);
        if (serverIssuer.equals(tokenIssuer)) {
            logger.debugf("Token is issued by this server, introspect it internally", (Object)tokenIssuer);
            return super.introspect(accessTokenString, eventBuilder);
        }
        logger.debugf("Token is issued by server at %s, introspect it on MyAccess", (Object)tokenIssuer);
        return this.performIntrospectionOnMyAccess(accessTokenString);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Response performIntrospectionOnMyAccess(String accessTokenString) {
        logger.trace((Object)"Creating and perfom POST with the HTTP client");
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            logger.trace((Object)"Starting HTTP post creation");
            HttpPost httpPost = new HttpPost(this.myAccessIDConfiguration.getIntrospectionURL());
            logger.trace((Object)"Setting the Authorization header");
            httpPost.setHeader("Authorization", BasicAuthHelper.createHeader((String)this.myAccessIDConfiguration.getClientId(), (String)this.myAccessIDConfiguration.getClientScret()));
            logger.tracef("Setting the token parameter: %s", (Object)accessTokenString);
            ArrayList<BasicNameValuePair> form = new ArrayList<BasicNameValuePair>();
            form.add(new BasicNameValuePair("token", accessTokenString));
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(form, StandardCharsets.UTF_8);
            httpPost.setEntity((HttpEntity)entity);
            logger.tracef("Setting connection timeout to %d millis", 5000);
            logger.tracef("Setting socket timeout to %d millis", 10000);
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(5000).setSocketTimeout(10000).build();
            httpPost.setConfig(requestConfig);
            logger.debug((Object)"Performing the request...");
            try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);){
                int statusCode = response.getStatusLine().getStatusCode();
                logger.debugf("Resulting status code is %d", statusCode);
                logger.trace((Object)"Getting the response entity");
                HttpEntity responseEntity = response.getEntity();
                logger.trace((Object)"Reading the response body");
                String responseBodyString = responseEntity != null ? EntityUtils.toString((HttpEntity)responseEntity, (Charset)StandardCharsets.UTF_8) : "";
                logger.debugf("Resulting body is: %s", (Object)responseBodyString);
                if (statusCode >= 200 && statusCode < 300) {
                    ObjectNode myAccessIntrospectionResponseObjectNode = (ObjectNode)JsonSerialization.readValue((String)responseBodyString, ObjectNode.class);
                    if (!this.myAccessIDConfiguration.getClaimRenamings().isEmpty()) {
                        logger.debug((Object)"Performing the claim renaming...");
                        for (String originalClaimName : this.myAccessIDConfiguration.getClaimRenamings().keySet()) {
                            String newClaimName = this.myAccessIDConfiguration.getClaimRenamings().get(originalClaimName);
                            logger.tracef("Renaming the '%s' claim to '%s'", (Object)originalClaimName, (Object)newClaimName);
                            myAccessIntrospectionResponseObjectNode.set(newClaimName, myAccessIntrospectionResponseObjectNode.get(originalClaimName));
                            myAccessIntrospectionResponseObjectNode.remove(originalClaimName);
                        }
                    } else {
                        logger.debug((Object)"Claim renaming is not needed");
                    }
                    logger.tracef("Serializing response JSON object node as string", new Object[0]);
                    byte[] myAccessIntrospectionResponseBytes = JsonSerialization.writeValueAsBytes((Object)myAccessIntrospectionResponseObjectNode);
                    logger.tracef("Resulting response JSON string is: %s", (Object)myAccessIntrospectionResponseBytes);
                    Response response2 = Response.ok((Object)myAccessIntrospectionResponseBytes).type(MediaType.APPLICATION_JSON_TYPE).build();
                    return response2;
                }
                logger.errorf("MyAccess server response is not OK [%d]: %s", (Object)statusCode, (Object)responseBodyString);
                this.eventBuilder.detail("reason", responseBodyString);
                this.eventBuilder.error("token_introspection_failed");
                throw new RuntimeException("Error calling MyAccess for token introspection");
            }
        }
        catch (IOException e) {
            logger.error((Object)"An errord occurred performing the token introspection on MyAccess", (Throwable)e);
            this.eventBuilder.detail("reason", e.getMessage());
            this.eventBuilder.error("token_introspection_failed");
            throw new RuntimeException("Error performing the token introspection on MyAccess", e);
        }
    }

    public static class MyAccessIDConfiguration {
        private final String introspectionURL;
        private final String clientId;
        private final String clientScret;
        private final Map<String, String> claimRenamings;

        public MyAccessIDConfiguration(String introspectionURL, String clientId, String clientScret, String[] claimRenamings) {
            this.introspectionURL = introspectionURL;
            this.clientId = clientId;
            this.clientScret = clientScret;
            this.claimRenamings = new HashMap<String, String>();
            if (claimRenamings != null && claimRenamings.length > 0) {
                for (String claimRenaming : claimRenamings) {
                    String[] old2new = claimRenaming.split(":");
                    this.claimRenamings.put(old2new[0], old2new[1]);
                }
            }
        }

        public String getIntrospectionURL() {
            return this.introspectionURL;
        }

        public String getClientId() {
            return this.clientId;
        }

        public String getClientScret() {
            return this.clientScret;
        }

        public Map<String, String> getClaimRenamings() {
            return this.claimRenamings;
        }

        public String toString() {
            return "introspectionURL: " + this.getIntrospectionURL() + "; clientId: " + this.getClientId() + "; clientScret: " + (this.getClientScret() != null ? this.getClientScret().replaceAll(".", "*") : null) + "; claimRenamings: " + this.getClaimRenamings();
        }
    }
}

