package org.gcube.keycloak.protocol.oidc;

import org.gcube.keycloak.protocol.oidc.EOSCNodeAccessTokenIntrospectionProvider.MyAccessIDConfiguration;
import org.jboss.logging.Logger;
import org.keycloak.Config.Scope;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.protocol.oidc.TokenIntrospectionProvider;
import org.keycloak.protocol.oidc.TokenIntrospectionProviderFactory;
import org.keycloak.representations.AccessToken;

public class EOSCNodeAccessTokenIntrospectionProviderFactory implements TokenIntrospectionProviderFactory {

    private static final Logger logger = Logger.getLogger(EOSCNodeAccessTokenIntrospectionProviderFactory.class);

    public static final String PROVIDER_ID = "access_token_with_myaccess";

    protected MyAccessIDConfiguration myAccessIDConfiguration;

    @Override
    public String getId() {
        return PROVIDER_ID;
    }
    
    @Override
    public void init(Scope config) {
        String introspectionURL = config.get("introspection-url");
        String clientId = config.get("client-id");
        String clientScret = config.get("client-secret");
        String[] claimRenaming = config.getArray("claim-renaming");
        this.myAccessIDConfiguration = new MyAccessIDConfiguration(introspectionURL, clientId, clientScret,
                claimRenaming);

        logger.infof("EOSCNodeAccessTokenIntrospectionProviderFactory configuration is: %s",
                this.myAccessIDConfiguration.toString());
    }

    @Override
    public void postInit(KeycloakSessionFactory factory) {
    }

    @Override
    public TokenIntrospectionProvider create(KeycloakSession session) {
        return new EOSCNodeAccessTokenIntrospectionProvider<AccessToken>(session, myAccessIDConfiguration);
    }

    @Override
    public void close() {
    }

}
