package org.gcube.keycloak.protocol.oidc;

import org.gcube.keycloak.protocol.oidc.EOSCNodeAccessTokenIntrospectionProvider.MyAccessIDConfiguration;
import org.jboss.logging.Logger;
import org.keycloak.Config.Scope;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.oidc.AccessTokenIntrospectionProviderFactory;
import org.keycloak.protocol.oidc.TokenIntrospectionProvider;
import org.keycloak.representations.AccessToken;

public class AccessTokenIntrospectionProviderOverrideDefaultWithEOSCNodeFactory extends AccessTokenIntrospectionProviderFactory {

    private static final Logger logger = Logger.getLogger(AccessTokenIntrospectionProviderOverrideDefaultWithEOSCNodeFactory.class);

    protected MyAccessIDConfiguration myAccessIDConfiguration;

    @Override
    public int order() {
        // to be sure that the order is higher than the default
        return super.order() + 1;
    }
    
    @Override
    public void init(Scope config) {
        String introspectionURL = config.get("introspection-url");
        String clientId = config.get("client-id");
        String clientScret = config.get("client-secret");
        String[] claimRenaming = config.getArray("claim-renaming");
        this.myAccessIDConfiguration = new MyAccessIDConfiguration(introspectionURL, clientId, clientScret,
                claimRenaming);
        
        logger.infof("AccessTokenIntrospectionProviderOverrideDefaultWithEOSCNodeFactory configuration is: %s",
                this.myAccessIDConfiguration.toString());
    }

    @Override
    public TokenIntrospectionProvider create(KeycloakSession session) {
        return new EOSCNodeAccessTokenIntrospectionProvider<AccessToken>(session, myAccessIDConfiguration);
    }

}
