/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.environment.is;

import gr.uoa.di.madgik.commons.infra.nodeselection.NodeSelector;
import gr.uoa.di.madgik.environment.exception.EnvironmentInformationSystemException;
import gr.uoa.di.madgik.environment.exception.EnvironmentValidationException;
import gr.uoa.di.madgik.environment.hint.EnvHintCollection;
import gr.uoa.di.madgik.environment.is.IInformationSystemProvider;
import gr.uoa.di.madgik.environment.is.Query;
import gr.uoa.di.madgik.environment.is.elements.NodeInfo;
import java.util.List;

public class InformationSystemProvider
implements IInformationSystemProvider {
    private static IInformationSystemProvider StaticProvider = null;
    private static final Object lockMe = new Object();
    private IInformationSystemProvider Provider = null;
    private EnvHintCollection InitHints = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IInformationSystemProvider Init(String ProviderName, EnvHintCollection Hints) throws EnvironmentValidationException {
        try {
            Object object = lockMe;
            synchronized (object) {
                if (StaticProvider == null) {
                    StringBuffer classpath = new StringBuffer();
                    if (ProviderName.equals(InformationSystemProvider.class.getName())) {
                        throw new EnvironmentValidationException("Class " + InformationSystemProvider.class.getName() + " cannot be defined as provider");
                    }
                    Class<?> c = Class.forName(ProviderName);
                    Object o = c.newInstance();
                    if (!(o instanceof IInformationSystemProvider)) {
                        throw new EnvironmentValidationException("");
                    }
                    InformationSystemProvider prov = new InformationSystemProvider();
                    prov.Provider = (IInformationSystemProvider)o;
                    prov.InitHints = Hints;
                    StaticProvider = prov;
                }
            }
            return StaticProvider;
        }
        catch (Exception ex) {
            throw new EnvironmentValidationException("Could not initialize Information System Provider", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean IsInit() {
        Object object = lockMe;
        synchronized (object) {
            return StaticProvider != null;
        }
    }

    private EnvHintCollection MergeHints(EnvHintCollection Hints) {
        if (this.InitHints == null && Hints == null) {
            return new EnvHintCollection();
        }
        if (this.InitHints == null) {
            return Hints;
        }
        if (Hints == null) {
            return this.InitHints;
        }
        return this.InitHints.Merge(Hints);
    }

    @Override
    public List<String> RetrieveByQualifier(String qualifier, EnvHintCollection Hints) throws EnvironmentInformationSystemException {
        if (this.Provider == null) {
            throw new EnvironmentInformationSystemException("Provider not initialized");
        }
        return this.Provider.RetrieveByQualifier(qualifier, this.MergeHints(Hints));
    }

    @Override
    public List<String> Query(Query query, EnvHintCollection Hints) throws EnvironmentInformationSystemException {
        if (this.Provider == null) {
            throw new EnvironmentInformationSystemException("Provider not initialized");
        }
        return this.Provider.Query(query, this.MergeHints(Hints));
    }

    @Override
    public List<String> Query(String query, EnvHintCollection Hints) throws EnvironmentInformationSystemException {
        if (this.Provider == null) {
            throw new EnvironmentInformationSystemException("Provider not initialized");
        }
        return this.Provider.Query(query, this.MergeHints(Hints));
    }

    @Override
    public NodeInfo GetMatchingNode(String RankingExpression, String RequirementsExpression, EnvHintCollection Hints) throws EnvironmentInformationSystemException {
        if (this.Provider == null) {
            throw new EnvironmentInformationSystemException("Provider not initialized");
        }
        return this.Provider.GetMatchingNode(RankingExpression, RequirementsExpression, this.MergeHints(Hints));
    }

    @Override
    public NodeInfo GetMatchingNode(String RankingExpression, String RequirementsExpression, NodeSelector selector, EnvHintCollection Hints) throws EnvironmentInformationSystemException {
        if (this.Provider == null) {
            throw new EnvironmentInformationSystemException("Provider not initialized");
        }
        return this.Provider.GetMatchingNode(RankingExpression, RequirementsExpression, selector, this.MergeHints(Hints));
    }

    @Override
    public List<NodeInfo> GetMatchingNodes(String RankingExpression, String RequirementsExpression, EnvHintCollection Hints) throws EnvironmentInformationSystemException {
        if (this.Provider == null) {
            throw new EnvironmentInformationSystemException("Provider not initialized");
        }
        return this.Provider.GetMatchingNodes(RankingExpression, RequirementsExpression, this.MergeHints(Hints));
    }

    @Override
    public NodeInfo GetNode(String NodeID, EnvHintCollection Hints) throws EnvironmentInformationSystemException {
        if (this.Provider == null) {
            throw new EnvironmentInformationSystemException("Provider not initialized");
        }
        return this.Provider.GetNode(NodeID, this.MergeHints(Hints));
    }

    @Override
    public String RegisterNode(NodeInfo info, EnvHintCollection Hints) throws EnvironmentInformationSystemException {
        if (this.Provider == null) {
            throw new EnvironmentInformationSystemException("Provider not initialized");
        }
        return this.Provider.RegisterNode(info, this.MergeHints(Hints));
    }

    @Override
    public String GetGenericByID(String ID, EnvHintCollection Hints) throws EnvironmentInformationSystemException {
        if (this.Provider == null) {
            throw new EnvironmentInformationSystemException("Provider not initialized");
        }
        return this.Provider.GetGenericByID(ID, this.MergeHints(Hints));
    }

    @Override
    public List<String> GetGenericByName(String Name, EnvHintCollection Hints) throws EnvironmentInformationSystemException {
        if (this.Provider == null) {
            throw new EnvironmentInformationSystemException("Provider not initialized");
        }
        return this.Provider.GetGenericByName(Name, this.MergeHints(Hints));
    }

    @Override
    public String GetOpenSearchGenericByDescriptionDocumentURI(String URI2, EnvHintCollection Hints) throws EnvironmentInformationSystemException {
        if (this.Provider == null) {
            throw new EnvironmentInformationSystemException("Provider not initialized");
        }
        return this.Provider.GetOpenSearchGenericByDescriptionDocumentURI(URI2, this.MergeHints(Hints));
    }

    @Override
    public String CreateGenericResource(String genericContent, EnvHintCollection Hints) throws EnvironmentInformationSystemException {
        return this.Provider.CreateGenericResource(genericContent, Hints);
    }
}

