/*
 * Decompiled with CFR 0.152.
 */
package it.eng.rdlab.um.ldap;

import it.eng.rdlab.um.beans.GenericModel;
import it.eng.rdlab.um.beans.GenericModelWrapper;
import it.eng.rdlab.um.ldap.LdapDataModelWrapper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class LdapAbstractModelWrapper
implements LdapDataModelWrapper {
    protected GenericModelWrapper modelWrapper;
    protected List<String> objectClasses;
    protected Map<String, String> attributeMap;
    protected Map<String, List<String>> listAttributeMap;
    protected String dn;
    private Log log = LogFactory.getLog(this.getClass());

    public LdapAbstractModelWrapper(GenericModel model) {
        this.log.debug((Object)"init");
        this.attributeMap = new HashMap<String, String>();
        this.listAttributeMap = new HashMap<String, List<String>>();
        this.initModel(model);
    }

    private void initModel(GenericModel model) {
        this.log.debug((Object)"init model");
        this.log.debug((Object)"loading main parameters");
        this.modelWrapper = new GenericModelWrapper(model);
        Map objectMap = this.modelWrapper.getObjectMap();
        this.objectClasses = (List)this.modelWrapper.getObjectParameter("OBJECTCLASSES");
        this.log.debug((Object)"loading attributes");
        for (String key : objectMap.keySet()) {
            Object value = objectMap.get(key);
            this.log.debug((Object)("loading attribute " + key + " = " + value));
            if (!key.equals("OBJECTCLASSES") && value instanceof String) {
                this.attributeMap.put(key, (String)value);
                this.log.debug((Object)"Attribute loaded");
                continue;
            }
            if (!key.equals("OBJECTCLASSES") && value instanceof List) {
                this.listAttributeMap.put(key, (List)value);
                this.log.debug((Object)"Attribute loaded");
                continue;
            }
            this.log.debug((Object)("Attribute " + key + "," + value + " refused"));
        }
    }

    public String getStringParameter(String name) {
        return this.modelWrapper.getStringParameter(name);
    }

    public Object getObjectParameter(String name) {
        return this.modelWrapper.getObjectParameter(name);
    }

    public Map<String, Object> getObjectMap() {
        return this.modelWrapper.getObjectMap();
    }

    @Override
    public List<String> getObjectClasses() {
        return this.objectClasses;
    }

    @Override
    public Map<String, String> getAttributeMap() {
        return this.attributeMap;
    }

    @Override
    public String getDistinguishedName() {
        return this.dn;
    }

    @Override
    public Map<String, List<String>> getListAttributeMap() {
        return this.listAttributeMap;
    }
}

