/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.io.jsonwebtoken.impl.io;

import java.io.OutputStream;
import java.util.Map;
import org.gcube.io.jsonwebtoken.io.AbstractSerializer;
import org.gcube.io.jsonwebtoken.io.SerializationException;
import org.gcube.io.jsonwebtoken.io.Serializer;
import org.gcube.io.jsonwebtoken.lang.Assert;

public class NamedSerializer
extends AbstractSerializer<Map<String, ?>> {
    private final String name;
    private final Serializer<Map<String, ?>> DELEGATE;

    public NamedSerializer(String name, Serializer<Map<String, ?>> serializer) {
        this.DELEGATE = (Serializer)Assert.notNull(serializer, (String)"JSON Serializer cannot be null.");
        this.name = (String)Assert.hasText((CharSequence)name, (String)"Name cannot be null or empty.");
    }

    protected void doSerialize(Map<String, ?> m, OutputStream out) throws SerializationException {
        try {
            this.DELEGATE.serialize(m, out);
        }
        catch (Throwable t) {
            String msg = String.format("Cannot serialize %s to JSON. Cause: %s", this.name, t.getMessage());
            throw new SerializationException(msg, t);
        }
    }
}

