/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears.managers;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterRegistration;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import jakarta.servlet.ServletRegistration;
import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.gcube.common.events.Observes;
import org.gcube.smartgears.configuration.application.ApplicationHandlers;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.gcube.smartgears.context.container.ContainerContext;
import org.gcube.smartgears.extensions.ApplicationExtension;
import org.gcube.smartgears.extensions.RequestExceptionBarrier;
import org.gcube.smartgears.handlers.application.ApplicationLifecycleEvent;
import org.gcube.smartgears.handlers.application.ApplicationLifecycleHandler;
import org.gcube.smartgears.handlers.application.ApplicationPipeline;
import org.gcube.smartgears.handlers.application.RequestHandler;
import org.gcube.smartgears.lifecycle.application.ApplicationState;
import org.gcube.smartgears.lifecycle.container.ContainerLifecycle;
import org.gcube.smartgears.managers.RequestManager;
import org.gcube.smartgears.provider.ProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationManager {
    private static Logger log = LoggerFactory.getLogger(ApplicationManager.class);
    private ApplicationPipeline<ApplicationLifecycleHandler> lifecyclePipeline;
    private ApplicationContext context;
    private List<ApplicationExtension> extensions;

    public ApplicationContext start(ContainerContext container, ServletContext application) {
        try {
            this.context = ProviderFactory.provider().contextFor(container, application);
            for (Map.Entry servlet : application.getServletRegistrations().entrySet()) {
                log.trace("servlet {} :  {} {} ", new Object[]{application.getServletContextName(), servlet.getKey(), ((ServletRegistration)servlet.getValue()).getMappings()});
            }
            this.context.configuration().validate();
            this.saveApplicationState();
            this.shareContextWith(application);
            this.registerObservers();
            ApplicationHandlers handlers = ProviderFactory.provider().handlersFor(this.context);
            List<ApplicationLifecycleHandler> lifecycleHandlers = handlers.lifecycleHandlers();
            List<RequestHandler> requestHandlers = handlers.requestHandlers();
            log.trace("managing {} lifecycle with {}", (Object)this.context.name(), lifecycleHandlers);
            log.trace("managing {} requests with {}", (Object)this.context.name(), requestHandlers);
            log.trace("extending {} API with {}", (Object)this.context.name(), this.extensions);
            this.extensions = ProviderFactory.provider().extensionsFor(this.context);
            this.registerExtension(this.extensions);
            this.registerHandlersAsFilter(requestHandlers);
            this.start(lifecycleHandlers);
            this.context.configuration().context(application.getContextPath());
            this.context.lifecycle().moveTo(ApplicationState.active);
            return this.context;
        }
        catch (RuntimeException e) {
            if (this.context != null) {
                log.error("error starting application {}", (Object)this.context.name(), (Object)e);
                this.context.lifecycle().moveTo(ApplicationState.failed);
            } else {
                log.error("error starting application with context not initialized", (Throwable)e);
            }
            throw e;
        }
    }

    private void saveApplicationState() {
        File file = this.context.persistence().file("endpoint.xml");
        try (ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(file));){
            oos.writeObject(this.context.id());
        }
        catch (Exception e) {
            log.error("error serializing application {} state", (Object)this.context.name());
            throw new RuntimeException(e);
        }
    }

    public void stop() {
        if (this.context == null) {
            return;
        }
        log.info("stopping {} management", (Object)this.context.name());
        try {
            this.context.lifecycle().tryMoveTo(ApplicationState.stopped);
            this.context.events().fire((Object)this.context, new String[]{"stop"});
            if (this.extensions != null) {
                this.unregister(this.extensions);
            }
            this.stopLifecycleHandlers();
            log.info("stopping application events for {}", (Object)this.context.name());
            this.context.events().stop();
        }
        catch (Exception e) {
            log.warn("cannot stop {} management (see cause)", (Object)this.context.name(), (Object)e);
        }
    }

    private void registerHandlersAsFilter(List<RequestHandler> rqHandlers) {
        ServletContext app = this.context.application();
        String appName = app.getContextPath().replace("/", "");
        RequestManager requestFilter = new RequestManager(this.context, appName, rqHandlers);
        FilterRegistration.Dynamic filter = app.addFilter(appName + "-filter", (Filter)requestFilter);
        filter.addMappingForUrlPatterns(null, false, new String[]{"/*"});
    }

    private void registerExtension(List<ApplicationExtension> extensions) {
        ServletContext application = this.context.application();
        for (ApplicationExtension extension : extensions) {
            try {
                extension.init(this.context);
                if (this.context.configuration().includes().isEmpty()) {
                    this.context.configuration().excludes().addAll(extension.excludes());
                }
                String mapping = extension.mapping();
                application.addServlet(this.context.configuration().name() + "-" + extension.name(), (Servlet)extension).addMapping(new String[]{mapping});
                RequestExceptionBarrier barrier = new RequestExceptionBarrier();
                FilterRegistration.Dynamic filter = application.addFilter("exception-barrier", (Filter)barrier);
                filter.addMappingForUrlPatterns(null, false, new String[]{mapping});
                log.info("registered API extension {} @ {}", (Object)extension.name(), (Object)mapping);
            }
            catch (Exception e) {
                throw new RuntimeException("cannot register API extension " + extension.name(), e);
            }
        }
    }

    private void unregister(List<ApplicationExtension> extensions) {
        for (ApplicationExtension extension : extensions) {
            extension.stop();
        }
    }

    private void start(List<ApplicationLifecycleHandler> handlers) {
        try {
            this.lifecyclePipeline = new ApplicationPipeline<ApplicationLifecycleHandler>(handlers);
            this.lifecyclePipeline.forward(new ApplicationLifecycleEvent.Start(this.context));
        }
        catch (RuntimeException e) {
            this.context.lifecycle().tryMoveTo(ApplicationState.failed);
            throw e;
        }
    }

    private void stopLifecycleHandlers() {
        if (this.lifecyclePipeline == null) {
            return;
        }
        ApplicationPipeline<ApplicationLifecycleHandler> returnPipeline = this.lifecyclePipeline.reverse();
        returnPipeline.forward(new ApplicationLifecycleEvent.Stop(this.context));
    }

    private void registerObservers() {
        Object observer = new Object(){

            @Observes(value={"stop"}, kind=Observes.Kind.critical)
            void onStopOf(ContainerLifecycle ignore) {
                if (!ApplicationManager.this.context.lifecycle().tryMoveTo(ApplicationState.stopped)) {
                    log.warn("cannot stop {} after container has stopped", (Object)ApplicationManager.this.context.name());
                }
            }
        };
        this.context.container().events().subscribe(observer);
        this.context.application().addListener((EventListener)new ServletContextListener(){

            public void contextInitialized(ServletContextEvent sce) {
                log.info("initilizing context {} ", (Object)ApplicationManager.this.context.name());
                ApplicationManager.this.context.events().fire((Object)ApplicationManager.this.context, new String[]{"activation"});
                log.info("webApp {} initialized ", (Object)ApplicationManager.this.context.name());
            }

            public void contextDestroyed(ServletContextEvent sce) {
                try {
                    log.info("stopping {} on undeployment|shutdown", (Object)ApplicationManager.this.context.name());
                    ApplicationManager.this.stop();
                    log.info("suspending undeployment|shutdow to allow {} to stop gracefully", (Object)ApplicationManager.this.context.name());
                    TimeUnit.SECONDS.sleep(3L);
                    log.info("resuming undeployment|shutdow after stopping {}", (Object)ApplicationManager.this.context.name());
                }
                catch (InterruptedException e) {
                    log.warn(ApplicationManager.this.context.name() + " cannot gracefully stop on undeployment|shutdow", (Throwable)e);
                }
            }
        });
    }

    private void shareContextWith(ServletContext application) {
        application.setAttribute("gcube-application-context", (Object)this.context);
    }
}

