/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.io.jsonwebtoken.impl.security;

import java.math.BigInteger;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.util.Set;
import org.gcube.io.jsonwebtoken.impl.lang.Parameter;
import org.gcube.io.jsonwebtoken.impl.lang.Parameters;
import org.gcube.io.jsonwebtoken.impl.security.AbstractPrivateJwk;
import org.gcube.io.jsonwebtoken.impl.security.DefaultEcPublicJwk;
import org.gcube.io.jsonwebtoken.impl.security.FieldElementConverter;
import org.gcube.io.jsonwebtoken.impl.security.JwkContext;
import org.gcube.io.jsonwebtoken.lang.Collections;
import org.gcube.io.jsonwebtoken.security.EcPrivateJwk;
import org.gcube.io.jsonwebtoken.security.EcPublicJwk;
import org.gcube.io.jsonwebtoken.security.PrivateJwk;

class DefaultEcPrivateJwk
extends AbstractPrivateJwk<ECPrivateKey, ECPublicKey, EcPublicJwk>
implements EcPrivateJwk {
    static final Parameter<BigInteger> D = (Parameter)Parameters.bigInt("d", "ECC Private Key").setConverter(FieldElementConverter.B64URL_CONVERTER).setSecret(true).build();
    static final Set<Parameter<?>> PARAMS = Collections.concat(DefaultEcPublicJwk.PARAMS, (Object[])new Parameter[]{D});

    DefaultEcPrivateJwk(JwkContext<ECPrivateKey> ctx, EcPublicJwk pubJwk) {
        super(ctx, DefaultEcPublicJwk.THUMBPRINT_PARAMS, pubJwk);
    }

    @Override
    protected boolean equals(PrivateJwk<?, ?, ?> jwk) {
        return jwk instanceof EcPrivateJwk && DefaultEcPublicJwk.equalsPublic(this, jwk) && Parameters.equals(this, jwk, D);
    }
}

